/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.host.Host;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.webapp.Application;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransportConstraint
extends AbstractConstraint {
    private String _transport;

    public TransportConstraint() {
    }

    public TransportConstraint(String transport) {
        this._transport = transport;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this._transport = transportGuarantee;
    }

    public boolean isPrivateCache() {
        return false;
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        if (this._transport == null) {
            return true;
        }
        if (request.isSecure()) {
            return true;
        }
        Application app = (Application)application;
        Host host = (Host)app.getParent();
        String secureHost = host.getSecureHostName();
        if (secureHost != null) {
            String url = "https://" + secureHost + app.getContextPath() + request.getServletPath();
            if (request.getPathInfo() != null) {
                url = url + request.getPathInfo();
            }
            if (request.getQueryString() != null) {
                url = url + "?" + request.getQueryString();
            }
            response.sendRedirect(url);
            return false;
        }
        String url = request.getRequestURL().toString();
        if (url.startsWith("http:") && request.getServerPort() == 80) {
            url = "https:" + url.substring(5);
            String queryString = request.getQueryString();
            if (queryString != null) {
                response.sendRedirect(url + "?" + queryString);
            } else {
                response.sendRedirect(url);
            }
            return false;
        }
        response.sendError(403, null);
        return false;
    }
}

