/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceCollection {
    static L10N L = new L10N(WebResourceCollection.class);
    private String _webResourceName;
    private String _description;
    private ArrayList<String> _methodList;
    private ArrayList<Pattern> _urlPatternList = new ArrayList();

    public void setWebResourceName(String name) {
        this._webResourceName = name;
    }

    public void setDescription(String name) {
        this._description = name;
    }

    public void addURLPattern(String pattern) throws PatternSyntaxException {
        String regexpPattern = UrlMap.urlPatternToRegexpPattern(pattern);
        int flags = CauchoSystem.isCaseInsensitive() ? 2 : 0;
        Pattern regexp = Pattern.compile(regexpPattern, flags);
        this._urlPatternList.add(regexp);
    }

    public ArrayList getURLPatternList() {
        return this._urlPatternList;
    }

    public void addMethod(String method) {
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public void addHttpMethod(String method) {
        if (!Pattern.matches("[a-zA-Z]+", method)) {
            throw new ConfigException(L.l("'{0}' is not a valid http-method.", (Object)method));
        }
        if (this._methodList == null) {
            this._methodList = new ArrayList();
        }
        this._methodList.add(method);
    }

    public ArrayList<String> getMethods() {
        return this._methodList;
    }

    public boolean isMatch(String url) {
        if (this._urlPatternList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this._urlPatternList.size(); ++i) {
            Pattern pattern = this._urlPatternList.get(i);
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;

    }
}

