/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.Store;
import com.caucho.server.security.AbstractAuthenticator;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements HttpSession,
CacheListener {
    protected static final Logger log = Logger.getLogger(SessionImpl.class.getName());
    static final L10N L = new L10N(SessionImpl.class);
    static final String LOGIN = "caucho.login";
    private String _id;
    protected SessionManager _manager;
    protected Map<String, Object> _values;
    private long _creationTime;
    long _accessTime;
    long _maxInactiveInterval;
    private boolean _isNew = true;
    boolean _isValid = true;
    boolean _isClosing = false;
    boolean _isInvalidating = false;
    private int _useCount;
    private ClusterObject _clusterObject;
    private Principal _user;
    private int _srunIndex = -1;
    private static Comparator KEY_COMPARATOR = new Comparator(){

        public int compare(Object aObj, Object bObj) {
            Map.Entry a = (Map.Entry)aObj;
            Map.Entry b = (Map.Entry)bObj;
            String aStr = (String)a.getKey();
            String bStr = (String)b.getKey();
            return aStr.compareTo(bStr);
        }
    };

    public SessionImpl(SessionManager manager, String id, long creationTime) {
        this._manager = manager;
        this._creationTime = creationTime;
        this._accessTime = creationTime;
        this._maxInactiveInterval = manager.getSessionTimeout();
        this._id = id;
        char ch = id.charAt(0);
        int length = manager.getSrunLength();
        this._srunIndex = length > 0 ? SessionManager.decode(ch) % length : 0;
        this._values = this.createValueMap();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " new");
        }
    }

    public long getCreationTime() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getCreationTime() when session is no longer valid.", (Object)this));
        }
        return this._creationTime;
    }

    public String getId() {
        return this._id;
    }

    int getSrunIndex() {
        return this._srunIndex;
    }

    void setClusterObject(ClusterObject clusterObject) {
        this._clusterObject = clusterObject;
        if (clusterObject != null) {
            clusterObject.update();
        }
    }

    public long getLastAccessedTime() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getLastAccessedTime() when session is no longer valid.", (Object)this));
        }
        return this._accessTime;
    }

    public int getMaxInactiveInterval() {
        if (0x3FFFFFFFFFFFFFFFL <= this._maxInactiveInterval) {
            return -1;
        }
        return (int)(this._maxInactiveInterval / 1000L);
    }

    public void setMaxInactiveInterval(int value) {
        this._maxInactiveInterval = value < 0 ? 0x3FFFFFFFFFFFFFFFL : (long)value * 1000L;
        if (this._clusterObject != null) {
            this._clusterObject.setExpireInterval(this._maxInactiveInterval);
        }
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public ServletContext getServletContext() {
        return this._manager.getWebApp();
    }

    public SessionManager getManager() {
        return this._manager;
    }

    public ServletAuthenticator getAuthenticator() {
        return this._manager.getWebApp().getAuthenticator();
    }

    public Principal getUser() {
        if (this._user != null) {
            return this._user;
        }
        if (this._isValid) {
            Object user = this.getAttribute(LOGIN);
            if (user instanceof Principal) {
                this._user = (Principal)user;
            } else if (user instanceof LoginPrincipal) {
                this._user = ((LoginPrincipal)user).getUser();
            }
        }
        return this._user;
    }

    public void setUser(Principal user) {
        this._user = user;
        if (user == null) {
            this.removeAttribute(LOGIN);
        } else if (user instanceof Serializable) {
            this.setAttribute(LOGIN, user);
        } else {
            this.setAttribute(LOGIN, new LoginPrincipal(user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getAttribute() when session is no longer valid.", (Object)this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            Object value = this._values.get(name);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ArrayList<HttpSessionAttributeListener> listeners;
        HttpSessionBindingListener listener;
        Object oldValue;
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call setAttribute(String, Object) when session is no longer valid.", (Object)this));
        }
        if (value != null && !(value instanceof Serializable) && log.isLoggable(Level.FINE)) {
            log.fine(L.l("{0} attribute '{1}' value is non-serializable type '{2}'", (Object)this, (Object)name, (Object)value.getClass().getName()));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = value != null ? this._values.put(name, value) : this._values.remove(name);
        }
        if (this._clusterObject != null) {
            this._clusterObject.change();
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null && listeners.size() > 0) {
            HttpSessionBindingEvent event = oldValue != null ? new HttpSessionBindingEvent((HttpSession)this, name, oldValue) : new HttpSessionBindingEvent((HttpSession)this, name, value);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener2 = listeners.get(i);
                if (oldValue != null) {
                    listener2.attributeReplaced(event);
                    continue;
                }
                listener2.attributeAdded(event);
            }
        }
    }

    protected Map<String, Object> createValueMap() {
        return new Hashtable<String, Object>(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call removeAttribute(String) when session is no longer valid.", (Object)this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = this._values.remove(name);
        }
        if (this._clusterObject != null && oldValue != null) {
            this._clusterObject.change();
        }
        this.notifyValueUnbound(name, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("{0} can't call getAttributeNames() when session is no longer valid.", (Object)this));
            }
            return Collections.enumeration(this._values.keySet());
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("{0} can't call getValueNames() when session is no longer valid.", (Object)this));
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] s = new String[this._values.size()];
            Enumeration e = this.getAttributeNames();
            int count = 0;
            while (e.hasMoreElements()) {
                s[count++] = (String)e.nextElement();
            }
            return s;
        }
    }

    public boolean isNew() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0} can't call isNew() when session is no longer valid.", (Object)this));
        }
        return this._isNew;
    }

    public boolean isValid() {
        return this._isValid;
    }

    boolean isClosing() {
        return this._isClosing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this._isInvalidating || this._useCount <= 0) {
                this._isClosing = true;
            }
        }
        if (!this._isClosing) {
            log.warning(L.l("{0} LRU while in use (use-count={1}).  Consider increasing session-count.", (Object)this, this._useCount));
        }
        boolean isValid = this._isValid;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " remove");
        }
        long now = Alarm.getCurrentTime();
        Store store = this._manager.getSessionStore();
        if (this._isInvalidating || store == null || this._accessTime + (long)this.getMaxInactiveInterval() < now) {
            this.notifyDestroy();
        }
        this.invalidateLocal();
    }

    private void notifyDestroy() {
        ArrayList<HttpSessionListener> listeners = this._manager.getListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = listeners.size() - 1; i >= 0; --i) {
                HttpSessionListener listener = listeners.get(i);
                listener.sessionDestroyed(event);
            }
        }
    }

    public void invalidate() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalidate");
        }
        this._isInvalidating = true;
        this.invalidate(Logout.INVALIDATE);
    }

    public void invalidateLogout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout");
        }
        this._isInvalidating = true;
        this.invalidate(Logout.INVALIDATE);
    }

    void invalidateTimeout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " timeout");
        }
        this.invalidate(Logout.TIMEOUT);
    }

    void invalidateLru() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " lru");
        }
        this.invalidateImpl(Logout.LRU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(Logout logout) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: Can't call invalidate() when session is no longer valid.", (Object)this));
        }
        try {
            ServletAuthenticator auth = this.getAuthenticator();
            if (!(auth instanceof AbstractAuthenticator) || logout == Logout.INVALIDATE || logout == Logout.TIMEOUT && ((AbstractAuthenticator)auth).getLogoutOnSessionTimeout()) {
                this.logout(logout == Logout.TIMEOUT ? this : null);
            }
            this._manager.removeSession(this);
            this.invalidateImpl(logout);
            Object var4_3 = null;
            this._isValid = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._isValid = false;
            throw throwable;
        }
    }

    public void logout() {
        this.logout(null);
    }

    public void logout(SessionImpl timeoutSession) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout " + timeoutSession);
        }
        if (this._user != null) {
            if (this._isValid) {
                this.removeAttribute(LOGIN);
            }
            Principal user = this._user;
            this._user = null;
            try {
                ServletAuthenticator auth = this.getAuthenticator();
                if (auth != null) {
                    auth.logout(this._manager.getWebApp(), timeoutSession, this._id, user);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    private void invalidateImpl(Logout logout) {
        boolean invalidateAfterListener = this._manager.isInvalidateAfterListener();
        if (!invalidateAfterListener) {
            this._isValid = false;
        }
        try {
            ClusterObject clusterObject = this._clusterObject;
            if (clusterObject != null && this._isInvalidating) {
                clusterObject.remove();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.invalidateLocal();
    }

    private void invalidateLocal() {
        ClusterObject clusterObject = this._clusterObject;
        if (this._isValid && !this._isInvalidating && clusterObject != null && this._manager.isSaveOnlyOnShutdown()) {
            clusterObject.update();
            try {
                clusterObject.store(this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, this + ": can't serialize session", e);
            }
        }
        this.unbind();
    }

    void create(long now) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create session");
        }
        if (this._isValid) {
            this.unbind();
        }
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
        if (this._clusterObject != null) {
            this._clusterObject.setValid();
        }
    }

    public boolean inUse() {
        return this._useCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addUse() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this._isClosing) {
                return false;
            }
            ++this._useCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endUse() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            --this._useCount;
        }
    }

    void reset(long now) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " reset");
        }
        this.unbind();
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
    }

    public boolean load() {
        if (!this._isValid) {
            return false;
        }
        if (this._useCount > 1) {
            return true;
        }
        ClusterObject clusterObject = this._clusterObject;
        boolean isValid = clusterObject != null ? clusterObject.load(this) : true;
        return isValid;
    }

    public void passivate() {
        this.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        if (this._values.size() == 0) {
            return;
        }
        ClusterObject clusterObject = this._clusterObject;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Map<String, Object> map = this._values;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this._values.entrySet()) {
                names.add(entry.getKey());
                values.add(entry.getValue());
            }
            this._values.clear();
        }
        if (clusterObject != null) {
            clusterObject.update();
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object value = values.get(i);
            this.notifyValueUnbound(name, value);
        }
    }

    private void notifyValueUnbound(String name, Object oldValue) {
        ArrayList<HttpSessionAttributeListener> listeners;
        if (oldValue == null) {
            return;
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener = listeners.get(i);
                listener.attributeRemoved(event);
            }
        }
    }

    void setAccess(long now) {
        if (this._useCount > 1) {
            return;
        }
        this._isNew = false;
        if (this._clusterObject != null) {
            this._clusterObject.access();
        }
        this._accessTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        SessionImpl sessionImpl;
        this._accessTime = Alarm.getCurrentTime();
        SessionImpl sessionImpl2 = this;
        synchronized (sessionImpl2) {
            if (this._useCount > 1) {
                --this._useCount;
                return;
            }
        }
        try {
            this.saveAfterRequest();
            Object var4_3 = null;
            sessionImpl = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SessionImpl sessionImpl3 = this;
            synchronized (sessionImpl3) {
                --this._useCount;
            }
            throw throwable;
        }
        synchronized (sessionImpl) {
            --this._useCount;
        }
    }

    public final void saveBeforeFlush() {
        if (this._manager == null || !this._manager.isSaveBeforeFlush()) {
            return;
        }
        this.save();
    }

    public final void saveBeforeHeaders() {
        if (this._manager == null || !this._manager.isSaveBeforeHeaders()) {
            return;
        }
        this.save();
    }

    public final void saveAfterRequest() {
        if (this._manager == null || !this._manager.isSaveAfterRequest()) {
            return;
        }
        this.save();
    }

    public final void save() {
        if (!this.isValid()) {
            return;
        }
        try {
            ClusterObject clusterObject = this._clusterObject;
            if (clusterObject != null) {
                clusterObject.store(this);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, this + ": can't serialize session", e);
        }
    }

    void saveOnShutdown() {
        try {
            ClusterObject clusterObject = this._clusterObject;
            if (clusterObject != null) {
                clusterObject.change();
                clusterObject.store(this);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, this + ": can't serialize session", e);
        }
    }

    public boolean isEmpty() {
        return this._values == null || this._values.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Hessian2Input in) throws IOException {
        HttpSessionEvent event = null;
        Map<String, Object> map = this._values;
        synchronized (map) {
            int i;
            this.unbind();
            try {
                int size = in.readInt();
                for (i = 0; i < size; ++i) {
                    String key = in.readString();
                    Object value = in.readObject();
                    if (value == null) continue;
                    Map<String, Object> map2 = this._values;
                    synchronized (map2) {
                        this._values.put(key, value);
                    }
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    if (event == null) {
                        event = new HttpSessionEvent((HttpSession)this);
                    }
                    listener.sessionDidActivate(event);
                }
            }
            catch (Exception e) {
                throw IOExceptionWrapper.create((Exception)e);
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionDidActivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Hessian2Output out) throws IOException {
        HttpSessionEvent event = null;
        Map<String, Object> map = this._values;
        synchronized (map) {
            Set set = this.getEntrySet();
            int size = set == null ? 0 : set.size();
            out.writeInt(size);
            if (size == 0) {
                return;
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (int i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionWillPassivate(event);
            }
            boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
            Map.Entry[] entries = new Map.Entry[set.size()];
            Iterator iter = set.iterator();
            int i = 0;
            while (iter.hasNext()) {
                entries[i++] = (Map.Entry)iter.next();
            }
            Arrays.sort(entries, KEY_COMPARATOR);
            for (i = 0; i < entries.length; ++i) {
                Map.Entry entry = entries[i];
                Object value = entry.getValue();
                out.writeString((String)entry.getKey());
                if (ignoreNonSerializable && !(value instanceof Serializable)) {
                    out.writeObject(null);
                    continue;
                }
                if (value instanceof HttpSessionActivationListener) {
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    if (event == null) {
                        event = new HttpSessionEvent((HttpSession)this);
                    }
                    listener.sessionWillPassivate(event);
                }
                try {
                    out.writeObject(value);
                    continue;
                }
                catch (NotSerializableException e) {
                    log.warning(L.l("{0}: failed storing persistent session attribute '{1}'.  Persistent session values must extend java.io.Serializable.\n{2}", (Object)this, entry.getKey(), (Object)String.valueOf(e)));
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ObjectInput in) throws IOException {
        HttpSessionEvent event = null;
        Map<String, Object> map = this._values;
        synchronized (map) {
            int i;
            this._values.clear();
            try {
                int size = in.readInt();
                for (i = 0; i < size; ++i) {
                    String key = in.readUTF();
                    Object value = in.readObject();
                    if (value == null) continue;
                    Map<String, Object> map2 = this._values;
                    synchronized (map2) {
                        this._values.put(key, value);
                    }
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    if (event == null) {
                        event = new HttpSessionEvent((HttpSession)this);
                    }
                    listener.sessionDidActivate(event);
                }
            }
            catch (Exception e) {
                throw IOExceptionWrapper.create((Exception)e);
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionDidActivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ObjectOutput out) throws IOException {
        HttpSessionEvent event = null;
        Map<String, Object> map = this._values;
        synchronized (map) {
            Set set = this.getEntrySet();
            int size = set == null ? 0 : set.size();
            out.writeInt(size);
            if (size == 0) {
                return;
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            for (int i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = listeners.get(i);
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionWillPassivate(event);
            }
            boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
            Map.Entry[] entries = new Map.Entry[set.size()];
            Iterator iter = set.iterator();
            int i = 0;
            while (iter.hasNext()) {
                entries[i++] = (Map.Entry)iter.next();
            }
            Arrays.sort(entries, KEY_COMPARATOR);
            for (i = 0; i < entries.length; ++i) {
                Map.Entry entry = entries[i];
                Object value = entry.getValue();
                out.writeUTF((String)entry.getKey());
                if (ignoreNonSerializable && !(value instanceof Serializable)) {
                    out.writeObject(null);
                    continue;
                }
                if (value instanceof HttpSessionActivationListener) {
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    if (event == null) {
                        event = new HttpSessionEvent((HttpSession)this);
                    }
                    listener.sessionWillPassivate(event);
                }
                try {
                    out.writeObject(value);
                    continue;
                }
                catch (NotSerializableException e) {
                    log.warning(L.l("{0}: failed storing persistent session attribute '{1}'.  Persistent session values must extend java.io.Serializable.\n{2}", (Object)this, entry.getKey(), (Object)String.valueOf(e)));
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getEntrySet() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("{0}: can't call getEntrySet() when session is no longer valid.", (Object)this));
            }
            return this._values.entrySet();
        }
    }

    public boolean canLog() {
        return log.isLoggable(Level.FINE);
    }

    public void log(String value) {
        log.fine(value);
    }

    public String toString() {
        WebApp webApp;
        String contextPath = "";
        SessionManager manager = this._manager;
        if (manager != null && (webApp = manager.getWebApp()) != null) {
            contextPath = "," + webApp.getContextPath();
        }
        return "SessionImpl[" + this.getId() + contextPath + "]";
    }

    static class LoginPrincipal
    implements Serializable {
        private transient Principal _user;

        LoginPrincipal(Principal user) {
            this._user = user;
        }

        public Principal getUser() {
            return this._user;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Logout {
        INVALIDATE,
        LRU,
        TIMEOUT;

    }
}

