/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.JndiBuilder;
import com.caucho.config.types.Period;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManagerAdmin;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionManager
implements ObjectManager,
AlarmListener {
    protected static final L10N L = new L10N(SessionManager.class);
    protected static final Logger log = Logger.getLogger(SessionManager.class.getName());
    private static final int FALSE = 0;
    private static final int COOKIE = 1;
    private static final int TRUE = 2;
    private static final int UNSET = 0;
    private static final int SET_TRUE = 1;
    private static final int SET_FALSE = 2;
    private static final int SAVE_BEFORE_HEADERS = 1;
    private static final int SAVE_BEFORE_FLUSH = 2;
    private static final int SAVE_AFTER_REQUEST = 4;
    private static final int SAVE_ON_SHUTDOWN = 8;
    private static final int[] DECODE = new int[128];
    private WebApp _webApp;
    private final SessionManagerAdmin _admin;
    private LruCache<String, SessionImpl> _sessions;
    private int _totalSessions;
    private Iterator<SessionImpl> _sessionIter;
    private ArrayList<SessionImpl> _sessionList = new ArrayList();
    private boolean _enableSessionCookies = true;
    private boolean _enableSessionUrls = true;
    private boolean _isModuloSessionId = false;
    private boolean _isAppendServerIndex = false;
    private boolean _isTwoDigitSessionIndex = false;
    private boolean _isInvalidateAfterListener;
    private int _sessionMax = 8192;
    private long _sessionTimeout = 1800000L;
    private String _cookieName = "JSESSIONID";
    private String _sslCookieName;
    private String _sessionSuffix = ";jsessionid=";
    private String _sessionPrefix;
    private int _cookieVersion;
    private String _cookieDomain;
    private long _cookieMaxAge;
    private boolean _cookieSecure;
    private int _isCookieHttpOnly;
    private String _cookiePort;
    private int _reuseSessionId = 1;
    private int _cookieLength = 21;
    private int _sessionSaveMode = 4;
    private StoreManager _storeManager;
    private boolean _ignoreSerializationErrors = true;
    private boolean _isHessianSerialization = false;
    private ArrayList<HttpSessionListener> _listeners;
    private ArrayList<HttpSessionActivationListener> _activationListeners;
    private ArrayList<HttpSessionAttributeListener> _attributeListeners;
    private boolean _isWebAppStore;
    private Store _sessionStore;
    private int _alwaysLoadSession;
    private int _alwaysSaveSession;
    private boolean _distributedRing;
    private Path _persistentPath;
    private boolean _isClosed;
    private String _distributionId;
    private Cluster _cluster;
    private ClusterServer _selfServer;
    private ClusterServer[] _srunGroup = new ClusterServer[0];
    private int _srunIndex;
    private int _srunLength;
    private int _machineLength;
    private Alarm _alarm = new Alarm((AlarmListener)this);
    private Object _statisticsLock = new Object();
    private long _sessionCreateCount;
    private long _sessionTimeoutCount;
    private long _sessionInvalidateCount;

    public SessionManager(WebApp app) throws Exception {
        this._webApp = app;
        DispatchServer server = app.getDispatchServer();
        if (server != null) {
            InvocationDecoder decoder = server.getInvocationDecoder();
            this._sessionSuffix = decoder.getSessionURLPrefix();
            this._sessionPrefix = decoder.getAlternateSessionURLPrefix();
            this._cookieName = decoder.getSessionCookie();
            this._sslCookieName = decoder.getSSLSessionCookie();
        }
        String hostName = app.getHostName();
        String contextPath = app.getContextPath();
        if (hostName == null || hostName.equals("")) {
            hostName = "default";
        }
        String name = hostName + contextPath;
        if (this._distributionId == null) {
            this._distributionId = name;
        }
        this._persistentPath = Vfs.lookup("WEB-INF/sessions");
        this._admin = new SessionManagerAdmin(this);
    }

    public SessionManagerMXBean getAdmin() {
        return this._admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cluster getCluster() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this._cluster == null) {
                this._cluster = Cluster.getLocal();
                ClusterServer selfServer = null;
                if (this._cluster != null) {
                    this._machineLength = this._cluster.getMachineList().size();
                    this._srunLength = this._cluster.getServerList().length;
                    this._selfServer = selfServer = this._cluster.getSelfServer();
                    if (selfServer != null) {
                        this._srunGroup = this._cluster.getServerList();
                        this._srunIndex = selfServer.getIndex();
                    }
                }
            }
        }
        return this._cluster;
    }

    public String getSessionPrefix() {
        return this._sessionSuffix;
    }

    public String getAlternateSessionPrefix() {
        return this._sessionPrefix;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int cookieVersion) {
        this._cookieVersion = cookieVersion;
    }

    public void setCookiePort(String port) {
        this._cookiePort = port;
    }

    public String getCookiePort() {
        return this._cookiePort;
    }

    public Logger getDebug() {
        return log;
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    ServletAuthenticator getAuthenticator() {
        return this._webApp.getAuthenticator();
    }

    public void setPersistentStore(JndiBuilder store) throws NamingException, ConfigException {
        this._storeManager = (StoreManager)store.getObject();
        if (this._storeManager == null) {
            throw new ConfigException(L.l("{0} is an unknown persistent store.", (Object)store.getJndiName()));
        }
    }

    boolean getAlwaysLoadSession() {
        return this._alwaysLoadSession == 1;
    }

    public void setAlwaysLoadSession(boolean load) {
        this._alwaysLoadSession = load ? 1 : 2;
    }

    boolean getAlwaysSaveSession() {
        return this._alwaysSaveSession == 1;
    }

    public void setAlwaysSaveSession(boolean save) {
        this._alwaysSaveSession = save ? 1 : 2;
    }

    public boolean isSaveOnShutdown() {
        return (this._sessionSaveMode & 8) != 0;
    }

    public boolean isSaveOnlyOnShutdown() {
        return (this._sessionSaveMode & 8) == 8;
    }

    public boolean isSaveBeforeHeaders() {
        return (this._sessionSaveMode & 1) != 0;
    }

    public boolean isSaveBeforeFlush() {
        return (this._sessionSaveMode & 2) != 0;
    }

    public boolean isSaveAfterRequest() {
        return (this._sessionSaveMode & 4) != 0;
    }

    public void setSaveMode(String mode) throws ConfigException {
        if ("before-headers".equals(mode)) {
            this._sessionSaveMode = 9;
        } else if ("after-request".equals(mode)) {
            this._sessionSaveMode = 12;
        } else if ("on-shutdown".equals(mode)) {
            this._sessionSaveMode = 8;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown session save-mode.  Values are: before-headers, after-request, and on-shutdown.", (Object)mode));
        }
    }

    public String getSaveMode() {
        if (this.isSaveBeforeFlush()) {
            return "before-flush";
        }
        if (this.isSaveBeforeHeaders()) {
            return "before-headers";
        }
        if (this.isSaveAfterRequest()) {
            return "after-request";
        }
        if (this.isSaveOnShutdown()) {
            return "on-shutdown";
        }
        return "unknown";
    }

    public void setSaveOnlyOnShutdown(boolean save) {
        log.warning("<save-only-on-shutdown> is deprecated.  Use <save-mode>on-shutdown</save-mode> instead");
        if (save) {
            this._sessionSaveMode = 8;
        }
    }

    public void setSaveOnShutdown(boolean save) {
        log.warning("<save-on-shutdown> is deprecated.  Use <save-only-on-shutdown> instead");
        this.setSaveOnlyOnShutdown(save);
    }

    public void setSerializationType(String type) {
        if ("hessian".equals(type)) {
            this._isHessianSerialization = true;
        } else if ("java".equals(type)) {
            this._isHessianSerialization = false;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown valud for serialization-type.  The valid types are 'hessian' and 'java'.", (Object)type));
        }
    }

    public boolean isHessianSerialization() {
        return this._isHessianSerialization;
    }

    public void setInvalidateAfterListener(boolean inv) {
        this._isInvalidateAfterListener = inv;
    }

    public boolean isInvalidateAfterListener() {
        return this._isInvalidateAfterListener;
    }

    public int getActiveSessionCount() {
        if (this._sessions == null) {
            return -1;
        }
        return this._sessions.size();
    }

    public int getSessionActiveCount() {
        return this.getActiveSessionCount();
    }

    public long getSessionCreateCount() {
        return this._sessionCreateCount;
    }

    public long getSessionTimeoutCount() {
        return this._sessionTimeoutCount;
    }

    public long getSessionInvalidateCount() {
        return this._sessionInvalidateCount;
    }

    public void addListener(HttpSessionListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    ArrayList<HttpSessionListener> getListeners() {
        return this._listeners;
    }

    public void addActivationListener(HttpSessionActivationListener listener) {
        if (this._activationListeners == null) {
            this._activationListeners = new ArrayList();
        }
        this._activationListeners.add(listener);
    }

    ArrayList<HttpSessionActivationListener> getActivationListeners() {
        return this._activationListeners;
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        if (this._attributeListeners == null) {
            this._attributeListeners = new ArrayList();
        }
        this._attributeListeners.add(listener);
    }

    ArrayList<HttpSessionAttributeListener> getAttributeListeners() {
        return this._attributeListeners;
    }

    boolean getIgnoreSerializationErrors() {
        return this._ignoreSerializationErrors;
    }

    public void setIgnoreSerializationErrors(boolean ignore) {
        this._ignoreSerializationErrors = ignore;
    }

    public int getReuseSessionId() {
        return this._reuseSessionId;
    }

    public boolean reuseSessionId(boolean fromCookie) {
        int reuseSessionId = this._reuseSessionId;
        return reuseSessionId == 2 || fromCookie && reuseSessionId == 1;
    }

    public void setReuseSessionId(String reuse) throws ConfigException {
        if (reuse == null) {
            this._reuseSessionId = 1;
        } else if (reuse.equalsIgnoreCase("true") || reuse.equalsIgnoreCase("yes") || reuse.equalsIgnoreCase("cookie")) {
            this._reuseSessionId = 1;
        } else if (reuse.equalsIgnoreCase("false") || reuse.equalsIgnoreCase("no")) {
            this._reuseSessionId = 0;
        } else if (reuse.equalsIgnoreCase("all")) {
            this._reuseSessionId = 2;
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid value for reuse-session-id.  'true' or 'false' are the allowed values.", (Object)reuse));
        }
    }

    ClusterServer getServer(int index) {
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            return cluster.getServer(index);
        }
        return null;
    }

    public int getSrunIndex() {
        return this._srunIndex;
    }

    public int getSrunLength() {
        return this._srunLength;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public StoreManager createFileStore() throws ConfigException {
        StoreManager fileStore;
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<file-store> needs a defined <cluster>."));
        }
        if (cluster.getStore() != null) {
            throw new ConfigException(L.l("<file-store> may not be used with a defined <persistent-store>.  Use <use-persistent-store> instead."));
        }
        this._storeManager = fileStore = cluster.createPrivateFileStore();
        this._isWebAppStore = true;
        return fileStore;
    }

    public StoreManager createJdbcStore() throws ConfigException {
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<jdbc-store> needs a defined <cluster>."));
        }
        if (cluster.getStore() != null) {
            throw new ConfigException(L.l("<jdbc-store> may not be used with a defined <persistent-store>.  Use <use-persistent-store> instead."));
        }
        this._storeManager = cluster.createJdbcStore();
        this._isWebAppStore = true;
        return this._storeManager;
    }

    public void setTcpStore(boolean isEnable) throws Exception {
        this.setClusterStore(isEnable);
    }

    public void setClusterStore(boolean isEnable) throws Exception {
        if (!isEnable) {
            return;
        }
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<cluster-store> needs a defined <cluster>."));
        }
        StoreManager store = cluster.getStore();
        if (store == null) {
            throw new ConfigException(L.l("cluster-store in <session-config> requires a configured cluster-store in the <cluster>"));
        }
        this._storeManager = store;
    }

    public void setUsePersistentStore(boolean enable) throws Exception {
        if (!enable) {
            return;
        }
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new ConfigException(L.l("<use-persistent-store> needs a defined <cluster>."));
        }
        StoreManager store = cluster.getStore();
        if (store == null) {
            try {
                InitialContext ic = new InitialContext();
                store = (StoreManager)ic.lookup("java:comp/env/caucho/persistent-store");
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (store == null) {
            if (!Config.evalBoolean("${resin.isProfessional()}")) {
                throw new ConfigException(L.l("use-persistent-store in <session-config> requires Resin professional."));
            }
            throw new ConfigException(L.l("use-persistent-store in <session-config> requires a configured <persistent-store> in the <server>"));
        }
        if (this._isWebAppStore) {
            throw new ConfigException(L.l("use-persistent-store may not be used with <jdbc-store> or <file-store>."));
        }
        this._storeManager = store;
    }

    public void setPersistentPath(Path path) {
        this._persistentPath = path;
    }

    public String getDistributionId() {
        return this._distributionId;
    }

    public void setDistributionId(String distributionId) {
        this._distributionId = distributionId;
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(long timeout) {
        this._sessionTimeout = timeout <= 0L || 0x3FFFFFFFL < timeout ? 0x3FFFFFFFFFFFFFFFL : 60000L * timeout;
    }

    @Override
    public long getMaxIdleTime() {
        return this._sessionTimeout;
    }

    public int getSessionMax() {
        return this._sessionMax;
    }

    public void setSessionMax(int max) {
        if (max < 1) {
            throw new ConfigException(L.l("session-max '{0}' is too small.  session-max must be a positive number", (long)max));
        }
        this._sessionMax = max;
    }

    public boolean enableSessionCookies() {
        return this._enableSessionCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this._enableSessionCookies = enableCookies;
    }

    public boolean enableSessionUrls() {
        return this._enableSessionUrls;
    }

    public void setEnableUrlRewriting(boolean enableUrls) {
        this._enableSessionUrls = enableUrls;
    }

    public String getCookieName() {
        return this._cookieName;
    }

    public String getSSLCookieName() {
        if (this._sslCookieName != null) {
            return this._sslCookieName;
        }
        return this._cookieName;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String domain) {
        this._cookieDomain = domain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period maxAge) {
        this._cookieMaxAge = maxAge.getPeriod();
    }

    public boolean getCookieSecure() {
        if (this._cookieSecure) {
            return true;
        }
        return !this._cookieName.equals(this._sslCookieName);
    }

    public void setCookieSecure(boolean secure) {
        this._cookieSecure = secure;
    }

    public boolean isCookieHttpOnly() {
        if (this._isCookieHttpOnly == 1) {
            return true;
        }
        if (this._isCookieHttpOnly == 2) {
            return true;
        }
        return this.getWebApp().getCookieHttpOnly();
    }

    public void setCookieHttpOnly(boolean httpOnly) {
        this._isCookieHttpOnly = httpOnly ? 1 : 2;
    }

    public void setCookieLength(int cookieLength) {
        if (cookieLength < 7) {
            cookieLength = 7;
        }
        this._cookieLength = cookieLength;
    }

    public long getCookieLength() {
        return this._cookieLength;
    }

    public void setCookieModuloCluster(boolean isModulo) {
        this._isModuloSessionId = isModulo;
    }

    public void setCookieAppendServerIndex(boolean isAppend) {
        this._isAppendServerIndex = isAppend;
    }

    public boolean isCookieAppendServerIndex() {
        return this._isAppendServerIndex;
    }

    public void init() {
        if (this._sessionSaveMode == 8 && (this._alwaysSaveSession == 1 || this._alwaysLoadSession == 1)) {
            throw new ConfigException(L.l("save-mode='on-shutdown' cannot be used with <always-save-session/> or <always-load-session/>"));
        }
    }

    public void start() throws Exception {
        this._sessions = new LruCache(this._sessionMax);
        this._sessionIter = this._sessions.values();
        if (this._cluster == null) {
            this.getCluster();
        }
        if (this._isWebAppStore) {
            if (this._alwaysLoadSession == 1) {
                this._storeManager.setAlwaysLoad(true);
            } else if (this._alwaysLoadSession == 2) {
                this._storeManager.setAlwaysLoad(false);
            }
            if (this._alwaysSaveSession == 1) {
                this._storeManager.setAlwaysSave(true);
            } else if (this._alwaysSaveSession == 2) {
                this._storeManager.setAlwaysSave(false);
            }
            this._storeManager.init();
            this._storeManager.updateIdleCheckInterval(this._sessionTimeout);
        }
        if (this._storeManager != null) {
            this._sessionStore = this._storeManager.createStore(this._distributionId, this);
            this._sessionStore.setMaxIdleTime(this._sessionTimeout);
            if (this._alwaysLoadSession == 1) {
                this._sessionStore.setAlwaysLoad(true);
            } else if (this._alwaysLoadSession == 2) {
                this._sessionStore.setAlwaysLoad(false);
            }
            if (this._alwaysSaveSession == 1) {
                this._sessionStore.setAlwaysSave(true);
            } else if (this._alwaysSaveSession == 2) {
                this._sessionStore.setAlwaysSave(false);
            }
        }
        this._alarm.queue(60000L);
    }

    public Store getSessionStore() {
        return this._sessionStore;
    }

    public boolean containsSession(String id) {
        return this._sessions.get((Object)id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl createSession(String oldId, long now, HttpServletRequest request, boolean fromCookie) {
        SessionImpl session;
        String id = oldId;
        if (id == null || id.length() < 4 || !this.isInSessionGroup(id) || !this.reuseSessionId(fromCookie)) {
            id = this.createSessionId(request, true);
        }
        if ((session = this.create(id, now, true)) == null) {
            return null;
        }
        session.addUse();
        Object object = this._statisticsLock;
        synchronized (object) {
            ++this._sessionCreateCount;
        }
        object = session;
        synchronized (object) {
            if (this._sessionStore != null && id.equals(oldId)) {
                this.load(session, now);
            } else {
                session.create(now);
            }
        }
        this.handleCreateListeners(session);
        return session;
    }

    public String createSessionId(HttpServletRequest request) {
        return this.createSessionId(request, false);
    }

    public String createSessionId(HttpServletRequest request, boolean create) {
        String id;
        do {
            id = this.createSessionIdImpl(request);
        } while (create && this.getSession(id, 0L, create, true) != null);
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    public String createSessionIdImpl(HttpServletRequest request) {
        int i;
        StringBuffer cb = new StringBuffer();
        int index = this._srunIndex;
        Object owner = request.getAttribute("caucho.session-server-id");
        if (owner != null) {
            ClusterServer server;
            if (owner instanceof Number) {
                index = ((Number)owner).intValue();
                if (this._srunLength <= index) {
                    index = this._srunIndex;
                }
            } else if (owner instanceof String && (server = this._cluster.getServer((String)owner)) != null) {
                index = server.getIndex();
            }
        }
        if (index < 0) {
            index = 0;
        }
        int length = this._cookieLength;
        this.addBackup(cb, index);
        length -= cb.length();
        long random = RandomUtil.getRandomLong();
        for (i = 0; i < 11 && length-- > 0; ++i) {
            cb.append(SessionManager.convert(random));
            random >>= 6;
        }
        if (length > 0) {
            long time = Alarm.getCurrentTime();
            for (int i2 = 0; i2 < 7 && length-- > 0; ++i2) {
                cb.append(SessionManager.convert(time));
                time >>= 6;
            }
        }
        while (length > 0) {
            random = RandomUtil.getRandomLong();
            for (i = 0; i < 11 && length-- > 0; ++i) {
                cb.append(SessionManager.convert(random));
                random >>= 6;
            }
        }
        if (this._isAppendServerIndex) {
            cb.append('.');
            cb.append(index + 1);
        }
        return cb.toString();
    }

    private void addBackup(StringBuffer cb, int index) {
        long backupCode = this._selfServer != null ? this._selfServer.getCluster().generateBackupCode(index) : 0x200010000L;
        this.addDigit(cb, (int)(backupCode & 0xFFFFL));
        this.addDigit(cb, (int)(backupCode >> 16 & 0xFFFFL));
        this.addDigit(cb, (int)(backupCode >> 32 & 0xFFFFL));
    }

    private void addDigit(StringBuffer cb, int digit) {
        if (this._srunLength <= 64 && !this._isTwoDigitSessionIndex) {
            cb.append(SessionManager.convert(digit));
        } else {
            cb.append(SessionManager.convert(digit / 64));
            cb.append(SessionManager.convert(digit));
        }
    }

    public SessionImpl getSession(String key, long now, boolean create, boolean fromCookie) {
        boolean isNew = false;
        boolean killSession = false;
        if (this._sessions == null) {
            return null;
        }
        SessionImpl session = (SessionImpl)this._sessions.get((Object)key);
        if (session != null && !session.getId().equals(key)) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        if (now <= 0L) {
            return session;
        }
        if (session != null && !session.addUse()) {
            session = null;
        }
        if (session == null && this._sessionStore != null) {
            if (!this.isInSessionGroup(key)) {
                return null;
            }
            session = this.create(key, now, create);
            if (!session.addUse()) {
                session = null;
            }
            isNew = true;
        }
        if (session == null) {
            return null;
        }
        if (isNew) {
            isNew = killSession = !this.load(session, now);
        } else if (!session.load()) {
            session.reset(now);
            killSession = true;
            isNew = true;
        }
        if (!(!killSession || create && this.reuseSessionId(fromCookie))) {
            session.endUse();
            session._isValid = false;
            this._sessions.remove((Object)key);
            return null;
        }
        if (isNew) {
            this.handleCreateListeners(session);
        } else {
            session.setAccess(now);
        }
        return session;
    }

    public boolean isInSessionGroup(String id) {
        if (this._srunLength == 0 || this._srunGroup.length == 0) {
            return true;
        }
        int group = SessionManager.decode(id.charAt(0)) % this._srunLength;
        for (int i = this._srunGroup.length - 1; i >= 0; --i) {
            ClusterServer server = this._srunGroup[i];
            if (server == null || group != server.getIndex()) continue;
            return true;
        }
        return false;
    }

    private SessionImpl create(String key, long now, boolean isCreate) {
        SessionImpl session = new SessionImpl(this, key, now);
        if (!key.equals((session = (SessionImpl)this._sessions.putIfNew((Object)key, (Object)session)).getId())) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        Store sessionStore = this._sessionStore;
        if (sessionStore != null) {
            ClusterObject clusterObject = sessionStore.createClusterObject(key);
            session.setClusterObject(clusterObject);
        }
        return session;
    }

    @Override
    public void notifyRemove(String id) {
        SessionImpl session = (SessionImpl)this._sessions.remove((Object)id);
        if (session != null) {
            session.invalidateLru();
        }
    }

    @Override
    public void notifyUpdate(String id) {
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    private void handleCreateListeners(SessionImpl session) {
        if (this._listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (int i = 0; i < this._listeners.size(); ++i) {
                HttpSessionListener listener = this._listeners.get(i);
                listener.sessionCreated(event);
            }
        }
    }

    private boolean load(SessionImpl session, long now) {
        try {
            if (now <= 0L) {
                return false;
            }
            if (session.load()) {
                session.setAccess(now);
                return true;
            }
            session.create(now);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            session.reset(now);
        }
        return false;
    }

    void addSession(SessionImpl session) {
        this._sessions.put((Object)session.getId(), (Object)session);
    }

    void removeSession(SessionImpl session) {
        this._sessions.remove((Object)session.getId());
    }

    @Override
    public void load(InputStream is, Object obj) throws IOException {
        SessionImpl session = (SessionImpl)obj;
        if (this._isHessianSerialization) {
            Hessian2Input in = new Hessian2Input(is);
            session.load(in);
            in.close();
        } else {
            DistributedObjectInputStream in = new DistributedObjectInputStream(is);
            session.load(in);
            in.close();
        }
    }

    @Override
    public boolean isEmpty(Object obj) {
        SessionImpl session = (SessionImpl)obj;
        return session.isEmpty();
    }

    @Override
    public void store(OutputStream os, Object obj) throws IOException {
        SessionImpl session = (SessionImpl)obj;
        if (this._isHessianSerialization) {
            Hessian2Output out = new Hessian2Output(os);
            session.store(out);
            out.close();
        } else {
            ObjectOutputStream out = new ObjectOutputStream(os);
            session.store(out);
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        block18: {
            block17: {
                try {
                    SessionImpl session;
                    this._sessionList.clear();
                    int liveSessions = 0;
                    if (this._isClosed) {
                        Object var14_3 = null;
                        if (this._isClosed) return;
                        break block17;
                    }
                    long now = Alarm.getCurrentTime();
                    long accessWindow = 0L;
                    if (this._sessionStore != null) {
                        accessWindow = this._sessionStore.getAccessWindowTime();
                    }
                    Object object = this._sessions;
                    synchronized (object) {
                        this._sessionIter = this._sessions.values(this._sessionIter);
                        while (this._sessionIter.hasNext()) {
                            session = this._sessionIter.next();
                            long maxIdleTime = session._maxInactiveInterval + accessWindow;
                            if (session.inUse()) {
                                ++liveSessions;
                                continue;
                            }
                            if (session._accessTime + maxIdleTime < now) {
                                this._sessionList.add(session);
                                continue;
                            }
                            ++liveSessions;
                        }
                    }
                    object = this._statisticsLock;
                    synchronized (object) {
                        this._sessionTimeoutCount += (long)this._sessionList.size();
                    }
                    for (int i = 0; i < this._sessionList.size(); ++i) {
                        session = this._sessionList.get(i);
                        try {
                            if (!session.isValid()) continue;
                            if (this._storeManager == null) {
                                session.invalidateTimeout();
                                continue;
                            }
                            if (session.getSrunIndex() != this._srunIndex && this._srunIndex >= 0) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(session + " timeout (backup)");
                                }
                                this._sessions.remove((Object)session.getId());
                                continue;
                            }
                            session.invalidateTimeout();
                            continue;
                        }
                        catch (Throwable e) {
                            log.log(Level.FINE, e.toString(), e);
                        }
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var14_5 = null;
                    if (this._isClosed) throw throwable;
                    this._alarm.queue(60000L);
                    throw throwable;
                }
            }
            this._alarm.queue(60000L);
            return;
        }
        Object var14_4 = null;
        if (this._isClosed) return;
        this._alarm.queue(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SessionImpl session;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        if (this._sessions == null) {
            return;
        }
        this._alarm.dequeue();
        ArrayList<SessionImpl> list = new ArrayList<SessionImpl>();
        boolean isError = false;
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            this._sessionIter = this._sessions.values(this._sessionIter);
            while (this._sessionIter.hasNext()) {
                session = this._sessionIter.next();
                if (!session.isValid()) continue;
                list.add(session);
            }
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            session = (SessionImpl)list.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.fine("close session " + session.getId());
            }
            try {
                if (session.isValid()) {
                    SessionImpl sessionImpl = session;
                    synchronized (sessionImpl) {
                        if (!session.isEmpty()) {
                            session.saveOnShutdown();
                        }
                    }
                }
                this._sessions.remove((Object)session.getId());
                continue;
            }
            catch (Exception e) {
                if (!isError) {
                    log.log(Level.WARNING, "Can't store session: " + e, e);
                }
                isError = true;
            }
        }
        if (this._admin != null) {
            this._admin.unregister();
        }
        this._sessionList = new ArrayList();
    }

    public String toString() {
        if (this._webApp != null) {
            return "SessionManager[" + this._webApp.getContextPath() + "]";
        }
        return "SessionManager[]";
    }

    static {
        for (int i = 0; i < 64; ++i) {
            SessionManager.DECODE[SessionManager.convert((long)((long)i))] = i;
        }
    }

    static class DistributedObjectInputStream
    extends ObjectInputStream {
        private ClassLoader _loader;

        DistributedObjectInputStream(InputStream is) throws IOException {
            super(is);
            Thread thread = Thread.currentThread();
            this._loader = thread.getContextClassLoader();
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String name = v.getName();
            return Class.forName(name, false, this._loader);
        }
    }
}

