/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp;

import com.caucho.server.connection.Connection;
import com.caucho.server.port.Port;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.snmp.Oid;
import com.caucho.server.snmp.SnmpRequest;
import com.caucho.server.snmp.types.OctetStringValue;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpProtocol
extends Protocol {
    private String _protocolName = "snmp";
    private HashMap<String, Oid> _mibMap = new HashMap();
    private final int PRIVATE_ENTERPRISE_NUMBER = 30350;
    private String _community;

    public SnmpProtocol() {
        this.addOid("1.3.6.1.2.1.1.1", "resin:type=Resin", "Version", 4);
        this.addOid("1.3.6.1.2.1.1.3", "java.lang:type=Runtime", "UpTime", 67);
        this.addOid("1.3.6.1.2.1.1.5", "resin:type=Host,name=default", "URL", 4);
        String penPrefix = "1.3.6.1.4.1.30350.";
        this.addOid(penPrefix + "1.1", "resin:type=Server", "KeepaliveCountTotal", 66);
        this.addOid(penPrefix + "1.2", "resin:type=Server", "RequestCountTotal", 66);
        this.addOid(penPrefix + "1.3", "resin:type=Server", "RuntimeMemory", 66);
        this.addOid(penPrefix + "1.4", "resin:type=Server", "RuntimeMemoryFree", 66);
        this.addOid(penPrefix + "1.5", "resin:type=Server", "ThreadActiveCount", 66);
        this.addOid(penPrefix + "1.6", "resin:type=Server", "ThreadKeepaliveCount", 66);
        this.addOid(penPrefix + "2.1", "resin:type=ThreadPool", "ThreadActiveCount", 66);
        this.addOid(penPrefix + "2.2", "resin:type=ThreadPool", "ThreadCount", 66);
        this.addOid(penPrefix + "2.3", "resin:type=ThreadPool", "ThreadIdleCount", 66);
        this.addOid(penPrefix + "2.4", "resin:type=ThreadPool", "ThreadIdleMax", 66);
        this.addOid(penPrefix + "2.5", "resin:type=ThreadPool", "ThreadIdleMin", 66);
        this.addOid(penPrefix + "2.6", "resin:type=ThreadPool", "ThreadMax", 66);
        this.addOid(penPrefix + "3.1", "resin:type=ProxyCache", "HitCountTotal", 66);
        this.addOid(penPrefix + "3.2", "resin:type=ProxyCache", "MissCountTotal", 66);
    }

    @Override
    public void setParent(Port port) {
        super.setParent(port);
    }

    @Override
    public String getProtocolName() {
        return this._protocolName;
    }

    @Override
    public void setProtocolName(String name) {
        this._protocolName = name;
    }

    public void addOid(Oid oid) throws Exception {
        this._mibMap.put(oid.getName(), oid);
    }

    private void addOid(String name, String mbean, String attribute, int type) {
        Oid oid = new Oid(name, mbean, attribute, type);
        this._mibMap.put(name, oid);
    }

    public HashMap<String, Oid> getMib() {
        return this._mibMap;
    }

    public String getCommunity() {
        if (this._community == null) {
            return "public";
        }
        return this._community;
    }

    public void setCommunity(String s) {
        this._community = s;
    }

    @Override
    public ServerRequest createRequest(Connection connection) {
        OctetStringValue community = this._community == null ? OctetStringValue.PUBLIC : new OctetStringValue(this._community);
        return new SnmpRequest(connection, this._mibMap, community);
    }
}

