/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ContextFilterChain
implements FilterChain {
    private static final Logger log = Log.open(ContextFilterChain.class);
    private FilterChain _next;
    private ClassLoader _classLoader;
    private TransactionManagerImpl _tm;
    private ErrorPageManager _errorPageManager;

    public ContextFilterChain(FilterChain next) {
        this._next = next;
        this._classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this._tm = TransactionManagerImpl.getInstance();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this._errorPageManager = errorPageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block36: {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._classLoader);
                this._next.doFilter(request, response);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (request instanceof AbstractHttpRequest) {
                    ((AbstractHttpRequest)request).finish();
                }
                if (this._tm != null) {
                    try {
                        TransactionImpl transaction = this._tm.getCurrent();
                        if (transaction.getStatus() != 6) {
                            log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                        }
                        transaction.close();
                    }
                    catch (Throwable e2) {
                        log.log(Level.WARNING, e2.getMessage(), e2);
                    }
                }
                if (response instanceof AbstractHttpResponse) {
                    ((AbstractHttpResponse)response).finish();
                }
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            if (request instanceof AbstractHttpRequest) {
                ((AbstractHttpRequest)request).finish();
            }
            if (this._tm != null) {
                try {
                    TransactionImpl transaction = this._tm.getCurrent();
                    if (transaction.getStatus() != 6) {
                        log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                    }
                    transaction.close();
                }
                catch (Throwable e2) {
                    log.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
            if (response instanceof AbstractHttpResponse) {
                ((AbstractHttpResponse)response).finish();
            }
            thread.setContextClassLoader(oldLoader);
            {
                break block36;
                catch (ServletException e) {
                    if (this._errorPageManager == null) {
                        throw e;
                    }
                    this._errorPageManager.sendServletError(e, request, response);
                    Object var7_6 = null;
                    if (request instanceof AbstractHttpRequest) {
                        ((AbstractHttpRequest)request).finish();
                    }
                    if (this._tm != null) {
                        try {
                            TransactionImpl transaction = this._tm.getCurrent();
                            if (transaction.getStatus() != 6) {
                                log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                            }
                            transaction.close();
                        }
                        catch (Throwable e2) {
                            log.log(Level.WARNING, e2.getMessage(), e2);
                        }
                    }
                    if (response instanceof AbstractHttpResponse) {
                        ((AbstractHttpResponse)response).finish();
                    }
                    thread.setContextClassLoader(oldLoader);
                    break block36;
                }
                catch (IOException e) {
                    if (this._errorPageManager == null) {
                        throw e;
                    }
                    this._errorPageManager.sendServletError(e, request, response);
                    Object var7_7 = null;
                    if (request instanceof AbstractHttpRequest) {
                        ((AbstractHttpRequest)request).finish();
                    }
                    if (this._tm != null) {
                        try {
                            TransactionImpl transaction = this._tm.getCurrent();
                            if (transaction.getStatus() != 6) {
                                log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                            }
                            transaction.close();
                        }
                        catch (Throwable e2) {
                            log.log(Level.WARNING, e2.getMessage(), e2);
                        }
                    }
                    if (response instanceof AbstractHttpResponse) {
                        ((AbstractHttpResponse)response).finish();
                    }
                    thread.setContextClassLoader(oldLoader);
                    break block36;
                }
                catch (RuntimeException e) {
                    if (this._errorPageManager == null) {
                        throw e;
                    }
                    this._errorPageManager.sendServletError(e, request, response);
                    Object var7_8 = null;
                    if (request instanceof AbstractHttpRequest) {
                        ((AbstractHttpRequest)request).finish();
                    }
                    if (this._tm != null) {
                        try {
                            TransactionImpl transaction = this._tm.getCurrent();
                            if (transaction.getStatus() != 6) {
                                log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                            }
                            transaction.close();
                        }
                        catch (Throwable e2) {
                            log.log(Level.WARNING, e2.getMessage(), e2);
                        }
                    }
                    if (response instanceof AbstractHttpResponse) {
                        ((AbstractHttpResponse)response).finish();
                    }
                    thread.setContextClassLoader(oldLoader);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

