/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.log.Log;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

public class DispatchFilterChain
implements FilterChain {
    private static final Logger log = Log.open(DispatchFilterChain.class);
    private FilterChain _next;
    private WebApp _webApp;
    private ClassLoader _classLoader;
    private ServletRequestListener[] _requestListeners;

    public DispatchFilterChain(FilterChain next, WebApp app) {
        this._next = next;
        this._webApp = app;
        this._classLoader = app.getClassLoader();
        this._requestListeners = app.getRequestListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader oldLoader;
        Thread thread;
        block9: {
            WebApp webApp;
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            if (request instanceof CauchoRequest) {
                CauchoRequest cReq = (CauchoRequest)request;
                webApp = cReq.getWebApp();
            } else {
                webApp = this._webApp;
            }
            try {
                thread.setContextClassLoader(this._classLoader);
                if (webApp != this._webApp) {
                    for (int i = 0; i < this._requestListeners.length; ++i) {
                        ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                        this._requestListeners[i].requestInitialized(event);
                    }
                }
                this._next.doFilter(request, response);
                Object var9_9 = null;
                if (webApp == this._webApp) break block9;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (webApp != this._webApp) {
                    for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                        ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                        this._requestListeners[i].requestDestroyed(event);
                    }
                }
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                this._requestListeners[i].requestDestroyed(event);
            }
        }
        thread.setContextClassLoader(oldLoader);
    }
}

