/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.IncludeResponseStream;
import com.caucho.util.FreeList;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;

class DispatchResponse
extends AbstractHttpResponse {
    private static final FreeList<DispatchResponse> _freeList = new FreeList(32);
    private IncludeResponseStream _stream;
    private HttpServletResponse _next;

    protected DispatchResponse() {
    }

    public static DispatchResponse createDispatch() {
        DispatchResponse res = (DispatchResponse)_freeList.allocate();
        if (res == null) {
            res = new DispatchResponse();
        }
        return res;
    }

    protected AbstractResponseStream createResponseStream() {
        this._stream = new IncludeResponseStream(this);
        return this._stream;
    }

    public void setNextResponse(HttpServletResponse next) {
        this._next = next;
        this._stream.init((ServletResponse)next);
    }

    public ServletResponse getResponse() {
        return this._next;
    }

    public void start() throws IOException {
        super.start();
        this.setResponseStream(this._stream);
        this._stream.start();
    }

    public void setContentType(String type) {
    }

    public String encodeURL(String url) {
        return this._next.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this._next.encodeRedirectURL(url);
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public String getCharacterEncoding() {
        return this._next.getCharacterEncoding();
    }

    public boolean isCommitted() {
        return this._next.isCommitted();
    }

    public boolean isCauchoResponse() {
        return this._next instanceof CauchoResponse;
    }

    public void setCauchoResponseStream(boolean isCaucho) {
        this._stream.setCauchoResponseStream(isCaucho);
    }

    public void killCache() {
        super.killCache();
        HttpServletResponse next = this._next;
        while (next != null && next != this) {
            if (next instanceof CauchoResponse) {
                ((CauchoResponse)next).killCache();
                break;
            }
            if (next instanceof ServletResponseWrapper) {
                next = ((ServletResponseWrapper)next).getResponse();
                continue;
            }
            if (!(next instanceof DispatchResponse)) break;
            next = ((DispatchResponse)next).getResponse();
        }
    }

    public void free() {
        super.free();
        this._next = null;
    }

    public static void free(DispatchResponse res) {
        res.free();
        _freeList.free((Object)res);
    }
}

