/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public class Listener
extends DescriptionGroupConfig {
    static L10N L = new L10N(Listener.class);
    private Class _listenerClass;
    private Object _object;
    private ContainerProgram _init;

    public void setListenerClass(Class cl) throws ConfigException {
        Config.checkCanInstantiate(cl);
        if (!(ServletContextListener.class.isAssignableFrom(cl) || ServletContextAttributeListener.class.isAssignableFrom(cl) || ServletRequestListener.class.isAssignableFrom(cl) || ServletRequestAttributeListener.class.isAssignableFrom(cl) || HttpSessionListener.class.isAssignableFrom(cl) || HttpSessionAttributeListener.class.isAssignableFrom(cl) || HttpSessionActivationListener.class.isAssignableFrom(cl))) {
            throw new ConfigException(L.l("listener-class '{0}' does not implement any web-app listener interface.", (Object)cl.getName()));
        }
        this._listenerClass = cl;
    }

    public Class getListenerClass() {
        return this._listenerClass;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public Object createListenerObject() throws Exception {
        if (this._object != null) {
            return this._object;
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        if (this._init != null) {
            this._object = webBeans.createTransientObjectNoInit(this._listenerClass);
            this._init.configure(this._object);
            this._init.init(this._object);
        } else {
            this._object = webBeans.createTransientObject(this._listenerClass);
        }
        return this._object;
    }

    public String toString() {
        return "Listener[" + this._listenerClass + "]";
    }
}

