/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.dispatch.AbstractFilterChain;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.vfs.ClientDisconnectException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class StatisticsFilterChain
extends AbstractFilterChain {
    private final FilterChain _next;
    private WebApp _webApp;

    public StatisticsFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        AbstractHttpRequest httpRequest;
        Connection connection;
        if (request instanceof AbstractHttpRequest && (connection = (httpRequest = (AbstractHttpRequest)request).getConnection()) instanceof TcpConnection) {
            TcpConnection tcpConnection = (TcpConnection)connection;
            long time = Alarm.getExactTime();
            long readBytes = -1L;
            long writeBytes = -1L;
            readBytes = tcpConnection.getSocket().getTotalReadBytes();
            writeBytes = tcpConnection.getSocket().getTotalWriteBytes();
            ClientDisconnectException clientDisconnectException = null;
            try {
                this._next.doFilter(request, response);
            }
            catch (ClientDisconnectException ex) {
                clientDisconnectException = ex;
            }
            time = Alarm.getExactTime() - time;
            readBytes = tcpConnection.getSocket().getTotalReadBytes() - readBytes;
            writeBytes = tcpConnection.getSocket().getTotalReadBytes() - writeBytes;
            this._webApp.updateStatistics(time, (int)readBytes, (int)writeBytes, clientDisconnectException != null);
            if (clientDisconnectException != null) {
                throw clientDisconnectException;
            }
            return;
        }
        this._next.doFilter(request, response);
    }
}

