/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinImport;
import com.caucho.config.j2ee.PersistenceContextRefConfig;
import com.caucho.config.types.EjbLocalRef;
import com.caucho.config.types.EjbRef;
import com.caucho.config.types.Icon;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.Period;
import com.caucho.config.types.ResourceRef;
import com.caucho.config.types.Validator;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.java.WorkDir;
import com.caucho.jsp.JspServlet;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.JspTaglib;
import com.caucho.jsp.el.JspApplicationContextImpl;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.AlwaysModified;
import com.caucho.make.DependencyContainer;
import com.caucho.management.server.HostMXBean;
import com.caucho.naming.Jndi;
import com.caucho.server.cache.AbstractCache;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.Server;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.deploy.EnvironmentDeployInstance;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapper;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.ServletRegexp;
import com.caucho.server.dispatch.SubInvocation;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.dispatch.VersionInvocation;
import com.caucho.server.host.Host;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.security.AbstractLogin;
import com.caucho.server.security.ConstraintManager;
import com.caucho.server.security.Login;
import com.caucho.server.security.LoginConfig;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.security.ServletAuthenticator;
import com.caucho.server.security.TransportConstraint;
import com.caucho.server.session.SessionManager;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.CacheMapping;
import com.caucho.server.webapp.DispatchFilterChain;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.Listener;
import com.caucho.server.webapp.LocaleEncodingMappingList;
import com.caucho.server.webapp.MimeMapping;
import com.caucho.server.webapp.MultipartForm;
import com.caucho.server.webapp.NamedDispatcherImpl;
import com.caucho.server.webapp.PathMapping;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.RewriteRealPath;
import com.caucho.server.webapp.SecurityRole;
import com.caucho.server.webapp.ServletContextImpl;
import com.caucho.server.webapp.StatisticsFilterChain;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.server.webapp.WebAppFilterChain;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.server.webapp.WelcomeFileList;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.component.WebBeansHandle;
import com.caucho.webbeans.el.WebBeansELResolver;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApp
extends ServletContextImpl
implements Dependency,
EnvironmentBean,
SchemaBean,
DispatchBuilder,
EnvironmentDeployInstance,
Serializable {
    private static final String DEFAULT_VERSION = "2.5";
    private static final L10N L = new L10N(WebApp.class);
    private static final Logger log = Logger.getLogger(WebApp.class.getName());
    private static final int JSP_NONE = 0;
    private static final int JSP_1 = 1;
    private static final int JSP_2 = 2;
    private static EnvironmentLocal<AbstractAccessLog> _accessLogLocal = new EnvironmentLocal("caucho.server.access-log");
    private static EnvironmentLocal<WebApp> _appLocal = new EnvironmentLocal("caucho.application");
    private static ThreadLocal<ServletRequest> _requestThreadLocal = new ThreadLocal();
    static String[] _classLoaderHackPackages = new String[]{"java.", "javax.servlet.", "javax.naming.", "javax.sql.", "javax.transaction."};
    private ClassLoader _parentClassLoader;
    private EnvironmentClassLoader _classLoader;
    private WebAppContainer _parent;
    private String _version;
    private WebApp _oldWebApp;
    private long _oldWebAppExpireTime;
    private WebAppController _controller;
    private final Path _appDir;
    private String _contextPath = "";
    private String _description = "";
    private String _servletVersion;
    private boolean _isDynamicDeploy;
    private boolean _isDisableCrossContext;
    private ArrayList<DeployGenerator> _appGenerators = new ArrayList();
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private ServletManager _servletManager;
    private ServletMapper _servletMapper;
    private boolean _isStrictMapping;
    private boolean _servletAllowEL = false;
    private FilterManager _filterManager;
    private FilterMapper _filterMapper;
    private FilterMapper _loginFilterMapper;
    private FilterMapper _includeFilterMapper;
    private FilterMapper _forwardFilterMapper;
    private FilterMapper _errorFilterMapper;
    private boolean _dispatchWrapsFilters;
    private TransactionManagerImpl _tm;
    private SessionManager _sessionManager;
    private boolean _isInheritSession;
    private String _characterEncoding;
    private AbstractCache _cache;
    private LruCache<String, FilterChainEntry> _filterChainCache = new LruCache(256);
    private UrlMap<CacheMapping> _cacheMappingMap = new UrlMap();
    private final Object _dispatcherCacheLock = new Object();
    private LruCache<String, RequestDispatcherImpl> _dispatcherCache;
    private Login _loginFactory;
    private AbstractLogin _login;
    private AbstractLogin _loginManager;
    private ConstraintManager _constraintManager;
    private boolean _isSecure;
    private ErrorPageManager _errorPageManager;
    private Throwable _configException;
    private RewriteDispatch _rewriteDispatch;
    private LruCache<String, String> _realPathCache = new LruCache(1024);
    private RewriteRealPath _rewriteRealPath;
    private HashMap<String, String> _mimeMapping = new HashMap();
    private HashMap<String, String> _localeMapping = new HashMap();
    private ArrayList<Listener> _listeners = new ArrayList();
    private ArrayList<ServletContextListener> _webAppListeners = new ArrayList();
    private ArrayList<ServletContextAttributeListener> _attributeListeners = new ArrayList();
    private ArrayList<ServletRequestListener> _requestListeners = new ArrayList();
    private ServletRequestListener[] _requestListenerArray = new ServletRequestListener[0];
    private ArrayList<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList();
    private ServletRequestAttributeListener[] _requestAttributeListenerArray = new ServletRequestAttributeListener[0];
    private ArrayList<Validator> _resourceValidators = new ArrayList();
    private DependencyContainer _invocationDependency;
    private AbstractAccessLog _accessLog;
    private Path _tempDir;
    private boolean _cookieHttpOnly;
    private int _jspState;
    private JspPropertyGroup _jsp;
    private ArrayList<JspTaglib> _taglibList;
    private JspApplicationContextImpl _jspApplicationContext;
    private HashMap<String, Object> _extensions = new HashMap();
    private MultipartForm _multipartForm;
    private ArrayList<String> _regexp;
    private boolean _isStatisticsEnabled;
    private long _shutdownWaitTime = 15000L;
    private long _activeWaitTime = 15000L;
    private long _idleTime = 0x6DDD00L;
    private final Object _countLock = new Object();
    private final Lifecycle _lifecycle;
    private int _requestCount;
    private long _lastRequestTime = Alarm.getCurrentTime();
    private long _status500CountTotal;
    private long _status500LastTime;

    public WebApp(Path rootDirectory) {
        this(new WebAppController("/", "/", rootDirectory, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebApp(WebAppController controller) {
        String contextPath = controller.getContextPath();
        this.setContextPathId(contextPath);
        this._controller = controller;
        this._appDir = controller.getRootDirectory();
        try {
            try {
                this._classLoader = new EnvironmentClassLoader(controller.getParentClassLoader(), "web-app:" + this.getURL());
                JspServlet.initStatic();
                this._classLoader.addParentPriorityPackages(_classLoaderHackPackages);
                _appLocal.set(this, this._classLoader);
                this.setParent(controller.getContainer());
                Vfs.setPwd(this._appDir, this._classLoader);
                WorkDir.setLocalWorkDir(this._appDir.lookup("WEB-INF/work"), this._classLoader);
                if (!CauchoSystem.isTesting()) {
                    if (this._appDir.equals((Object)CauchoSystem.getResinHome())) {
                        throw new ConfigException(L.l("web-app root-directory can not be the same as resin.home\n{0}", (Object)this._appDir));
                    }
                    if (this._parent != null && this._appDir.equals((Object)this._parent.getRootDirectory())) {
                        throw new ConfigException(L.l("web-app root-directory can not be the same as the host root-directory\n{0}", (Object)this._appDir));
                    }
                }
                this._servletManager = new ServletManager();
                this._servletMapper = new ServletMapper();
                this._servletMapper.setServletContext(this);
                this._servletMapper.setServletManager(this._servletManager);
                this._filterManager = new FilterManager();
                this._filterMapper = new FilterMapper();
                this._filterMapper.setServletContext(this);
                this._filterMapper.setFilterManager(this._filterManager);
                this._loginFilterMapper = new FilterMapper();
                this._loginFilterMapper.setServletContext(this);
                this._loginFilterMapper.setFilterManager(this._filterManager);
                this._includeFilterMapper = new FilterMapper();
                this._includeFilterMapper.setServletContext(this);
                this._includeFilterMapper.setFilterManager(this._filterManager);
                this._forwardFilterMapper = new FilterMapper();
                this._forwardFilterMapper.setServletContext(this);
                this._forwardFilterMapper.setFilterManager(this._filterManager);
                this._errorFilterMapper = new FilterMapper();
                this._errorFilterMapper.setServletContext(this);
                this._errorFilterMapper.setFilterManager(this._filterManager);
                this._constraintManager = new ConstraintManager();
                this._errorPageManager = new ErrorPageManager();
                this._errorPageManager.setWebApp(this);
                if (this.getParent() != null) {
                    this._errorPageManager.setParent(this.getParent().getErrorPageManager());
                }
                this._invocationDependency = new DependencyContainer();
                this._invocationDependency.add(this);
                this._jspApplicationContext = new JspApplicationContextImpl(this);
            }
            catch (Throwable e) {
                this.setConfigException(e);
                Object var5_4 = null;
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            }
            Object var5_3 = null;
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
            throw throwable;
        }
    }

    public void setParent(WebAppContainer parent) {
        this._parent = parent;
        if (parent == null) {
            return;
        }
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    public WebAppContainer getParent() {
        return this._parent;
    }

    public static WebApp getLocal() {
        return _appLocal.get();
    }

    public DispatchServer getDispatchServer() {
        if (this._parent != null) {
            return this._parent.getDispatchServer();
        }
        return null;
    }

    public Server getServer() {
        if (this._parent != null && this._parent.getDispatchServer() instanceof Server) {
            return (Server)this._parent.getDispatchServer();
        }
        return null;
    }

    public void setId(String id) {
    }

    private void setContextPathId(String id) {
        if (!id.equals("") && !id.startsWith("/")) {
            id = "/" + id;
        }
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        this.setContextPath(id);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        throw new IllegalStateException();
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return this._classLoader;
    }

    public void setRedeployMode(String mode) {
        if (this._controller != null) {
            this._controller.setRedeployMode(mode);
        }
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/webapp/resin-web-xml.rnc";
    }

    public void setStatisticsEnable(boolean isEnable) {
        this._isStatisticsEnabled = isEnable;
    }

    public void setConfigNode(Node node) {
        String ns = node.getNamespaceURI();
        if (ns == null || ns.equals("")) {
            this._jspState = 1;
        }
    }

    @Override
    public Path getAppDir() {
        return this._appDir;
    }

    public DependencyContainer getInvocationDependency() {
        return this._invocationDependency;
    }

    public void setRegexp(ArrayList<String> regexp) {
        this._regexp = regexp;
    }

    public ArrayList<String> getRegexp() {
        return this._regexp;
    }

    public void setDocumentDirectory(Path appDir) {
        this.setAppDir(appDir);
    }

    @Override
    public void setRootDirectory(Path appDir) {
    }

    public void setAppDir(Path appDir) {
        this.setRootDirectory(appDir);
    }

    public ObjectName getObjectName() {
        return this._controller.getObjectName();
    }

    @Override
    public String getContextPath() {
        return this._contextPath;
    }

    private void setContextPath(String contextPath) {
        this._contextPath = contextPath;
        if (this.getServletContextName() == null) {
            this.setDisplayName(contextPath);
        }
    }

    public void setVersion(String version) {
        this._servletVersion = version;
    }

    public String getVersion() {
        return this._servletVersion;
    }

    public void setSchemaLocation(String location) {
    }

    public void setDistributable(boolean isDistributable) {
    }

    public String getURL() {
        if (this._parent != null) {
            return this._parent.getURL() + this._contextPath;
        }
        return this._contextPath;
    }

    public String getHostName() {
        if (this._parent != null) {
            return this._parent.getHostName();
        }
        return null;
    }

    public HostMXBean getHostAdmin() {
        if (this._parent != null && this._parent.getHost() != null) {
            return this._parent.getHost().getAdmin();
        }
        return null;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setIcon(Icon icon) {
    }

    public void setAllowServletEL(boolean allow) {
        this._servletAllowEL = allow;
    }

    public void setDisableCrossContext(boolean isDisable) {
        this._isDisableCrossContext = isDisable;
    }

    public void setOldWebApp(WebApp oldWebApp, long expireTime) {
        this._oldWebApp = oldWebApp;
        this._oldWebAppExpireTime = expireTime;
    }

    public ServletConfigImpl createServlet() throws ServletException {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this);
        config.setAllowEL(this._servletAllowEL);
        return config;
    }

    public void addServlet(ServletConfigImpl config) throws ServletException {
        config.setServletContext(this);
        this._servletManager.addServlet(config);
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void setStrictMapping(boolean isStrict) throws ServletException {
        this._isStrictMapping = isStrict;
    }

    public boolean getStrictMapping() {
        return this._isStrictMapping;
    }

    public void setLazyServletValidate(boolean isLazy) {
        this._servletManager.setLazyValidate(isLazy);
    }

    public ServletMapping createServletMapping() {
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletContext(this);
        servletMapping.setStrictMapping(this.getStrictMapping());
        return servletMapping;
    }

    public void addServletMapping(ServletMapping servletMapping) throws ServletException {
        servletMapping.setServletContext(this);
        servletMapping.init(this._servletMapper);
    }

    public void addServletRegexp(ServletRegexp servletRegexp) throws ServletException, ClassNotFoundException {
        ServletMapping mapping = new ServletMapping();
        mapping.addURLRegexp(servletRegexp.getURLRegexp());
        mapping.setServletName(servletRegexp.getServletName());
        mapping.setServletClass(servletRegexp.getServletClass());
        mapping.setServletContext(this);
        servletRegexp.getBuilderProgram().configure(mapping);
        mapping.setStrictMapping(this.getStrictMapping());
        mapping.init(this._servletMapper);
    }

    public void addFilter(FilterConfigImpl config) {
        config.setServletContext(this);
        this._filterManager.addFilter(config);
    }

    public void addFilterMapping(FilterMapping filterMapping) throws ServletException {
        filterMapping.setServletContext(this);
        if (filterMapping.isRequest()) {
            this._filterMapper.addFilterMapping(filterMapping);
            this._loginFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isInclude()) {
            this._includeFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isForward()) {
            this._forwardFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isError()) {
            this._errorFilterMapper.addFilterMapping(filterMapping);
        }
    }

    public void addPersistenceContextRef(PersistenceContextRefConfig persistenceContextRefConfig) throws ServletException {
        log.fine("WebApp adding persistence context ref: " + persistenceContextRefConfig.getPersistenceContextRefName());
        String unitName = persistenceContextRefConfig.getPersistenceUnitName();
        log.fine("WebApp looking up entity manager: " + AmberContainer.getPersistenceContextJndiPrefix() + unitName);
        Object obj = Jndi.lookup(AmberContainer.getPersistenceContextJndiPrefix() + unitName);
        log.fine("WebApp found entity manager: " + obj);
        String contextRefName = persistenceContextRefConfig.getPersistenceContextRefName();
        try {
            Jndi.bindDeep("java:comp/env/" + contextRefName, obj);
        }
        catch (NamingException e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void setDispatchWrapsFilters(boolean wrap) {
        this._dispatchWrapsFilters = wrap;
    }

    public boolean getDispatchWrapsFilters() {
        return this._dispatchWrapsFilters;
    }

    public void setDirectoryServlet(String className) throws Exception {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletName("directory");
        if (className.equals("none")) {
            config.setServletClass("com.caucho.servlets.ErrorStatusServlet");
        } else {
            config.setServletClass(className);
        }
        this.addServlet(config);
    }

    public void addWelcomeFileList(WelcomeFileList list) {
        ArrayList<String> fileList = list.getWelcomeFileList();
        this._servletMapper.setWelcomeFileList(fileList);
    }

    public LocaleEncodingMappingList createLocaleEncodingMappingList() {
        return new LocaleEncodingMappingList(this);
    }

    public void setInheritSession(boolean isInheritSession) {
        this._isInheritSession = isInheritSession;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public SessionManager createSessionConfig() throws Exception {
        if (this._isInheritSession) {
            return new SessionManager(this);
        }
        return this.getSessionManager();
    }

    public void addSessionConfig(SessionManager manager) throws ConfigException {
        if (this._isInheritSession) {
            manager.close();
        }
    }

    public void setCookieHttpOnly(boolean isHttpOnly) {
        this._cookieHttpOnly = isHttpOnly;
    }

    public boolean getCookieHttpOnly() {
        return this._cookieHttpOnly;
    }

    public InitParam createContextParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._servletAllowEL);
        return initParam;
    }

    public void addContextParam(InitParam initParam) {
        HashMap<String, String> map = initParam.getParameters();
        for (String key : map.keySet()) {
            String value = map.get(key);
            this.setInitParameter(key, value);
        }
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._errorPageManager.addErrorPage(errorPage);
    }

    public AccessLog createAccessLog() {
        return new AccessLog();
    }

    public void setAccessLog(AbstractAccessLog log) {
        this._accessLog = log;
        _accessLogLocal.set(log);
    }

    public void addMimeMapping(MimeMapping mimeMapping) {
        this._mimeMapping.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
    }

    public void putLocaleEncoding(String locale, String encoding) {
        this._localeMapping.put(locale.toLowerCase(), encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        String key = locale.toString();
        String encoding = this._localeMapping.get(key.toLowerCase());
        if (encoding != null) {
            return encoding;
        }
        if (locale.getVariant() != null && (encoding = this._localeMapping.get((key = locale.getLanguage() + '_' + locale.getCountry()).toLowerCase())) != null) {
            return encoding;
        }
        if (locale.getCountry() != null && (encoding = this._localeMapping.get((key = locale.getLanguage()).toLowerCase())) != null) {
            return encoding;
        }
        return Encoding.getMimeName((Locale)locale);
    }

    public void setLoginConfig(LoginConfig loginConfig) throws Throwable {
        this._loginManager = loginConfig.getLogin();
    }

    public void setLogin(Login login) {
        this._loginFactory = login;
    }

    public RewriteDispatch createRewriteDispatch() {
        if (this._rewriteDispatch == null) {
            this._rewriteDispatch = new RewriteDispatch(this);
        }
        return this._rewriteDispatch;
    }

    public RewriteRealPath createRewriteRealPath() {
        if (this._rewriteRealPath == null) {
            this._rewriteRealPath = new RewriteRealPath(this.getAppDir());
        }
        return this._rewriteRealPath;
    }

    public void addPathMapping(PathMapping pathMapping) throws Exception {
        String urlPattern = pathMapping.getUrlPattern();
        String urlRegexp = pathMapping.getUrlRegexp();
        String realPath = pathMapping.getRealPath();
        if (urlPattern != null) {
            this.createRewriteRealPath().addPathPattern(urlPattern, realPath);
        } else if (urlRegexp != null) {
            this.createRewriteRealPath().addPathRegexp(urlRegexp, realPath);
        } else {
            throw new NullPointerException();
        }
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        this._constraintManager.addConstraint(constraint);
    }

    public void addSecurityRole(SecurityRole role) {
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
        if (isSecure) {
            TransportConstraint transConstraint = new TransportConstraint("secure");
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.setURLPattern("/*");
            constraint.addConstraint(transConstraint);
            this._constraintManager.addConstraint(constraint);
        }
    }

    public void addListener(Listener listener) throws Exception {
        if (!this.hasListener(listener.getListenerClass())) {
            this._listeners.add(listener);
            if (this._lifecycle.isStarting() || this._lifecycle.isActive()) {
                this.addListenerObject(listener.createListenerObject(), true);
            }
        }
    }

    public boolean hasListener(Class listenerClass) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            Listener listener = this._listeners.get(i);
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    private void addListenerObject(Object listenerObj, boolean start) {
        if (listenerObj instanceof ServletContextListener) {
            ServletContextListener scListener = (ServletContextListener)listenerObj;
            this._webAppListeners.add(scListener);
            if (start) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                try {
                    scListener.contextInitialized(event);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        if (listenerObj instanceof ServletContextAttributeListener) {
            this.addAttributeListener((ServletContextAttributeListener)listenerObj);
        }
        if (listenerObj instanceof ServletRequestListener) {
            this._requestListeners.add((ServletRequestListener)listenerObj);
            this._requestListenerArray = new ServletRequestListener[this._requestListeners.size()];
            this._requestListeners.toArray(this._requestListenerArray);
        }
        if (listenerObj instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listenerObj);
            this._requestAttributeListenerArray = new ServletRequestAttributeListener[this._requestAttributeListeners.size()];
            this._requestAttributeListeners.toArray(this._requestAttributeListenerArray);
        }
        if (listenerObj instanceof HttpSessionListener) {
            this.getSessionManager().addListener((HttpSessionListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionAttributeListener) {
            this.getSessionManager().addAttributeListener((HttpSessionAttributeListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionActivationListener) {
            this.getSessionManager().addActivationListener((HttpSessionActivationListener)listenerObj);
        }
    }

    public ServletRequestListener[] getRequestListeners() {
        return this._requestListenerArray;
    }

    public ServletRequestAttributeListener[] getRequestAttributeListeners() {
        return this._requestAttributeListenerArray;
    }

    public void addResourceRef(ResourceRef ref) {
        this._resourceValidators.add(ref);
    }

    public MultipartForm createMultipartForm() {
        if (this._multipartForm == null) {
            this._multipartForm = new MultipartForm();
        }
        return this._multipartForm;
    }

    public boolean doMultipartForm() {
        return this._multipartForm != null && this._multipartForm.isEnable();
    }

    public long getFormUploadMax() {
        if (this._multipartForm != null) {
            return this._multipartForm.getUploadMax();
        }
        return -1L;
    }

    public AbstractAccessLog getAccessLog() {
        return this._accessLog;
    }

    public void setTempDir(Path path) {
        this._tempDir = path;
    }

    public JspPropertyGroup createJsp() {
        if (this._jsp == null) {
            this._jsp = new JspPropertyGroup();
        }
        return this._jsp;
    }

    public JspPropertyGroup getJsp() {
        return this._jsp;
    }

    public JspApplicationContextImpl getJspApplicationContext() {
        return this._jspApplicationContext;
    }

    public boolean has23Config() {
        return this._jspState == 1;
    }

    public void addTaglib(JspTaglib taglib) {
        if (this._taglibList == null) {
            this._taglibList = new ArrayList();
        }
        this._taglibList.add(taglib);
    }

    public ArrayList<JspTaglib> getTaglibList() {
        return this._taglibList;
    }

    public JspConfig createJspConfig() {
        return new JspConfig(this);
    }

    public void addJspConfig(JspConfig config) {
        this._extensions.put("jsp-config", config);
    }

    public Object getExtension(String key) {
        return this._extensions.get(key);
    }

    public EjbRef createEjbRef() {
        if (this._controller != null && this._controller.getArchivePath() != null) {
            return new EjbRef(this._controller.getArchivePath());
        }
        return new EjbRef();
    }

    public EjbLocalRef createEjbLocalRef() {
        if (this._controller != null && this._controller.getArchivePath() != null) {
            return new EjbLocalRef(this._controller.getArchivePath());
        }
        return new EjbLocalRef();
    }

    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return this._parent.createWebAppDeploy();
    }

    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = deploy.getURLPrefix();
        deploy.setURLPrefix(contextPath + prefix);
        deploy.setParent(this._controller);
        deploy.setParentClassLoader(this.getClassLoader());
        for (WebAppConfig configDefault : this._webAppDefaultList) {
            deploy.addWebAppDefault(configDefault);
        }
        Environment.addEnvironmentListener(deploy, this.getClassLoader());
        this._appGenerators.add(deploy);
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaultList.add(config);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public void addWebApp(WebAppConfig config) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = config.getId();
        if (prefix == null || prefix.equals("") || prefix.equals("/")) {
            throw new ConfigException(L.l("'{0}' is an illegal sub web-app id.", (Object)prefix));
        }
        WebAppContainer container = this._parent;
        DeployContainer<WebAppController> appGenerator = this._parent.getWebAppGenerator();
        WebAppSingleDeployGenerator deploy = new WebAppSingleDeployGenerator(appGenerator, container, config);
        deploy.setURLPrefix(contextPath + prefix);
        deploy.setParentWebApp(this._controller);
        deploy.setParentClassLoader(this.getClassLoader());
        deploy.setContainer(container);
        for (WebAppConfig configDefault : this._webAppDefaultList) {
            deploy.addWebAppDefault(configDefault);
        }
        String appDir = config.getDocumentDirectory();
        if (appDir == null) {
            appDir = "./" + prefix;
        }
        Path root = PathBuilder.lookupPath(appDir, null, this.getAppDir());
        deploy.setRootDirectory(root);
        deploy.init();
        this._parent.addDeploy(deploy);
    }

    @Override
    public void setConfigException(Throwable e) {
        if (e != null) {
            Throwable e1;
            for (e1 = e; e1 != null && !(e1 instanceof ConfigException) && e1.getCause() != null && e1.getCause() != e1; e1 = e1.getCause()) {
            }
            if (e1 != null) {
                if (e1 instanceof ConfigException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.WARNING, e1.toString(), e1);
                    } else {
                        log.warning(e1.getMessage());
                    }
                } else {
                    log.log(Level.WARNING, e1.toString(), e1);
                }
            }
        }
        if (this._configException == null) {
            this._configException = e;
        }
        if (e != null) {
            this._classLoader.addDependency((Dependency)AlwaysModified.create());
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public Cluster getCluster() {
        return Cluster.getCluster(this.getClassLoader());
    }

    public boolean isIgnoreClientDisconnect() {
        DispatchServer server = this.getDispatchServer();
        if (server == null) {
            return true;
        }
        return server.isIgnoreClientDisconnect();
    }

    public void setShutdownWaitMax(Period wait) {
        this._shutdownWaitTime = wait.getPeriod();
        Resin resin = Resin.getLocal();
        if (resin != null && resin.getShutdownWaitMax() < this._shutdownWaitTime) {
            log.warning(L.l("web-app shutdown-wait-max '{0}' is longer than resin shutdown-wait-max '{1}'.", (Object)this._shutdownWaitTime, (Object)resin.getShutdownWaitMax()));
        }
    }

    public void setActiveWaitTime(Period wait) {
        this._activeWaitTime = wait.getPeriod();
    }

    public void setIdleTime(Period idle) {
        this._idleTime = idle.getPeriod();
    }

    public void addConfigFile(Path path) throws Exception {
        ResinImport rImport = new ResinImport();
        rImport.setPath(path);
        rImport.setOptional(true);
        rImport.setParent(this);
        rImport.init();
        log.config("<config-file> is deprecated.  Please use resin:import.");
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public boolean isInit() {
        return this._lifecycle.isInit() || this._configException != null;
    }

    public boolean isInitializing() {
        return this._lifecycle.isBeforeActive();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    static ThreadLocal<ServletRequest> getRequestThreadLocal() {
        return _requestThreadLocal;
    }

    public static ServletRequest getThreadRequest() {
        return _requestThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostConstruct
    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        try {
            this._classLoader.setId("web-app:" + this.getURL());
            this._invocationDependency.setCheckInterval(this.getEnvironmentClassLoader().getDependencyCheckInterval());
            if (this._tempDir == null) {
                this._tempDir = (Path)Environment.getLevelAttribute("caucho.temp-dir");
            }
            if (this._tempDir == null) {
                this._tempDir = this.getAppDir().lookup("WEB-INF/tmp");
                if (this.getAppDir().lookup("WEB-INF").isDirectory()) {
                    this._tempDir.mkdirs();
                }
            } else {
                this._tempDir.mkdirs();
            }
            this.setAttribute("javax.servlet.context.tempdir", new File(this._tempDir.getNativePath()));
            FilterChainBuilder securityBuilder = this._constraintManager.getFilterBuilder();
            if (securityBuilder != null) {
                this._filterMapper.addTopFilter(securityBuilder);
            }
            this._cache = (AbstractCache)Environment.getAttribute("caucho.server.cache");
            for (int i = 0; i < this._appGenerators.size(); ++i) {
                this._parent.addDeploy(this._appGenerators.get(i));
            }
            this._classLoader.setId("web-app:" + this.getURL());
            WebBeansContainer webBeans = WebBeansContainer.getCurrent();
            ServletAuthenticator auth = null;
            try {
                auth = webBeans.getByType(ServletAuthenticator.class, new Annotation[0]);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            this.setAttribute("caucho.authenticator", auth);
            WebAppController parent = null;
            if (this._controller != null) {
                parent = this._controller.getParent();
            }
            if (this._isInheritSession && parent != null && this._sessionManager != parent.getWebApp().getSessionManager()) {
                SessionManager sessionManager = this._sessionManager;
                this._sessionManager = parent.getWebApp().getSessionManager();
                if (sessionManager != null) {
                    sessionManager.close();
                }
            }
            if (this.getSessionManager() != null) {
                this.getSessionManager().init();
            }
            this._characterEncoding = CharacterEncoding.getLocalEncoding();
            for (int i = 0; i < this._resourceValidators.size(); ++i) {
                Validator validator = this._resourceValidators.get(i);
                validator.validate();
            }
            Object var8_10 = null;
            this._lifecycle.toInit();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this._lifecycle.toInit();
            throw throwable;
        }
    }

    public WebAppAdmin getAdmin() {
        return this._controller.getAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() {
        boolean isOkay;
        ClassLoader oldLoader;
        Thread thread;
        block23: {
            block22: {
                if (!this._lifecycle.isAfterInit()) {
                    throw new IllegalStateException(L.l("webApp must be initialized before starting.  Currently in state {0}.", (Object)this._lifecycle.getStateName()));
                }
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                isOkay = true;
                try {
                    thread.setContextClassLoader(this._classLoader);
                    if (!this._lifecycle.toStarting()) {
                        Object var12_4 = null;
                        if (!isOkay) {
                            this._lifecycle.toError();
                        }
                        break block22;
                    }
                    isOkay = false;
                    if (this._accessLog == null) {
                        this._accessLog = _accessLogLocal.get();
                    }
                    long interval = this._classLoader.getDependencyCheckInterval();
                    this._invocationDependency.setCheckInterval(interval);
                    if (this._parent != null) {
                        this._invocationDependency.add(this._parent.getWebAppGenerator());
                    }
                    this._invocationDependency.clearModified();
                    this._classLoader.clearModified();
                    String serverId = (String)new EnvironmentLocal("caucho.server-id").get();
                    if (serverId != null) {
                        this.setAttribute("caucho.server-id", serverId);
                    }
                    this._classLoader.start();
                    if (this._configException == null) {
                        this._configException = Environment.getConfigException();
                    }
                    try {
                        this.getSessionManager().start();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    this._jspApplicationContext.addELResolver(new WebBeansELResolver());
                    ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                    for (Listener listener : this._listeners) {
                        try {
                            this.addListenerObject(listener.createListenerObject(), false);
                        }
                        catch (Exception e) {
                            throw ConfigException.create((Throwable)e);
                        }
                    }
                    for (int i = 0; i < this._webAppListeners.size(); ++i) {
                        Listener listener;
                        listener = this._webAppListeners.get(i);
                        try {
                            listener.contextInitialized(event);
                            continue;
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.toString(), e);
                        }
                    }
                    try {
                        this._filterManager.init();
                        this._servletManager.init();
                    }
                    catch (Exception e) {
                        this.setConfigException(e);
                    }
                    if (this._parent instanceof Host) {
                        Host host = (Host)this._parent;
                        host.setConfigETag(null);
                    }
                    this._lifecycle.toActive();
                    this.clearCache();
                    isOkay = true;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var12_6 = null;
                    if (!isOkay) {
                        this._lifecycle.toError();
                    }
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            thread.setContextClassLoader(oldLoader);
            return;
        }
        Object var12_5 = null;
        if (!isOkay) {
            this._lifecycle.toError();
        }
        thread.setContextClassLoader(oldLoader);
    }

    @Override
    public boolean isModified() {
        if (this._lifecycle.isAfterActive()) {
            return true;
        }
        return this._classLoader.isModified();
    }

    @Override
    public boolean isModifiedNow() {
        this._classLoader.isModifiedNow();
        this._invocationDependency.isModifiedNow();
        return this.isModified();
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._lifecycle.isAfterActive()) {
            return true;
        }
        return this._classLoader.logModified(log);
    }

    @Override
    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        if (this._idleTime < 0L) {
            return false;
        }
        return this._lastRequestTime + this._idleTime < Alarm.getCurrentTime();
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(L.l("getContext URI must not be null."));
        }
        if (!uri.startsWith("/")) {
            if (uri.equals("")) {
                uri = "/";
            } else {
                throw new IllegalArgumentException(L.l("getContext URI '{0}' must be absolute.", (Object)uri));
            }
        }
        try {
            if (this._isDisableCrossContext) {
                return uri.startsWith(this.getContextPath()) ? this : null;
            }
            if (this._parent != null) {
                return this._parent.findSubWebAppByURI(uri);
            }
            return this;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public String getServletPattern(String uri) {
        return this._servletMapper.getServletPattern(uri);
    }

    public ArrayList<String> getServletMappingPatterns() {
        return this._servletMapper.getURLPatterns();
    }

    public ArrayList<String> getServletIgnoreMappingPatterns() {
        return this._servletMapper.getIgnorePatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocation buildInvocation(Invocation invocation) {
        Object chain;
        ClassLoader oldLoader;
        Thread thread;
        block19: {
            block18: {
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this.getClassLoader());
                chain = null;
                if (this._configException == null) break block18;
                chain = new ExceptionFilterChain(this._configException);
                invocation.setFilterChain((FilterChain)chain);
                invocation.setDependency((Dependency)AlwaysModified.create());
                Invocation invocation2 = invocation;
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                return invocation2;
            }
            if (this._lifecycle.waitForActive(this._activeWaitTime)) break block19;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " returned 503 busy for '" + invocation.getRawURI() + "'");
            }
            int code = 503;
            chain = new ErrorFilterChain(code);
            invocation.setFilterChain((FilterChain)chain);
            invocation.setDependency((Dependency)AlwaysModified.create());
            Invocation invocation3 = invocation;
            Object var10_11 = null;
            thread.setContextClassLoader(oldLoader);
            return invocation3;
        }
        try {
            Invocation oldInvocation;
            FilterChainEntry entry = null;
            String query = invocation.getQueryString();
            boolean isCache = true;
            if (query != null && query.indexOf("jsp_precompile") >= 0) {
                isCache = false;
            } else if (this._rewriteDispatch != null) {
                isCache = false;
            }
            if (isCache) {
                entry = (FilterChainEntry)this._filterChainCache.get((Object)invocation.getContextURI());
            }
            if (entry != null && !entry.isModified()) {
                chain = entry.getFilterChain();
            } else {
                chain = this._servletMapper.mapServlet(invocation);
                if (this._rewriteDispatch != null) {
                    chain = this._rewriteDispatch.map(invocation.getContextURI(), invocation.getQueryString(), (FilterChain)chain);
                }
                this._filterMapper.buildDispatchChain(invocation, (FilterChain)chain);
                chain = invocation.getFilterChain();
                entry = new FilterChainEntry((FilterChain)chain, invocation);
                chain = entry.getFilterChain();
                if (isCache) {
                    this._filterChainCache.put((Object)invocation.getContextURI(), (Object)entry);
                }
            }
            if (this._cache != null) {
                chain = this._cache.createFilterChain((FilterChain)chain, this);
            }
            if (this._isStatisticsEnabled) {
                chain = new StatisticsFilterChain((FilterChain)chain, this);
            }
            WebAppFilterChain webAppChain = new WebAppFilterChain((FilterChain)chain, this);
            webAppChain.setSecurityRoleMap(invocation.getSecurityRoleMap());
            invocation.setFilterChain(webAppChain);
            invocation.setPathInfo(entry.getPathInfo());
            invocation.setServletPath(entry.getServletPath());
            if (this._oldWebApp != null && Alarm.getCurrentTime() < this._oldWebAppExpireTime) {
                oldInvocation = new Invocation();
                oldInvocation.copyFrom(invocation);
                oldInvocation.setWebApp(this._oldWebApp);
                this._oldWebApp.buildInvocation(oldInvocation);
                invocation = new VersionInvocation(invocation, this, oldInvocation, oldInvocation.getWebApp(), this._oldWebAppExpireTime);
            }
            oldInvocation = invocation;
            Object var10_12 = null;
            thread.setContextClassLoader(oldLoader);
            return oldInvocation;
        }
        catch (Throwable e) {
            try {
                Object chain2 = new ExceptionFilterChain(e);
                chain2 = new WebAppFilterChain((FilterChain)chain2, this);
                invocation.setDependency((Dependency)AlwaysModified.create());
                invocation.setFilterChain((FilterChain)chain2);
                Invocation invocation4 = invocation;
                Object var10_13 = null;
                thread.setContextClassLoader(oldLoader);
                return invocation4;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        WebAppContainer parent;
        DispatchServer server = this.getDispatchServer();
        if (server != null) {
            server.clearCache();
        }
        if ((parent = this._parent) != null) {
            parent.clearCache();
        }
        LruCache<String, FilterChainEntry> lruCache = this._filterChainCache;
        synchronized (lruCache) {
            this._filterChainCache.clear();
            this._dispatcherCache = null;
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._includeFilterMapper);
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._forwardFilterMapper);
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._errorFilterMapper);
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._loginFilterMapper);
    }

    public void buildDispatchInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._filterMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchInvocation(Invocation invocation, FilterMapper filterMapper) throws ServletException {
        invocation.setWebApp(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        try {
            Object chain;
            if (this._configException != null) {
                chain = new ExceptionFilterChain(this._configException);
                invocation.setDependency((Dependency)AlwaysModified.create());
            } else if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                UnavailableException exn = new UnavailableException(L.l("'{0}' is not currently available.", (Object)this.getContextPath()));
                chain = new ExceptionFilterChain(exn);
                invocation.setDependency((Dependency)AlwaysModified.create());
            } else {
                chain = this._servletMapper.mapServlet(invocation);
                filterMapper.buildDispatchChain(invocation, (FilterChain)chain);
                chain = invocation.getFilterChain();
                chain = new DispatchFilterChain((FilterChain)chain, this);
                if (this._cache != null && filterMapper == this._includeFilterMapper) {
                    chain = this._cache.createFilterChain((FilterChain)chain, this);
                }
            }
            invocation.setFilterChain((FilterChain)chain);
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url '{0}' must be absolute", (Object)url));
        }
        RequestDispatcherImpl disp = (RequestDispatcherImpl)this.getDispatcherCache().get((Object)url);
        if (disp != null && !disp.isModified()) {
            return disp;
        }
        SubInvocation includeInvocation = new SubInvocation();
        SubInvocation forwardInvocation = new SubInvocation();
        SubInvocation errorInvocation = new SubInvocation();
        SubInvocation dispatchInvocation = new SubInvocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = this.escapeURL(this._contextPath + url);
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            decoder.splitQuery(dispatchInvocation, rawURI);
            if (this._parent != null) {
                this._parent.buildIncludeInvocation(includeInvocation);
                this._parent.buildForwardInvocation(forwardInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
                this._parent.buildDispatchInvocation(dispatchInvocation);
            } else {
                if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                    throw new IllegalStateException(L.l("'{0}' is restarting and is not yet ready to receive requests", (Object)this._contextPath));
                }
                FilterChain chain = this._servletMapper.mapServlet(includeInvocation);
                this._includeFilterMapper.buildDispatchChain(includeInvocation, chain);
                includeInvocation.setWebApp(this);
                chain = this._servletMapper.mapServlet(forwardInvocation);
                this._forwardFilterMapper.buildDispatchChain(forwardInvocation, chain);
                forwardInvocation.setWebApp(this);
                chain = this._servletMapper.mapServlet(errorInvocation);
                this._errorFilterMapper.buildDispatchChain(errorInvocation, chain);
                errorInvocation.setWebApp(this);
                chain = this._servletMapper.mapServlet(dispatchInvocation);
                this._filterMapper.buildDispatchChain(dispatchInvocation, chain);
                dispatchInvocation.setWebApp(this);
            }
            disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, dispatchInvocation, this);
            this.getDispatcherCache().put((Object)url, (Object)disp);
            return disp;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void accessLog(HttpServletRequest req, HttpServletResponse res) throws IOException {
        AbstractAccessLog log = this.getAccessLog();
        if (log != null) {
            log.log(req, res, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LruCache<String, RequestDispatcherImpl> getDispatcherCache() {
        LruCache cache = this._dispatcherCache;
        if (cache != null) {
            return cache;
        }
        WebApp webApp = this;
        synchronized (webApp) {
            this._dispatcherCache = cache = new LruCache(1024);
            return cache;
        }
    }

    private String escapeURL(String url) {
        return url;
    }

    public RequestDispatcher getLoginDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url '{0}' must be absolute", (Object)url));
        }
        Invocation loginInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = this._contextPath + url;
        try {
            decoder.splitQuery(loginInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                throw new IllegalStateException(L.l("'{0}' is restarting and it not yet ready to receive requests", (Object)this._contextPath));
            }
            if (this._parent != null) {
                this._parent.buildInvocation(loginInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
            } else {
                FilterChain chain = this._servletMapper.mapServlet(loginInvocation);
                this._filterMapper.buildDispatchChain(loginInvocation, chain);
                chain = this._servletMapper.mapServlet(errorInvocation);
                this._errorFilterMapper.buildDispatchChain(errorInvocation, chain);
            }
            RequestDispatcherImpl disp = new RequestDispatcherImpl(loginInvocation, loginInvocation, errorInvocation, loginInvocation, this);
            disp.setLogin(true);
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String servletName) {
        try {
            FilterChain chain = this._servletManager.createServletChain(servletName);
            FilterChain includeChain = this._includeFilterMapper.buildFilterChain(chain, servletName);
            FilterChain forwardChain = this._forwardFilterMapper.buildFilterChain(chain, servletName);
            return new NamedDispatcherImpl(includeChain, forwardChain, null, this);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    @Override
    public String getRealPath(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        String realPath = (String)this._realPathCache.get((Object)uri);
        if (realPath != null) {
            return realPath;
        }
        String fullURI = this.getContextPath() + "/" + uri;
        try {
            fullURI = InvocationDecoder.normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        WebApp app = (WebApp)this.getContext(fullURI);
        if (app == null) {
            return null;
        }
        String cp = app.getContextPath();
        String tail = fullURI.substring(cp.length());
        realPath = app.getRealPathImpl(tail);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("real-path " + uri + " -> " + realPath);
        }
        this._realPathCache.put((Object)uri, (Object)realPath);
        return realPath;
    }

    public String getRealPathImpl(String uri) {
        return this.createRewriteRealPath().mapToRealPath(uri);
    }

    @Override
    public String getMimeType(String uri) {
        if (uri == null) {
            return null;
        }
        String fullURI = this.getContextPath() + "/" + uri;
        try {
            fullURI = InvocationDecoder.normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        WebApp app = (WebApp)this.getContext(fullURI);
        if (app == null) {
            return null;
        }
        int p = uri.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        return app.getMimeTypeImpl(uri.substring(p));
    }

    public String getMimeTypeImpl(String ext) {
        return this._mimeMapping.get(ext);
    }

    @Override
    public void log(String message, Throwable e) {
        if (e != null) {
            log.log(Level.WARNING, this + " " + message, e);
        } else {
            log.info(this + " " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLogin getLogin() {
        if (this._loginFactory != null) {
            Login login = this._loginFactory;
            synchronized (login) {
                this._login = this._loginFactory.getLoginObject();
            }
            return this._login;
        }
        return this._loginManager;
    }

    public ServletAuthenticator getAuthenticator() {
        AbstractLogin login = this.getLogin();
        if (login != null) {
            return login.getAuthenticator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            if (this._lifecycle.isStopped()) {
                throw new IllegalStateException(L.l("Resin is shutting down."));
            }
            if (this._isInheritSession && this._parent != null) {
                this._sessionManager = this._parent.getSessionManager();
            }
            if (this._sessionManager == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    try {
                        thread.setContextClassLoader(this.getClassLoader());
                        this._sessionManager = new SessionManager(this);
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var5_4 = null;
                        thread.setContextClassLoader(oldLoader);
                    }
                    Object var5_3 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
        }
        return this._sessionManager;
    }

    public ErrorPageManager getErrorPageManager() {
        return this._errorPageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean enterWebApp() {
        Object object = this._countLock;
        synchronized (object) {
            ++this._requestCount;
            this._lastRequestTime = Alarm.getCurrentTime();
        }
        return this._lifecycle.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void exitWebApp() {
        Object object = this._countLock;
        synchronized (object) {
            --this._requestCount;
        }
    }

    public int getRequestCount() {
        return this._requestCount;
    }

    public void addCacheMapping(CacheMapping mapping) throws Exception {
        if (mapping.getUrlRegexp() != null) {
            this._cacheMappingMap.addRegexp(mapping.getUrlRegexp(), mapping);
        } else {
            this._cacheMappingMap.addMap(mapping.getUrlPattern(), mapping);
        }
    }

    public long getMaxAge(String uri) {
        CacheMapping map = this._cacheMappingMap.map(uri);
        if (map != null) {
            return map.getMaxAge();
        }
        return Long.MIN_VALUE;
    }

    public long getSMaxAge(String uri) {
        CacheMapping map = this._cacheMappingMap.map(uri);
        if (map != null) {
            return map.getSMaxAge();
        }
        return Long.MIN_VALUE;
    }

    public long getCacheMaxLength() {
        return this._cache.getMaxEntrySize();
    }

    public String[] getClassLoaderHackPackages() {
        return _classLoaderHackPackages;
    }

    public int getActiveSessionCount() {
        SessionManager manager = this.getSessionManager();
        if (manager != null) {
            return manager.getActiveSessionCount();
        }
        return 0;
    }

    void updateStatistics(long time, int readBytes, int writeBytes, boolean isClientDisconnect) {
        this._controller.updateStatistics(time, readBytes, writeBytes, isClientDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (!this._lifecycle.toStopping()) {
                Object var11_3 = null;
                thread.setContextClassLoader(oldLoader);
                this._lifecycle.toStop();
                return;
            }
            long beginStop = Alarm.getCurrentTime();
            while (this._requestCount > 0 && Alarm.getCurrentTime() < beginStop + this._shutdownWaitTime && !Alarm.isTest()) {
                try {
                    Thread.interrupted();
                    Thread.sleep(100L);
                }
                catch (Throwable e) {}
            }
            if (this._requestCount > 0) {
                log.warning(L.l("{0} closing with {1} active requests.", (Object)this.toString(), this._requestCount));
            }
            ServletContextEvent event = new ServletContextEvent((ServletContext)this);
            SessionManager sessionManager = this._sessionManager;
            this._sessionManager = null;
            if (!(sessionManager == null || this._isInheritSession && this._controller.getParent() != null)) {
                sessionManager.close();
            }
            if (this._servletManager != null) {
                this._servletManager.destroy();
            }
            if (this._filterManager != null) {
                this._filterManager.destroy();
            }
            if (this._webAppListeners != null) {
                for (int i = this._webAppListeners.size() - 1; i >= 0; --i) {
                    ServletContextListener listener = this._webAppListeners.get(i);
                    try {
                        listener.contextDestroyed(event);
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            try {
                this._classLoader.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var11_5 = null;
            thread.setContextClassLoader(oldLoader);
            this._lifecycle.toStop();
            throw throwable;
        }
        Object var11_4 = null;
        thread.setContextClassLoader(oldLoader);
        this._lifecycle.toStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this.clearCache();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            for (int i = this._appGenerators.size() - 1; i >= 0; --i) {
                try {
                    DeployGenerator deploy = this._appGenerators.get(i);
                    this._parent.removeWebAppDeploy(deploy);
                    deploy.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            if (this._accessLog != null) {
                this._accessLog.flush();
            }
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            this._classLoader.destroy();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            thread.setContextClassLoader(oldLoader);
            this._classLoader.destroy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatus500() {
        WebApp webApp = this;
        synchronized (webApp) {
            ++this._status500CountTotal;
            this._status500LastTime = Alarm.getExactTime();
        }
    }

    long getStatus500CountTotal() {
        return this._status500CountTotal;
    }

    long getStatus500LastTime() {
        return this._status500LastTime;
    }

    private Object writeReplace() {
        return new WebBeansHandle(WebApp.class);
    }

    public String toString() {
        return "WebApp[" + this.getURL() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterChainEntry {
        FilterChain _filterChain;
        String _pathInfo;
        String _servletPath;
        HashMap<String, String> _securityRoleMap;
        final Dependency _dependency;

        FilterChainEntry(FilterChain filterChain, Invocation invocation) {
            this._filterChain = filterChain;
            this._pathInfo = invocation.getPathInfo();
            this._servletPath = invocation.getServletPath();
            this._dependency = invocation.getDependency();
        }

        boolean isModified() {
            return this._dependency != null && this._dependency.isModified();
        }

        FilterChain getFilterChain() {
            return this._filterChain;
        }

        HashMap<String, String> getSecurityRoleMap() {
            return this._securityRoleMap;
        }

        void setSecurityRoleMap(HashMap<String, String> roleMap) {
            this._securityRoleMap = roleMap;
        }

        String getPathInfo() {
            return this._pathInfo;
        }

        String getServletPath() {
            return this._servletPath;
        }
    }
}

