/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.host.Host;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppAdmin
extends DeployControllerAdmin<WebAppController>
implements WebAppMXBean {
    private static final L10N L = new L10N(WebAppAdmin.class);

    public WebAppAdmin(WebAppController controller) {
        super(controller);
    }

    @Override
    public HostMXBean getHost() {
        Host host = ((WebAppController)this.getController()).getHost();
        if (host != null) {
            return host.getAdmin();
        }
        return null;
    }

    @Override
    public SessionManagerMXBean getSessionManager() {
        WebApp app = this.getWebApp();
        if (app == null) {
            return null;
        }
        return app.getSessionManager().getAdmin();
    }

    @Override
    public String getContextPath() {
        return ((WebAppController)this.getController()).getContextPath();
    }

    @Override
    public String getVersion() {
        return ((WebAppController)this.getController()).getVersion();
    }

    @Override
    public Map<String, String> getManifestAttributes() {
        return ((WebAppController)this.getController()).getManifestAttributes();
    }

    @Override
    public long getStatus500CountTotal() {
        return this.getWebApp().getStatus500CountTotal();
    }

    @Override
    public Date getStatus500LastTime() {
        long lastTime = this.getWebApp().getStatus500LastTime();
        if (lastTime > 0L) {
            return new Date(lastTime);
        }
        return null;
    }

    @Override
    public int getRequestCount() {
        return this.getWebApp().getRequestCount();
    }

    @Override
    public long getRequestCountTotal() {
        return ((WebAppController)this.getController()).getLifetimeConnectionCount();
    }

    @Override
    public long getRequestTimeTotal() {
        return ((WebAppController)this.getController()).getLifetimeConnectionTime();
    }

    @Override
    public long getRequestReadBytesTotal() {
        return ((WebAppController)this.getController()).getLifetimeReadBytes();
    }

    @Override
    public long getRequestWriteBytesTotal() {
        return ((WebAppController)this.getController()).getLifetimeWriteBytes();
    }

    @Override
    public long getClientDisconnectCountTotal() {
        return ((WebAppController)this.getController()).getLifetimeClientDisconnectCount();
    }

    protected WebApp getWebApp() {
        return ((WebAppController)this.getController()).getWebApp();
    }
}

