/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WebAppConfig
extends DeployConfig {
    private static final L10N L = new L10N(WebAppConfig.class);
    private static final Logger log = Logger.getLogger(WebAppConfig.class.getName());
    private Pattern _urlRegexp;
    private String _contextPath;
    private WebAppConfig _prologue;

    public String getContextPath() {
        String cp = this._contextPath;
        if (cp == null) {
            cp = this.getId();
        }
        if (cp == null) {
            return null;
        }
        if (cp.endsWith("/")) {
            return cp.substring(0, cp.length() - 1);
        }
        return cp;
    }

    public void setContextPath(String path) throws ConfigException {
        if (!path.startsWith("/")) {
            throw new ConfigException(L.l("context-path '{0}' must start with '/'.", (Object)path));
        }
        this._contextPath = path;
    }

    public void setURLRegexp(String pattern) {
        if (!pattern.endsWith("$")) {
            pattern = pattern + "$";
        }
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        this._urlRegexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
    }

    public Pattern getURLRegexp() {
        return this._urlRegexp;
    }

    public void setAppDir(RawString appDir) {
        this.setRootDirectory(appDir);
    }

    public String getAppDir() {
        return this.getRootDirectory();
    }

    public String getDocumentDirectory() {
        return this.getAppDir();
    }

    public void setDocumentDirectory(RawString dir) {
        this.setRootDirectory(dir);
    }

    public void setLazyInit(boolean isLazy) throws ConfigException {
        log.config(L.l("lazy-init is deprecated.  Use <startup-mode>lazy</startup-mode> instead."));
        if (isLazy) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void setPrologue(WebAppConfig prologue) {
        this._prologue = prologue;
    }

    public DeployConfig getPrologue() {
        return this._prologue;
    }
}

