/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.server.cluster.Server;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.e_app.EarSingleDeployGenerator;
import com.caucho.server.host.Host;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.session.SessionManager;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.ContextFilterChain;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppEarDeployGenerator;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.server.webapp.WebAppRegexpDeployGenerator;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppContainer
implements DispatchBuilder,
ClassLoaderListener,
EnvironmentListener {
    static final L10N L = new L10N(WebApp.class);
    static final Logger log = Log.open(WebAppContainer.class);
    private DispatchServer _dispatchServer;
    private EnvironmentClassLoader _classLoader;
    private Path _rootDir;
    private Path _docDir;
    private RewriteDispatch _rewriteDispatch;
    private WebApp _errorWebApp;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private DeployContainer<EarDeployController> _earDeploy;
    private DeployContainer<WebAppController> _appDeploy;
    private WebAppExpandDeployGenerator _warGenerator;
    private boolean _hasWarGenerator;
    private LruCache<String, WebAppController> _uriToAppCache = new LruCache(8192);
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private AbstractAccessLog _accessLog;
    private ErrorPageManager _errorPageManager;
    private long _startWaitTime = 10000L;
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle();

    public WebAppContainer() {
        this((EnvironmentClassLoader)Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppContainer(EnvironmentClassLoader loader) {
        this._rootDir = Vfs.lookup();
        this._docDir = Vfs.lookup();
        this._classLoader = loader;
        this._errorPageManager = new ErrorPageManager();
        this._errorPageManager.setWebAppContainer(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            this._earDeploy = new DeployContainer();
            this._appDeploy = new DeployContainer();
            this._warGenerator = new WebAppExpandDeployGenerator(this._appDeploy, this);
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void setDispatchServer(DispatchServer server) {
        this._dispatchServer = server;
    }

    public DispatchServer getDispatchServer() {
        return this._dispatchServer;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    public Host getHost() {
        return null;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
        Vfs.setPwd(path, this.getClassLoader());
    }

    public Path getDocumentDirectory() {
        return this._docDir;
    }

    public void setDocumentDirectory(Path path) {
        this._docDir = path;
    }

    public void setDocDir(Path path) {
        this.setDocumentDirectory(path);
    }

    public AbstractAccessLog createAccessLog() {
        if (this._accessLog == null) {
            this._accessLog = new AccessLog();
        }
        return this._accessLog;
    }

    public void setAccessLog(AbstractAccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._errorPageManager.addErrorPage(errorPage);
    }

    public ErrorPageManager getErrorPageManager() {
        return this._errorPageManager;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public DeployContainer<WebAppController> getWebAppGenerator() {
        return this._appDeploy;
    }

    public SessionManager getSessionManager() {
        return null;
    }

    public RewriteDispatch createRewriteDispatch() {
        if (this._rewriteDispatch == null) {
            this._rewriteDispatch = new RewriteDispatch((Server)this.getDispatchServer());
        }
        return this._rewriteDispatch;
    }

    public boolean isModified() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModified();
    }

    public void addWebApp(WebAppConfig config) throws Exception {
        if (config.getURLRegexp() != null) {
            WebAppRegexpDeployGenerator deploy = new WebAppRegexpDeployGenerator(this._appDeploy, this, config);
            this._appDeploy.add(deploy);
            return;
        }
        WebAppController oldEntry = this._appDeploy.findController(config.getContextPath());
        if (oldEntry != null && oldEntry.getSourceType().equals("single")) {
            throw new ConfigException(L.l("duplicate web-app '{0}' forbidden.", (Object)config.getId()));
        }
        WebAppSingleDeployGenerator deploy = new WebAppSingleDeployGenerator(this._appDeploy, this, config);
        deploy.deploy();
        this._appDeploy.add(deploy);
        this.clearCache();
    }

    void removeWebApp(WebAppController entry) {
        this._appDeploy.remove(entry.getContextPath());
        this.clearCache();
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public WebAppExpandDeployGenerator createWarDeploy() {
        return new WebAppExpandDeployGenerator(this._appDeploy, this);
    }

    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return this.createWarDeploy();
    }

    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws ConfigException {
        this.addWarDeploy(deploy);
    }

    public void addWarDeploy(WebAppExpandDeployGenerator webAppDeploy) throws ConfigException {
        assert (webAppDeploy.getContainer() == this);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this._warGenerator = webAppDeploy;
        }
        this._appDeploy.add(webAppDeploy);
    }

    public void addDeploy(DeployGenerator deploy) throws ConfigException {
        if (deploy instanceof WebAppExpandDeployGenerator) {
            this.addWebAppDeploy((WebAppExpandDeployGenerator)deploy);
        } else {
            this._appDeploy.add(deploy);
        }
    }

    public void removeWebAppDeploy(DeployGenerator deploy) {
        this._appDeploy.remove(deploy);
    }

    public void updateWebAppDeploy(String name) throws Throwable {
        Throwable configException;
        this.clearCache();
        this._appDeploy.update();
        WebAppController controller = this._appDeploy.update(name);
        if (controller != null && (configException = controller.getConfigException()) != null) {
            throw configException;
        }
    }

    public void addApplication(EarConfig config) {
        EarSingleDeployGenerator deploy = new EarSingleDeployGenerator(this._earDeploy, this, config);
        this._earDeploy.add(deploy);
    }

    public void updateEarDeploy(String name) throws Throwable {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
            Throwable configException = entry.getConfigException();
            if (configException != null) {
                throw configException;
            }
        }
    }

    public void expandEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
    }

    public void startEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
    }

    public void addEarDefault(EarConfig config) {
        this._earDefaultList.add(config);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public EarDeployGenerator createEarDeploy() throws Exception {
        return new EarDeployGenerator(this._earDeploy, this);
    }

    public void addEarDeploy(EarDeployGenerator earDeploy) throws Exception {
        this._earDeploy.add(earDeploy);
        this._appDeploy.add(new WebAppEarDeployGenerator(this._appDeploy, this, earDeploy));
    }

    public String getURL() {
        return "";
    }

    public String getHostName() {
        return "";
    }

    public void setWarDir(Path warDir) throws ConfigException {
        this._warGenerator.setPath(warDir);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this.addWebAppDeploy(this._warGenerator);
        }
    }

    public Path getWarDir() {
        return this._warGenerator.getPath();
    }

    public void setWarExpandDir(Path warDir) {
        this._warGenerator.setExpandDirectory(warDir);
    }

    public Path getWarExpandDir() {
        return this._warGenerator.getExpandDirectory();
    }

    @PostConstruct
    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        log.fine(this + " initializing");
        this._lifecycle.toInit();
    }

    protected void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this._appDeploy.start();
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void clearCache() {
        if (this._dispatchServer != null) {
            this._dispatchServer.clearCache();
        }
        this._uriToAppCache.clear();
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) throws Exception {
        String queryString;
        String uri;
        FilterChain rewriteChain;
        boolean isAlwaysModified;
        FilterChain chain;
        if (this._configException != null) {
            ExceptionFilterChain chain2 = new ExceptionFilterChain(this._configException);
            invocation.setFilterChain(chain2);
            invocation.setDependency((Dependency)AlwaysModified.create());
            return invocation;
        }
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain3 = new ErrorFilterChain(code);
            invocation.setFilterChain(chain3);
            if (this._dispatchServer instanceof Server) {
                Server server = (Server)this._dispatchServer;
                invocation.setWebApp(this.getErrorWebApp());
            }
            invocation.setDependency((Dependency)AlwaysModified.create());
            return invocation;
        }
        WebApp app = this.getWebApp(invocation, true);
        if (app != null) {
            invocation = app.buildInvocation(invocation);
            chain = invocation.getFilterChain();
            isAlwaysModified = false;
        } else {
            int code = 404;
            chain = new ErrorFilterChain(code);
            ContextFilterChain contextChain = new ContextFilterChain(chain);
            contextChain.setErrorPageManager(this._errorPageManager);
            chain = contextChain;
            invocation.setFilterChain(contextChain);
            isAlwaysModified = true;
        }
        if (this._rewriteDispatch != null && (rewriteChain = this._rewriteDispatch.map(uri = invocation.getURI(), queryString = invocation.getQueryString(), chain)) != chain) {
            Server server = (Server)this._dispatchServer;
            WebApp webApp = this.findWebAppByURI("/");
            if (webApp != null) {
                invocation.setWebApp(webApp);
            } else {
                invocation.setWebApp(this.getErrorWebApp());
            }
            invocation.setFilterChain(rewriteChain);
            isAlwaysModified = false;
        }
        if (isAlwaysModified) {
            invocation.setDependency((Dependency)AlwaysModified.create());
        }
        return invocation;
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", (Object)url));
        }
        Invocation includeInvocation = new Invocation();
        Invocation forwardInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        Invocation dispatchInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = url;
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            decoder.splitQuery(dispatchInvocation, rawURI);
            this.buildIncludeInvocation(includeInvocation);
            this.buildForwardInvocation(forwardInvocation);
            this.buildErrorInvocation(errorInvocation);
            this.buildDispatchInvocation(dispatchInvocation);
            RequestDispatcherImpl disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, dispatchInvocation, this.getWebApp(includeInvocation, false));
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildIncludeInvocation(invocation);
        }
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildForwardInvocation(invocation);
        }
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildErrorInvocation(invocation);
        }
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildErrorInvocation(invocation);
        }
    }

    public void buildDispatchInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildDispatchInvocation(invocation);
        }
    }

    private WebApp buildSubInvocation(Invocation invocation) {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency((Dependency)AlwaysModified.create());
            return null;
        }
        WebAppController appController = this.getWebAppController(invocation);
        if (appController == null) {
            String url = invocation.getURI();
            FileNotFoundException e = new FileNotFoundException(url);
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency((Dependency)AlwaysModified.create());
            return null;
        }
        WebApp app = (WebApp)appController.subrequest();
        if (app == null) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency((Dependency)AlwaysModified.create());
            return null;
        }
        return app;
    }

    private WebApp getWebApp(Invocation invocation, boolean enableRedeploy) throws ServletException {
        try {
            WebAppController controller = this.getWebAppController(invocation);
            if (controller != null) {
                WebApp app = enableRedeploy ? (WebApp)controller.request() : (WebApp)controller.subrequest();
                if (app == null) {
                    return null;
                }
                invocation.setWebApp(app);
                return app;
            }
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private WebAppController getWebAppController(Invocation invocation) {
        WebAppController controller = this.findByURI(invocation.getURI());
        if (controller == null) {
            return null;
        }
        String invocationURI = invocation.getURI();
        String contextPath = controller.getContextPath(invocationURI);
        invocation.setContextPath(invocationURI.substring(0, contextPath.length()));
        String uri = invocationURI.substring(contextPath.length());
        invocation.setContextURI(uri);
        return controller;
    }

    public WebApp findWebAppByURI(String uri) throws Exception {
        WebAppController controller = this.findByURI(uri);
        if (controller != null) {
            return (WebApp)controller.request();
        }
        return null;
    }

    public WebApp findSubWebAppByURI(String uri) throws Exception {
        WebAppController controller = this.findByURI(uri);
        if (controller != null) {
            return (WebApp)controller.subrequest();
        }
        return null;
    }

    public WebAppController findByURI(String uri) {
        WebAppController controller;
        if (this._appDeploy.isModified()) {
            this._uriToAppCache.clear();
        }
        if ((controller = (WebAppController)this._uriToAppCache.get((Object)uri)) != null) {
            return controller;
        }
        String cleanUri = uri;
        if (CauchoSystem.isCaseInsensitive()) {
            cleanUri = cleanUri.toLowerCase();
        }
        try {
            cleanUri = InvocationDecoder.normalizeUri(cleanUri);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        controller = this.findByURIImpl(cleanUri);
        this._uriToAppCache.put((Object)uri, (Object)controller);
        return controller;
    }

    private WebAppController findByURIImpl(String subURI) {
        WebAppController controller = (WebAppController)this._uriToAppCache.get((Object)subURI);
        if (controller != null) {
            return controller;
        }
        int length = subURI.length();
        int p = subURI.lastIndexOf(47);
        if ((p < 0 || p < length - 1) && (controller = this._appDeploy.findController(subURI)) != null) {
            this._uriToAppCache.put((Object)subURI, (Object)controller);
            return controller;
        }
        if (p >= 0 && (controller = this.findByURIImpl(subURI.substring(0, p))) != null) {
            this._uriToAppCache.put((Object)subURI, (Object)controller);
        }
        return controller;
    }

    public WebAppController findController(String subURI) {
        return this._appDeploy.findController(subURI);
    }

    public ArrayList<WebAppController> getWebAppList() {
        return this._appDeploy.getControllers();
    }

    public ArrayList<EarDeployController> getEntAppList() {
        return this._earDeploy.getControllers();
    }

    public final boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public final boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean stop() {
        if (!this._lifecycle.toStop()) {
            return false;
        }
        this._earDeploy.stop();
        this._appDeploy.stop();
        return true;
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._earDeploy.destroy();
        this._appDeploy.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getErrorWebApp() {
        if (this._errorWebApp == null && this._classLoader != null && !this._classLoader.isModified()) {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    this._errorWebApp = new WebApp(this.getRootDirectory().lookup("caucho-web-app-error"));
                    this._errorWebApp.setParent(this);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var5_4 = null;
                    thread.setContextClassLoader(loader);
                }
                Object var5_3 = null;
                thread.setContextClassLoader(loader);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                thread.setContextClassLoader(loader);
                throw throwable;
            }
        }
        return this._errorWebApp;
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }
}

