/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.log.Log;
import com.caucho.management.j2ee.J2EEManagedObject;
import com.caucho.management.j2ee.WebModule;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployControllerAdmin;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.host.Host;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.el.ELException;
import javax.webbeans.Standard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppController
extends EnvironmentDeployController<WebApp, WebAppConfig> {
    private static final L10N L = new L10N(WebAppController.class);
    private static final Logger log = Log.open(WebAppController.class);
    protected WebAppContainer _container;
    private WebAppController _parent;
    private String _contextPath;
    private String _version = "";
    private WebAppController _oldWebAppController;
    private long _oldWebAppExpireTime;
    private String _warName;
    private ArrayList<String> _regexpValues;
    private boolean _isInheritSession;
    private boolean _isDynamicDeploy;
    private ArrayList<Path> _dependPathList = new ArrayList();
    private String _sourceType = "unknown";
    private final Object _statisticsLock = new Object();
    private volatile long _lifetimeConnectionCount;
    private volatile long _lifetimeConnectionTime;
    private volatile long _lifetimeReadBytes;
    private volatile long _lifetimeWriteBytes;
    private volatile long _lifetimeClientDisconnectCount;
    private WebAppAdmin _admin = new WebAppAdmin(this);

    public WebAppController() {
        this("/", "/", null, null);
    }

    public WebAppController(String name, String contextPath, Path rootDirectory, WebAppContainer container) {
        super(name, rootDirectory);
        this._container = container;
        this.setContextPath(contextPath);
        this.getVariableMap().put("app", new Var());
        this.getVariableMap().put("webApp", new Var());
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this._contextPath = contextPath;
    }

    public String getContextPath(String uri) {
        if (this.getConfig() == null || ((WebAppConfig)this.getConfig()).getURLRegexp() == null) {
            return this.getContextPath();
        }
        Pattern regexp = ((WebAppConfig)this.getConfig()).getURLRegexp();
        Matcher matcher = regexp.matcher(uri);
        int tail = 0;
        while (tail >= 0 && tail <= uri.length()) {
            String prefix = uri.substring(0, tail);
            matcher.reset(prefix);
            if (matcher.find() && matcher.start() == 0) {
                return matcher.group();
            }
            if (tail >= uri.length()) break;
            if ((tail = uri.indexOf(47, tail + 1)) >= 0) continue;
            tail = uri.length();
        }
        return this._contextPath;
    }

    public void setWarName(String warName) {
        this._warName = warName;
    }

    public String getWarName() {
        return this._warName;
    }

    public String getURL() {
        if (this._container != null) {
            return this._container.getURL() + this._contextPath;
        }
        return this._contextPath;
    }

    public WebAppController getParent() {
        return this._parent;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setParentWebApp(WebAppController parent) {
        this._parent = parent;
    }

    public Host getHost() {
        if (this._container != null) {
            return this._container.getHost();
        }
        return null;
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String type) {
        this._sourceType = type;
    }

    public void setRegexpValues(ArrayList<String> values) {
        this._regexpValues = values;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public void setInheritSession(boolean inheritSession) {
        this._isInheritSession = inheritSession;
    }

    public WebApp getWebApp() {
        return (WebApp)this.getDeployInstance();
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    @Override
    protected String getMBeanTypeName() {
        return "WebApp";
    }

    @Override
    protected String getMBeanId() {
        String name = this.getId();
        if (name.equals("")) {
            name = "/";
        }
        return name;
    }

    protected void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setOldWebApp(WebAppController oldWebApp, long expireTime) {
        this._oldWebAppController = oldWebApp;
        this._oldWebAppExpireTime = expireTime;
        WebApp webApp = (WebApp)this.getDeployInstance();
        if (webApp != null) {
            webApp.setOldWebApp((WebApp)oldWebApp.request(), expireTime);
        }
    }

    @Override
    protected DeployControllerAdmin getDeployAdmin() {
        return this._admin;
    }

    @Override
    protected void initEnd() {
        super.initEnd();
        J2EEManagedObject.register(new WebModule(this));
    }

    public WebAppAdmin getAdmin() {
        return this._admin;
    }

    @Override
    public boolean isNameMatch(String url) {
        if (CauchoSystem.isCaseInsensitive()) {
            return url.equalsIgnoreCase(this._contextPath);
        }
        return url.equals(this._contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebAppController merge(WebAppController newController) {
        if (this.getConfig() != null && ((WebAppConfig)this.getConfig()).getURLRegexp() != null) {
            return newController;
        }
        if (newController.getConfig() != null && ((WebAppConfig)newController.getConfig()).getURLRegexp() != null) {
            return this;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            WebAppController mergedController = new WebAppController(this.getContextPath(), this.getContextPath(), this.getRootDirectory(), this._container);
            mergedController.mergeController(this);
            mergedController.mergeController(newController);
            WebAppController webAppController = mergedController;
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
            return webAppController;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public Var getVar() {
        return new Var();
    }

    @Override
    public boolean destroy() {
        if (!super.destroy()) {
            return false;
        }
        if (this._container != null) {
            this._container.removeWebApp(this);
        }
        return true;
    }

    protected void protectedWebApp() throws Exception {
        Path root = this.getRootDirectory();
        root.lookup("WEB-INF").chmod(488);
        root.lookup("META-INF").chmod(488);
    }

    protected void addDependencies() throws Exception {
    }

    public void addDepend(Path path) {
        this._dependPathList.add(path);
    }

    @Override
    protected void initBegin() {
        this.getVariableMap().put("app-dir", this.getRootDirectory());
        super.initBegin();
    }

    @Override
    protected void fillInitList(ArrayList<DeployConfig> initList) {
        if (this._container != null) {
            for (WebAppConfig config : this._container.getWebAppDefaultList()) {
                if (config.getPrologue() == null) continue;
                initList.add(config.getPrologue());
            }
            for (WebAppConfig config : this._container.getWebAppDefaultList()) {
                initList.add(config);
            }
        }
        super.fillInitList(initList);
    }

    @Override
    protected WebApp instantiateDeployInstance() {
        return new Application(this);
    }

    @Override
    protected void configureInstanceVariables(WebApp app) throws Throwable {
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.addSingleton(app, this.getContextPath(), Standard.class);
        webBeans.addSingleton(this.getVar(), "webApp", Standard.class);
        webBeans.addSingleton(this.getVar(), "app", Standard.class);
        for (Map.Entry<String, Object> entry : this.getVariableMap().entrySet()) {
            webBeans.addSingleton(entry.getValue(), entry.getKey(), Standard.class);
        }
        app.setRegexp(this._regexpValues);
        app.setDynamicDeploy(this.isDynamicDeploy());
        if (this._oldWebAppController != null && Alarm.getCurrentTime() < this._oldWebAppExpireTime) {
            app.setOldWebApp((WebApp)this._oldWebAppController.request(), this._oldWebAppExpireTime);
        }
        super.configureInstanceVariables(app);
    }

    @Override
    protected void extendJMXContext(Map<String, String> context) {
        context.put("WebApp", this.getMBeanId());
    }

    protected Path calculateRootDirectory() throws ELException {
        String path;
        Path appDir = null;
        if (appDir == null && this.getConfig() != null && (path = ((WebAppConfig)this.getConfig()).getRootDirectory()) != null) {
            appDir = PathBuilder.lookupPath(path);
        }
        if (appDir == null && this._container != null) {
            appDir = this._container.getDocumentDirectory().lookup("./" + this._contextPath);
        }
        if (appDir == null && this.getDeployInstance() != null) {
            appDir = ((WebApp)this.getDeployInstance()).getAppDir();
        }
        return appDir;
    }

    @Override
    protected void removeExpandFile(Path path, String relPath) throws IOException {
        if (relPath.equals("./WEB-INF/resin-web.xml")) {
            return;
        }
        super.removeExpandFile(path, relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeConnectionCount() {
        Object object = this._statisticsLock;
        synchronized (object) {
            return this._lifetimeConnectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeConnectionTime() {
        Object object = this._statisticsLock;
        synchronized (object) {
            return this._lifetimeConnectionTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeReadBytes() {
        Object object = this._statisticsLock;
        synchronized (object) {
            return this._lifetimeReadBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeWriteBytes() {
        Object object = this._statisticsLock;
        synchronized (object) {
            return this._lifetimeWriteBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeClientDisconnectCount() {
        Object object = this._statisticsLock;
        synchronized (object) {
            return this._lifetimeClientDisconnectCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics(long milliseconds, int readBytes, int writeBytes, boolean isClientDisconnect) {
        Object object = this._statisticsLock;
        synchronized (object) {
            ++this._lifetimeConnectionCount;
            this._lifetimeConnectionTime += milliseconds;
            this._lifetimeReadBytes += (long)readBytes;
            this._lifetimeWriteBytes += (long)writeBytes;
            if (isClientDisconnect) {
                ++this._lifetimeClientDisconnectCount;
            }
        }
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public String toString() {
        if (Alarm.isTest()) {
            return "WebAppController[" + this.getId() + "]";
        }
        return "WebAppController$" + System.identityHashCode(this) + "[" + this.getId() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Var {
        public String getUrl() {
            return WebAppController.this.getURL();
        }

        public String getId() {
            String id = WebAppController.this.getId();
            if (id != null) {
                return id;
            }
            return WebAppController.this.getContextPath();
        }

        public String getName() {
            if (WebAppController.this.getWarName() != null) {
                return WebAppController.this.getWarName();
            }
            return this.getId();
        }

        public Path getAppDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getDocDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRoot() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return WebAppController.this.getRootDirectory();
        }

        public String getContextPath() {
            return WebAppController.this.getContextPath();
        }

        public ArrayList<String> getRegexp() {
            return WebAppController.this._regexpValues;
        }

        public String getVersion() {
            return WebAppController.this._version;
        }

        public String toString() {
            return "WebApp[" + WebAppController.this.getURL() + "]";
        }
    }
}

