/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentListener;
import com.caucho.server.deploy.DeployConfig;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeployGenerator;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGeneratorAdmin;
import com.caucho.server.webapp.WebAppVersioningController;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppExpandDeployGenerator
extends ExpandDeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final Logger log = Logger.getLogger(WebAppExpandDeployGenerator.class.getName());
    private final WebAppExpandDeployGeneratorAdmin _admin;
    private WebAppContainer _container;
    private WebAppController _parent;
    private String _urlPrefix = "";
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private HashMap<Path, WebAppConfig> _webAppConfigMap = new HashMap();
    private HashMap<String, Path> _contextPathMap = new HashMap();
    private ClassLoader _parentLoader;

    public WebAppExpandDeployGenerator(DeployContainer<WebAppController> container, WebAppContainer webAppContainer) {
        super(container, webAppContainer.getRootDirectory());
        this._container = webAppContainer;
        this._parentLoader = webAppContainer.getClassLoader();
        try {
            this.setExtension(".war");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._admin = new WebAppExpandDeployGeneratorAdmin(this);
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setParent(WebAppController parent) {
        this._parent = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (prefix.equals("")) {
            // empty if block
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addWebApp(WebAppConfig config) {
        String docDir = config.getDocumentDirectory();
        Path appDir = this.getExpandDirectory().lookup(docDir);
        this._webAppConfigMap.put(appDir, config);
        if (config.getContextPath() != null) {
            this._contextPathMap.put(config.getContextPath(), appDir);
        }
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaults.add(config);
    }

    @Override
    protected void initImpl() {
        super.initImpl();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        super.fillDeployedKeys(keys);
        for (WebAppConfig cfg : this._webAppConfigMap.values()) {
            if (cfg.getContextPath() == null) continue;
            keys.add(cfg.getContextPath());
        }
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        Environment.addEnvironmentListener(this, this._parentLoader);
        this._admin.register();
    }

    @Override
    protected WebAppController createController(String name) {
        if (!name.startsWith(this._urlPrefix)) {
            return null;
        }
        String segmentName = name.substring(this._urlPrefix.length());
        Path webAppRoot = this._contextPathMap.get(segmentName);
        if (webAppRoot != null) {
            segmentName = "/" + webAppRoot.getTail();
        } else if (segmentName.indexOf(47, 1) > 0) {
            return null;
        }
        String contextPath = segmentName;
        if (segmentName.equals("")) {
            segmentName = CaseInsensitive.isCaseInsensitive() ? "/root" : "/ROOT";
        }
        if (contextPath.equals("/ROOT")) {
            contextPath = "";
        } else if (contextPath.equalsIgnoreCase("/root") && CaseInsensitive.isCaseInsensitive()) {
            contextPath = "";
        }
        ArrayList<String> versionNames = this.getVersionNames(segmentName);
        if (versionNames == null || versionNames.size() == 0) {
            return this.makeController(name, this._urlPrefix + contextPath, this._urlPrefix + segmentName);
        }
        WebAppVersioningController controller = new WebAppVersioningController(name, contextPath, this, this._container);
        return controller;
    }

    private WebAppController makeController(String name, String contextPath, String versionName) {
        WebAppController versionController;
        Path rootDirectory;
        int p;
        String version = "";
        String baseName = contextPath;
        if (this.isVersioning() && (p = versionName.lastIndexOf(45)) > 0) {
            version = versionName.substring(p + 1);
            baseName = versionName.substring(0, p);
        }
        p = versionName.lastIndexOf(47);
        String segmentName = versionName.substring(p + 1);
        String expandName = this.getExpandName(segmentName);
        String archiveName = segmentName + ".war";
        Path jarPath = this.getArchiveDirectory().lookup("./" + archiveName);
        if (jarPath.isDirectory()) {
            rootDirectory = jarPath;
            jarPath = null;
        } else {
            rootDirectory = this.getExpandDirectory().lookup("./" + expandName);
        }
        if (!(rootDirectory.isDirectory() || jarPath != null && jarPath.isFile())) {
            return null;
        }
        if (rootDirectory.isDirectory() && !this.isValidDirectory(rootDirectory, versionName.substring(1))) {
            return null;
        }
        WebAppConfig cfg = this._webAppConfigMap.get(rootDirectory);
        if (cfg != null && cfg.getContextPath() != null) {
            baseName = contextPath = cfg.getContextPath();
        }
        WebAppController controller = new WebAppController(versionName, contextPath, rootDirectory, this._container);
        controller.setWarName(versionName.substring(1));
        controller.setParentWebApp(this._parent);
        controller.setDynamicDeploy(true);
        controller.setSourceType("expand");
        controller.setVersion(version);
        if (!baseName.equals(contextPath) && (versionController = this._container.getWebAppGenerator().findController(baseName)) instanceof WebAppVersioningController) {
            ((WebAppVersioningController)versionController).setModified(true);
        }
        return controller;
    }

    @Override
    protected WebAppController mergeController(WebAppController controller, String key) {
        try {
            Path expandDirectory = this.getExpandDirectory();
            Path rootDirectory = controller.getRootDirectory();
            if (!expandDirectory.equals((Object)rootDirectory.getParent())) {
                return controller;
            }
            if ((controller = super.mergeController(controller, key)).getArchivePath() == null) {
                String archiveName = rootDirectory.getTail() + ".war";
                Path jarPath = this.getArchiveDirectory().lookup(archiveName);
                if (!jarPath.isDirectory()) {
                    controller.setArchivePath(jarPath);
                    controller.addDepend(jarPath);
                }
            }
            controller.setStartupMode(this.getStartupMode());
            for (int i = 0; i < this._webAppDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._webAppDefaults.get(i));
            }
            WebAppConfig cfg = this._webAppConfigMap.get(rootDirectory);
            if (cfg != null) {
                controller.addConfigDefault(cfg);
            }
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINEST, e.toString(), e);
            controller.setConfigException(e);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            controller.setConfigException(e);
        }
        return controller;
    }

    @Override
    protected String pathNameToEntryName(String name) {
        String entryName = super.pathNameToEntryName(name);
        if (entryName == null) {
            return null;
        }
        if (CaseInsensitive.isCaseInsensitive()) {
            try {
                String[] list = this.getExpandDirectory().list();
                String matchName = null;
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].equalsIgnoreCase(entryName)) continue;
                    matchName = list[i];
                }
                if (matchName == null) {
                    matchName = entryName.toLowerCase();
                }
            }
            catch (Exception e) {
                entryName = entryName.toLowerCase();
            }
        }
        if (entryName.equalsIgnoreCase("root")) {
            return this._urlPrefix;
        }
        return this._urlPrefix + "/" + entryName;
    }

    @Override
    protected String entryNameToArchiveName(String entryName) {
        String prefix = this._urlPrefix + "/";
        if (entryName.equals(this._urlPrefix)) {
            return "ROOT" + this.getExtension();
        }
        if (entryName.startsWith(prefix)) {
            return entryName.substring(prefix.length()) + this.getExtension();
        }
        return null;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        this._container.removeWebAppDeploy(this);
        Environment.removeEnvironmentListener(this, this._parentLoader);
        super.destroyImpl();
    }
}

