/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppSingleDeployGenerator
extends DeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final Logger log = Log.open(WebAppSingleDeployGenerator.class);
    private WebAppContainer _container;
    private WebAppController _parentWebApp;
    private String _urlPrefix = "";
    private Path _archivePath;
    private Path _rootDirectory;
    private ArrayList<WebAppConfig> _defaultList = new ArrayList();
    private WebAppConfig _config;
    private ClassLoader _parentLoader;
    private WebAppController _controller;

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer) {
        super(deployContainer);
    }

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer, WebAppContainer container, WebAppConfig config) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        String contextPath = config.getContextPath();
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.setURLPrefix(config.getContextPath());
        this._config = config;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setContainer(WebAppContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentWebApp(WebAppController parent) {
        this._parentWebApp = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (!prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._defaultList.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void initImpl() {
        String archivePath;
        super.initImpl();
        if (this._controller != null) {
            return;
        }
        String appDir = this._config.getDocumentDirectory();
        if (appDir == null) {
            appDir = "./" + this._urlPrefix;
        }
        if (this._rootDirectory == null) {
            this._rootDirectory = PathBuilder.lookupPath(appDir, null, this._container.getDocumentDirectory());
        }
        if ((archivePath = this._config.getArchivePath()) != null) {
            this._archivePath = PathBuilder.lookupPath(archivePath, null, this._container.getRootDirectory());
        }
        this._controller = new WebAppController(this._urlPrefix, this._urlPrefix, this._rootDirectory, this._container);
        this._controller.setArchivePath(this._archivePath);
        if (this._archivePath != null) {
            this._controller.addDepend(this._archivePath);
        }
        this._controller.setParentWebApp(this._parentWebApp);
        for (WebAppConfig config : this._defaultList) {
            this._controller.addConfigDefault(config);
        }
        this._controller.addConfigDefault(this._config);
        this._controller.setPrologue(this._config.getPrologue());
        this._controller.setStartupPriority(this._config.getStartupPriority());
        this._controller.setSourceType("single");
        Environment.addEnvironmentListener(this, this._parentLoader);
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._controller.getContextPath());
    }

    @Override
    public WebAppController generateController(String name) {
        if (name.equals(this._controller.getContextPath())) {
            WebAppController webApp = new WebAppController(this._urlPrefix, this._urlPrefix, this._rootDirectory, this._container);
            webApp.setArchivePath(this._controller.getArchivePath());
            return webApp;
        }
        return null;
    }

    @Override
    public WebAppController mergeController(WebAppController controller, String name) {
        if (controller.getRootDirectory().equals((Object)this._controller.getRootDirectory())) {
            controller.setContextPath(this._controller.getContextPath());
            controller.setDynamicDeploy(false);
            return controller.merge(this._controller);
        }
        if (!this._controller.isNameMatch(name)) {
            return controller;
        }
        return this._controller;
    }

    public void deploy() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public Throwable getConfigException() {
        Throwable configException = super.getConfigException();
        if (configException == null && this._controller != null) {
            configException = this._controller.getConfigException();
        }
        return configException;
    }

    @Override
    protected void destroyImpl() {
        Environment.removeEnvironmentListener(this, this._parentLoader);
        this._container.removeWebAppDeploy(this);
        super.destroyImpl();
    }

    @Override
    public String toString() {
        return "WebAppSingleDeployGenerator[" + this._urlPrefix + "]";
    }
}

