/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

public class WebAppVersioningController
extends WebAppController {
    private static final L10N L = new L10N(WebAppVersioningController.class);
    private static final Logger log = Logger.getLogger(WebAppController.class.getName());
    private static final long EXPIRE_PERIOD = 3600000L;
    private long _versionRolloverTime = 3600000L;
    private ArrayList<WebAppController> _controllerList = new ArrayList();
    private final WebAppExpandDeployGenerator _generator;
    private long _restartTime;
    private WebAppController _primaryController;
    private boolean _isModified = true;

    public WebAppVersioningController(String name, String contextPath, WebAppExpandDeployGenerator generator, WebAppContainer container) {
        super(name, contextPath, null, container);
        this._generator = generator;
    }

    void setModified(boolean isModified) {
        this._isModified = isModified;
    }

    public String getVersion() {
        if (this._primaryController != null) {
            return this._primaryController.getVersion();
        }
        return "";
    }

    public WebApp request() {
        WebAppController controller;
        if (this._isModified) {
            this.updateVersion();
        }
        if ((controller = this._primaryController) != null) {
            return (WebApp)controller.request();
        }
        return null;
    }

    public WebApp subrequest() {
        WebAppController controller;
        if (this._isModified) {
            this.updateVersion();
        }
        if ((controller = this._primaryController) != null) {
            return (WebApp)controller.request();
        }
        return null;
    }

    protected WebApp startImpl() {
        WebAppController controller;
        if (this._isModified) {
            this.updateVersion();
        }
        if ((controller = this._primaryController) != null) {
            return (WebApp)controller.request();
        }
        return null;
    }

    protected void initBegin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersion() {
        WebAppVersioningController webAppVersioningController = this;
        synchronized (webAppVersioningController) {
            if (!this._isModified) {
                return;
            }
            this._isModified = false;
            this._controllerList = new ArrayList();
            ArrayList<String> versionNames = this._generator.getVersionNames(this.getId());
            if (versionNames != null) {
                Collections.sort(versionNames, new VersionNameComparator());
                for (int i = 0; i < versionNames.size() && i < 2; ++i) {
                    String versionName = versionNames.get(i);
                    WebAppController newController = this._container.getWebAppGenerator().findController(versionName);
                    this._controllerList.add(newController);
                }
                this._primaryController = this._controllerList.get(0);
                if (this._restartTime > 0L && this._controllerList.size() > 1) {
                    long expireTime = Alarm.getCurrentTime() + this._versionRolloverTime;
                    this._primaryController.setOldWebApp(this._controllerList.get(1), expireTime);
                }
                this._restartTime = Alarm.getCurrentTime();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VersionNameComparator
    implements Comparator<String> {
        VersionNameComparator() {
        }

        @Override
        public int compare(String versionA, String versionB) {
            int lengthA = versionA.length();
            int lengthB = versionB.length();
            int indexA = 0;
            int indexB = 0;
            while (indexA < lengthA && indexB < lengthB) {
                char chB;
                char chA;
                int valueA = 0;
                int valueB = 0;
                while (indexA < lengthA && '0' <= (chA = versionA.charAt(indexA)) && chA <= '9') {
                    valueA = 10 * valueA + chA - 48;
                    ++indexA;
                }
                while (indexB < lengthB && '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') {
                    valueB = 10 * valueB + chB - 48;
                    ++indexB;
                }
                if (valueA < valueB) {
                    return 1;
                }
                if (valueB < valueA) {
                    return -1;
                }
                while (!(indexA >= lengthA || indexB >= lengthB || '0' <= (chA = versionA.charAt(indexA)) && chA <= '9' || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9')) {
                    if (chA < chB) {
                        return 1;
                    }
                    if (chB < chA) {
                        return -1;
                    }
                    ++indexA;
                    ++indexB;
                }
                if (indexA < lengthA && ('0' > (chA = versionA.charAt(indexA)) || chA > '9')) {
                    return 1;
                }
                if (indexB >= lengthB || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') continue;
                return -1;
            }
            if (indexA != lengthA) {
                return 1;
            }
            if (indexB != lengthB) {
                return -1;
            }
            return 0;
        }
    }
}

