/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FastCGIServlet
extends GenericServlet {
    protected static final Logger log = Log.open(FastCGIServlet.class);
    static final L10N L = new L10N(FastCGIServlet.class);
    private static final int FCGI_BEGIN_REQUEST = 1;
    private static final int FCGI_ABORT_REQUEST = 2;
    private static final int FCGI_END_REQUEST = 3;
    private static final int FCGI_PARAMS = 4;
    private static final int FCGI_STDIN = 5;
    private static final int FCGI_STDOUT = 6;
    private static final int FCGI_STDERR = 7;
    private static final int FCGI_DATA = 8;
    private static final int FCGI_GET_VALUES = 9;
    private static final int FCGI_GET_VALUES_RESULT = 10;
    private static final int FCGI_UNKNOWNE_TYPE = 11;
    private static final int FCGI_RESPONDER = 1;
    private static final int FCGI_AUTHORIZER = 2;
    private static final int FCGI_FILTER = 3;
    private static final int FCGI_VERSION = 1;
    private static final int FCGI_KEEP_CONN = 1;
    private static final int FCGI_REQUEST_COMPLETE = 0;
    private static final int FCGI_CANT_MPX_CONN = 1;
    private static final int FCGI_OVERLOADED = 2;
    private static final int FCGI_UNKNOWN_ROLE = 3;
    private static final ArrayList<Integer> _fcgiServlets = new ArrayList();
    private int _servletId;
    private FreeList<FastCGISocket> _freeSockets = new FreeList(8);
    private String _hostAddress;
    private InetAddress _hostAddr;
    private int _hostPort;
    protected QDate _calendar = new QDate();
    private Application _app;
    private long _readTimeout = 120000L;
    private int _maxKeepaliveCount = 250;
    private long _keepaliveTimeout = 15000L;
    private int _idCount = 0;

    public void setServerAddress(String hostAddress) throws ServletException {
        this._hostAddress = hostAddress;
        try {
            int p = hostAddress.indexOf(58);
            if (p > 0) {
                this._hostPort = new Integer(this._hostAddress.substring(p + 1));
                this._hostAddr = InetAddress.getByName(this._hostAddress.substring(0, p));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setMaxKeepalive(int max) {
        this._maxKeepaliveCount = max;
    }

    public void setKeepaliveTimeout(Period period) {
        this._keepaliveTimeout = period.getPeriod();
    }

    public void setReadTimeout(Period timeout) {
        this._readTimeout = timeout.getPeriod();
    }

    public void init() throws ServletException {
        int id = -1;
        for (int i = 0; i < 65536; i += 1024) {
            if (_fcgiServlets.contains(new Integer(i))) continue;
            id = i;
            break;
        }
        if (id < 0) {
            throw new ServletException("Can't open FastCGI servlet");
        }
        _fcgiServlets.add(new Integer(id));
        this._servletId = id;
        this._app = (Application)this.getServletContext();
        String serverAddress = this.getInitParameter("server-address");
        if (serverAddress != null) {
            this.setServerAddress(serverAddress);
        }
        if (this._hostAddress == null) {
            throw new ServletException("FastCGIServlet needs valid server-address");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        ServletOutputStream out = res.getOutputStream();
        FastCGISocket fcgiSocket = null;
        do {
            if (fcgiSocket == null) continue;
            fcgiSocket.close();
        } while ((fcgiSocket = (FastCGISocket)this._freeSockets.allocate()) != null && !fcgiSocket.isValid());
        if (fcgiSocket != null && fcgiSocket.isValid()) {
            log.finer(fcgiSocket + ": reuse()");
        } else {
            if (fcgiSocket != null) {
                fcgiSocket.close();
            }
            try {
                Socket socket = new Socket(this._hostAddr, this._hostPort);
                if (this._readTimeout > 0L) {
                    socket.setSoTimeout((int)this._readTimeout);
                }
                fcgiSocket = new FastCGISocket(this.nextId(), socket, this._maxKeepaliveCount);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                throw new ServletException(L.l("Can't connect to FastCGI {0}:{1}.  Check that the FastCGI service has started.", (Object)this._hostAddr, this._hostPort));
            }
        }
        boolean isOkay = false;
        try {
            block14: {
                try {
                    fcgiSocket.setExpire(Alarm.getCurrentTime() + this._keepaliveTimeout);
                    if (!this.handleRequest(req, res, fcgiSocket, (OutputStream)out, fcgiSocket.allocateKeepalive()) || !this._freeSockets.free((Object)fcgiSocket)) break block14;
                    log.finer(fcgiSocket + ": keepalive()");
                    fcgiSocket = null;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var10_11 = null;
                    if (fcgiSocket != null) {
                        fcgiSocket.close();
                    }
                }
            }
            Object var10_10 = null;
            if (fcgiSocket != null) {
                fcgiSocket.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (fcgiSocket != null) {
                fcgiSocket.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextId() {
        FastCGIServlet fastCGIServlet = this;
        synchronized (fastCGIServlet) {
            int id = this._idCount++;
            if (id <= 0 || 1024 < id) {
                this._idCount = 2;
                id = 1;
            }
            return id + this._servletId;
        }
    }

    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, FastCGISocket fcgiSocket, OutputStream out, boolean keepalive) throws ServletException, IOException {
        FastCGIInputStream is;
        int ch;
        int sublen;
        ReadStream rs = fcgiSocket.getReadStream();
        WriteStream ws = fcgiSocket.getWriteStream();
        this.writeHeader(fcgiSocket, ws, 1, 8);
        int role = 1;
        ws.write(role >> 8);
        ws.write(role);
        ws.write(keepalive ? 1 : 0);
        for (int i = 0; i < 5; ++i) {
            ws.write(0);
        }
        this.setEnvironment(fcgiSocket, ws, req);
        ServletInputStream in = req.getInputStream();
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buf = tempBuf.getBuffer();
        int len = buf.length;
        this.writeHeader(fcgiSocket, ws, 4, 0);
        boolean hasStdin = false;
        while ((sublen = in.read(buf, 0, len)) > 0) {
            hasStdin = true;
            this.writeHeader(fcgiSocket, ws, 5, sublen);
            ws.write(buf, 0, sublen);
        }
        TempBuffer.free((TempBuffer)tempBuf);
        tempBuf = null;
        if (hasStdin) {
            this.writeHeader(fcgiSocket, ws, 5, 0);
        }
        if ((ch = this.parseHeaders(res, is = new FastCGIInputStream(fcgiSocket))) >= 0) {
            out.write(ch);
        }
        while ((ch = is.read()) >= 0) {
            out.write(ch);
        }
        return !is.isDead() && keepalive;
    }

    private void setEnvironment(FastCGISocket fcgi, WriteStream ws, HttpServletRequest req) throws IOException {
        this.addHeader(fcgi, ws, "REQUEST_URI", req.getRequestURI());
        this.addHeader(fcgi, ws, "REQUEST_METHOD", req.getMethod());
        this.addHeader(fcgi, ws, "SERVER_SOFTWARE", "Resin/" + Version.VERSION);
        this.addHeader(fcgi, ws, "SERVER_NAME", req.getServerName());
        this.addHeader(fcgi, ws, "SERVER_PORT", String.valueOf(req.getServerPort()));
        this.addHeader(fcgi, ws, "REMOTE_ADDR", req.getRemoteAddr());
        this.addHeader(fcgi, ws, "REMOTE_HOST", req.getRemoteAddr());
        if (req.getRemoteUser() != null) {
            this.addHeader(fcgi, ws, "REMOTE_USER", req.getRemoteUser());
        } else {
            this.addHeader(fcgi, ws, "REMOTE_USER", "");
        }
        if (req.getAuthType() != null) {
            this.addHeader(fcgi, ws, "AUTH_TYPE", req.getAuthType());
        }
        this.addHeader(fcgi, ws, "GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader(fcgi, ws, "SERVER_PROTOCOL", req.getProtocol());
        if (req.getQueryString() != null) {
            this.addHeader(fcgi, ws, "QUERY_STRING", req.getQueryString());
        } else {
            this.addHeader(fcgi, ws, "QUERY_STRING", "");
        }
        String scriptPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        Path appDir = this._app.getAppDir();
        String realPath = this._app.getRealPath(scriptPath);
        if (!appDir.lookup(realPath).isFile() && pathInfo != null) {
            scriptPath = scriptPath + pathInfo;
        }
        log.finer("FCGI file: " + this._app.getRealPath(scriptPath));
        this.addHeader(fcgi, ws, "PATH_INFO", req.getContextPath() + scriptPath);
        this.addHeader(fcgi, ws, "PATH_TRANSLATED", this._app.getRealPath(scriptPath));
        int contentLength = req.getContentLength();
        if (contentLength < 0) {
            this.addHeader(fcgi, ws, "CONTENT_LENGTH", "0");
        } else {
            this.addHeader(fcgi, ws, "CONTENT_LENGTH", String.valueOf(contentLength));
        }
        this.addHeader(fcgi, ws, "DOCUMENT_ROOT", this._app.getContext("/").getRealPath("/"));
        CharBuffer cb = new CharBuffer();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (key.equalsIgnoreCase("content-length")) {
                this.addHeader(fcgi, ws, "CONTENT_LENGTH", value);
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                this.addHeader(fcgi, ws, "CONTENT_TYPE", value);
                continue;
            }
            if (key.equalsIgnoreCase("if-modified-since") || key.equalsIgnoreCase("if-none-match") || key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            this.addHeader(fcgi, ws, this.convertHeader(cb, key), value);
        }
    }

    private CharBuffer convertHeader(CharBuffer cb, String key) {
        cb.clear();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        return cb;
    }

    private int parseHeaders(HttpServletResponse res, InputStream is) throws IOException {
        CharBuffer key = new CharBuffer();
        CharBuffer value = new CharBuffer();
        int ch = is.read();
        if (ch < 0) {
            log.fine("Can't contact FastCGI");
            res.sendError(404);
            return -1;
        }
        while (ch >= 0) {
            key.clear();
            value.clear();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = is.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = is.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = is.read();
            }
            if (ch == 13 && (ch = is.read()) == 10) {
                ch = is.read();
            }
            if (key.length() == 0) {
                return ch;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("fastcgi:" + key + ": " + value);
            }
            if (key.equalsIgnoreCase("status")) {
                char digit;
                int status = 0;
                int len = value.length();
                for (int i = 0; i < len && '0' <= (digit = value.charAt(i)) && digit <= '9'; ++i) {
                    status = 10 * status + digit - 48;
                }
                res.setStatus(status);
                continue;
            }
            if (key.startsWith("http") || key.startsWith("HTTP")) continue;
            if (key.equalsIgnoreCase("location")) {
                res.sendRedirect(value.toString());
                continue;
            }
            res.addHeader(key.toString(), value.toString());
        }
        return ch;
    }

    private void addHeader(FastCGISocket fcgiSocket, WriteStream ws, String key, String value) throws IOException {
        int keyLen = key.length();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(fcgiSocket, ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key);
        ws.print(value);
    }

    private void addHeader(FastCGISocket fcgiSocket, WriteStream ws, CharBuffer key, String value) throws IOException {
        int keyLen = key.getLength();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(fcgiSocket, ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key.getBuffer(), 0, keyLen);
        ws.print(value);
    }

    private void writeHeader(FastCGISocket fcgiSocket, WriteStream ws, int type, int length) throws IOException {
        int id = 1;
        int pad = 0;
        ws.write(1);
        ws.write(type);
        ws.write(id >> 8);
        ws.write(id);
        ws.write(length >> 8);
        ws.write(length);
        ws.write(pad);
        ws.write(0);
    }

    public void destroy() {
        FastCGISocket socket;
        while ((socket = (FastCGISocket)this._freeSockets.allocate()) != null) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
        _fcgiServlets.remove(new Integer(this._servletId));
    }

    static class FastCGISocket {
        private int _id;
        private int _keepaliveCount;
        private long _expireTime;
        private Socket _socket;
        private SocketStream _socketStream;
        private ReadStream _rs;
        private WriteStream _ws;

        FastCGISocket(int id, Socket socket, int maxKeepaliveCount) {
            this._id = id;
            this._socket = socket;
            this._keepaliveCount = maxKeepaliveCount;
            this._socketStream = new SocketStream(this._socket);
            this._ws = new WriteStream((StreamImpl)this._socketStream);
            this._ws.setDisableClose(true);
            this._rs = new ReadStream((StreamImpl)this._socketStream, this._ws);
            this._rs.setDisableClose(true);
            log.fine(this + ": open()");
        }

        int getId() {
            return this._id;
        }

        void setExpire(long expireTime) {
            this._expireTime = expireTime;
        }

        ReadStream getReadStream() {
            return this._rs;
        }

        WriteStream getWriteStream() {
            return this._ws;
        }

        boolean isValid() {
            return this._socket != null && Alarm.getCurrentTime() < this._expireTime;
        }

        boolean allocateKeepalive() {
            if (!this.isValid()) {
                return false;
            }
            return --this._keepaliveCount > 0;
        }

        boolean isKeepalive() {
            return this._keepaliveCount > 0;
        }

        void close() {
            try {
                log.fine(this + ": close()");
                Socket socket = this._socket;
                this._socket = null;
                this._socketStream = null;
                if (socket != null) {
                    socket.close();
                }
                this._ws.close();
                this._rs.close();
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }

        public String toString() {
            return "FastCGISocket[" + this._id + "," + this._socket + "]";
        }
    }

    static class FastCGIInputStream
    extends InputStream {
        private FastCGISocket _fcgiSocket;
        private InputStream _is;
        private int _chunkLength;
        private int _padLength;
        private boolean _isDead;

        public FastCGIInputStream() {
        }

        public FastCGIInputStream(FastCGISocket fcgiSocket) {
            this.init(fcgiSocket);
        }

        public void init(FastCGISocket fcgiSocket) {
            this._fcgiSocket = fcgiSocket;
            this._is = fcgiSocket.getReadStream();
            this._chunkLength = 0;
            this._isDead = false;
        }

        public boolean isDead() {
            return this._isDead;
        }

        public int read() throws IOException {
            do {
                if (this._chunkLength <= 0) continue;
                --this._chunkLength;
                return this._is.read();
            } while (this.readNext());
            return -1;
        }

        private boolean readNext() throws IOException {
            int version;
            if (this._is == null) {
                return false;
            }
            if (this._padLength > 0) {
                this._is.skip(this._padLength);
                this._padLength = 0;
            }
            block5: while ((version = this._is.read()) >= 0) {
                int type = this._is.read();
                int id = (this._is.read() << 8) + this._is.read();
                int length = (this._is.read() << 8) + this._is.read();
                int padding = this._is.read();
                this._is.read();
                switch (type) {
                    case 3: {
                        int appStatus = (this._is.read() << 24) + (this._is.read() << 16) + (this._is.read() << 8) + this._is.read();
                        int pStatus = this._is.read();
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._fcgiSocket + ": FCGI_END_REQUEST(appStatus:" + appStatus + ", pStatus:" + pStatus + ")");
                        }
                        if (appStatus != 0) {
                            this._isDead = true;
                        }
                        if (pStatus != 0) {
                            this._isDead = true;
                        }
                        this._is.skip(3L);
                        this._is = null;
                        return false;
                    }
                    case 6: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._fcgiSocket + ": FCGI_STDOUT(length:" + length + ", padding:" + padding + ")");
                        }
                        if (length == 0) {
                            if (padding <= 0) continue block5;
                            this._is.skip(padding);
                            continue block5;
                        }
                        this._chunkLength = length;
                        this._padLength = padding;
                        return true;
                    }
                    case 7: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._fcgiSocket + ": FCGI_STDERR(length:" + length + ", padding:" + padding + ")");
                        }
                        byte[] buf = new byte[length];
                        this._is.read(buf, 0, length);
                        log.warning(new String(buf, 0, length));
                        if (padding <= 0) continue block5;
                        this._is.skip(padding);
                        continue block5;
                    }
                }
                log.warning(this._fcgiSocket + ": Unknown Protocol(" + type + ")");
                this._isDead = true;
                this._is.skip(length + padding);
            }
            this._isDead = true;
            return false;
        }
    }
}

