/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.Application;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServlet
extends GenericServlet {
    private Path _context;
    private byte[] _buffer = new byte[1024];
    private Application _app;
    private RequestDispatcher _dir;
    private LruCache<String, Cache> _pathCache;
    private QDate _calendar = new QDate();
    private boolean _isCaseInsensitive = CaseInsensitive.isCaseInsensitive();
    private boolean _isEnableRange = true;
    private String _characterEncoding;

    public void setEnableRange(boolean isEnable) {
        this._isEnableRange = isEnable;
    }

    public void setCharacterEncoding(String encoding) {
        this._characterEncoding = encoding;
    }

    public void init(ServletConfig conf) throws ServletException {
        String encoding;
        super.init(conf);
        this._app = (Application)this.getServletContext();
        this._context = this._app.getAppDir();
        try {
            this._dir = this._app.getNamedDispatcher("directory");
        }
        catch (Throwable e) {
            // empty catch block
        }
        this._pathCache = new LruCache(1024);
        String enable = this.getInitParameter("enable-range");
        if (enable != null && enable.equals("false")) {
            this._isEnableRange = false;
        }
        if ((encoding = this.getInitParameter("character-encoding")) != null && !"".equals(encoding)) {
            this._characterEncoding = encoding;
        }
    }

    private RequestDispatcher getDirectoryServlet() {
        if (this._dir == null) {
            this._dir = this._app.getNamedDispatcher("directory");
        }
        return this._dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String ifRange;
        String range;
        String mime;
        HttpServletRequest req;
        CauchoRequest cauchoReq = null;
        if (request instanceof CauchoRequest) {
            cauchoReq = (CauchoRequest)request;
            req = cauchoReq;
        } else {
            req = (HttpServletRequest)request;
        }
        HttpServletResponse res = (HttpServletResponse)response;
        String method = req.getMethod();
        if (!(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("POST"))) {
            res.sendError(501, "Method not implemented");
            return;
        }
        boolean isInclude = false;
        String uri = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            isInclude = true;
        } else {
            uri = req.getRequestURI();
        }
        Cache cache = (Cache)this._pathCache.get((Object)uri);
        String filename = null;
        if (cache == null) {
            String pathInfo;
            CharBuffer cb = new CharBuffer();
            String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
            if (servletPath != null) {
                cb.append(servletPath);
            }
            if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
                cb.append(pathInfo);
            }
            String relPath = cb.toString();
            if (this._isCaseInsensitive) {
                relPath = relPath.toLowerCase();
            }
            filename = this.getServletContext().getRealPath(relPath);
            Path path = this._context.lookupNative(filename);
            if (cauchoReq != null && cauchoReq.getRequestDepth(0) == 0) {
                if (relPath.regionMatches(true, 0, "/web-inf", 0, 8) && (relPath.length() == 8 || !Character.isLetterOrDigit(relPath.charAt(8)))) {
                    res.sendError(404);
                    return;
                }
                if (relPath.regionMatches(true, 0, "/meta-inf", 0, 9) && (relPath.length() == 9 || !Character.isLetterOrDigit(relPath.charAt(9)))) {
                    res.sendError(404);
                    return;
                }
            }
            if (relPath.endsWith(".DS_store")) {
                res.sendError(404);
                return;
            }
            if (CauchoSystem.isWindows() && relPath.length() != 0 && !path.isDirectory() && path.isWindowsInsecure()) {
                res.sendError(404);
                return;
            }
            for (int i = relPath.length() - 1; i >= 0; --i) {
                char ch = relPath.charAt(i);
                if (ch != '\u0000') continue;
                res.sendError(404);
                return;
            }
            ServletContext app = this.getServletContext();
            cache = new Cache(this._calendar, path, relPath, app.getMimeType(relPath));
            this._pathCache.put((Object)uri, (Object)cache);
        }
        cache.update();
        if (cache.isDirectory()) {
            if (this._dir != null) {
                this._dir.forward((ServletRequest)req, (ServletResponse)res);
            } else {
                res.sendError(404);
            }
            return;
        }
        if (!cache.canRead()) {
            if (isInclude) {
                throw new FileNotFoundException(uri);
            }
            res.sendError(404);
            return;
        }
        String ifMatch = req.getHeader("If-None-Match");
        String etag = cache.getEtag();
        if (ifMatch != null && ifMatch.equals(etag)) {
            res.addHeader("ETag", etag);
            res.sendError(304);
            return;
        }
        String lastModified = cache.getLastModifiedString();
        if (ifMatch == null) {
            String ifModified = req.getHeader("If-Modified-Since");
            boolean isModified = true;
            if (ifModified != null) {
                if (ifModified.equals(lastModified)) {
                    isModified = false;
                } else {
                    long ifModifiedTime;
                    QDate qDate = this._calendar;
                    synchronized (qDate) {
                        try {
                            ifModifiedTime = this._calendar.parseDate(ifModified);
                        }
                        catch (Throwable e) {
                            ifModifiedTime = 0L;
                        }
                    }
                    boolean bl = isModified = ifModifiedTime != cache.getLastModified();
                }
            }
            if (!isModified) {
                if (etag != null) {
                    res.addHeader("ETag", etag);
                }
                res.sendError(304);
                return;
            }
        }
        res.addHeader("ETag", etag);
        res.addHeader("Last-Modified", lastModified);
        if (this._isEnableRange && cauchoReq != null && cauchoReq.isTop()) {
            res.addHeader("Accept-Ranges", "bytes");
        }
        if (this._characterEncoding != null) {
            res.setCharacterEncoding(this._characterEncoding);
        }
        if ((mime = cache.getMimeType()) != null) {
            res.setContentType(mime);
        }
        if (method.equalsIgnoreCase("HEAD")) {
            res.setContentLength((int)cache.getLength());
            return;
        }
        if (this._isEnableRange && (range = req.getHeader("Range")) != null && ((ifRange = req.getHeader("If-Range")) == null || ifRange.equals(etag)) && this.handleRange(req, res, cache, range, mime)) {
            return;
        }
        res.setContentLength((int)cache.getLength());
        if (res instanceof CauchoResponse) {
            CauchoResponse cRes = (CauchoResponse)res;
            cRes.getResponseStream().sendFile(cache.getPath(), cache.getLength());
        } else {
            ServletOutputStream os = res.getOutputStream();
            cache.getPath().writeToStream((OutputStream)os);
        }
    }

    private boolean isWindowsSpecial(String lower, String test) {
        char ch;
        int testLen;
        int p = lower.indexOf(test);
        if (p < 0) {
            return false;
        }
        int lowerLen = lower.length();
        return lowerLen == p + (testLen = test.length()) || (ch = lower.charAt(p + testLen)) == '/' || ch == '.';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRange(HttpServletRequest req, HttpServletResponse res, Cache cache, String range, String mime) throws IOException {
        int length = range.length();
        boolean hasMore = range.indexOf(44) > 0;
        int head = 0;
        ServletOutputStream os = res.getOutputStream();
        boolean isFirstChunk = true;
        String boundary = null;
        int off = range.indexOf("bytes=", head);
        if (off < 0) {
            return false;
        }
        off += 6;
        while (off > 0 && off < length) {
            block19: {
                Object var26_22;
                boolean hasFirst = false;
                long first = 0L;
                boolean hasLast = false;
                long last = 0L;
                int ch = -1;
                while (off < length) {
                    char c = range.charAt(off);
                    ch = c;
                    if (c != ' ') break;
                    ++off;
                }
                while (off < length) {
                    char c = range.charAt(off);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    first = 10L * first + (long)ch - 48L;
                    hasFirst = true;
                    ++off;
                }
                if (length <= off && !isFirstChunk) break;
                if (ch != 45) {
                    return false;
                }
                ++off;
                while (off < length) {
                    char c = range.charAt(off);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    last = 10L * last + (long)ch - 48L;
                    hasLast = true;
                    ++off;
                }
                while (off < length) {
                    char c = range.charAt(off);
                    ch = c;
                    if (c != ' ') break;
                    ++off;
                }
                head = off;
                long cacheLength = cache.getLength();
                if (!hasLast) {
                    if (first == 0L) {
                        return false;
                    }
                    last = cacheLength - 1L;
                }
                if (!hasFirst) {
                    first = cacheLength - last;
                    last = cacheLength - 1L;
                }
                if (last < first || cacheLength <= last) break;
                res.setStatus(206);
                CharBuffer cb = new CharBuffer();
                cb.append("bytes ");
                cb.append(first);
                cb.append('-');
                cb.append(last);
                cb.append('/');
                cb.append(cacheLength);
                String chunkRange = cb.toString();
                if (hasMore) {
                    if (isFirstChunk) {
                        CharBuffer cb1 = new CharBuffer();
                        cb1.append("--");
                        Base64.encode((CharBuffer)cb1, (long)RandomUtil.getRandomLong());
                        boundary = cb1.toString();
                        res.setContentType("multipart/byteranges; boundary=" + boundary);
                    } else {
                        os.write(13);
                        os.write(10);
                    }
                    isFirstChunk = false;
                    os.write(45);
                    os.write(45);
                    os.print(boundary);
                    os.print("\r\nContent-Type: ");
                    os.print(mime);
                    os.print("\r\nContent-Range: ");
                    os.print(chunkRange);
                    os.write(13);
                    os.write(10);
                    os.write(13);
                    os.write(10);
                } else {
                    res.setContentLength((int)(last - first + 1L));
                    res.addHeader("Content-Range", chunkRange);
                }
                ReadStream is = null;
                try {
                    is = cache.getPath().openRead();
                    is.skip(first);
                    os = res.getOutputStream();
                    is.writeToStream((OutputStream)os, (int)(last - first + 1L));
                    var26_22 = null;
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    var26_22 = null;
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            --off;
            while (off < length && range.charAt(off) != ',') {
                ++off;
            }
            ++off;
        }
        if (hasMore) {
            os.write(13);
            os.write(10);
            os.write(45);
            os.write(45);
            os.print(boundary);
            os.write(45);
            os.write(45);
            os.write(13);
            os.write(10);
        }
        return true;
    }

    static class Cache {
        QDate _calendar;
        Path _path;
        boolean _isDirectory;
        boolean _canRead;
        long _length;
        long _lastModified = -2401057700593545203L;
        String _relPath;
        String _etag;
        String _lastModifiedString;
        String _mimeType;

        Cache(QDate calendar, Path path, String relPath, String mimeType) {
            this._calendar = calendar;
            this._path = path;
            this._relPath = relPath;
            this._mimeType = mimeType;
            this.update();
        }

        Path getPath() {
            return this._path;
        }

        boolean canRead() {
            return this._canRead;
        }

        boolean isDirectory() {
            return this._isDirectory;
        }

        long getLength() {
            return this._length;
        }

        String getRelPath() {
            return this._relPath;
        }

        String getEtag() {
            return this._etag;
        }

        long getLastModified() {
            return this._lastModified;
        }

        String getLastModifiedString() {
            return this._lastModifiedString;
        }

        String getMimeType() {
            return this._mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            Cache cache = this;
            synchronized (cache) {
                this.updateData();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateData() {
            long lastModified = this._path.getLastModified();
            long length = this._path.getLength();
            if (lastModified != this._lastModified || length != this._length) {
                this._lastModified = lastModified;
                this._length = length;
                this._canRead = this._path.canRead();
                this._isDirectory = this._path.isDirectory();
                CharBuffer cb = new CharBuffer();
                cb.append('\"');
                Base64.encode((CharBuffer)cb, (long)this._path.getCrc64());
                cb.append('\"');
                this._etag = cb.close();
                QDate qDate = this._calendar;
                synchronized (qDate) {
                    this._calendar.setGMTTime(lastModified);
                    this._lastModifiedString = this._calendar.printDate();
                }
            }
            if (lastModified == 0L) {
                this._canRead = false;
                this._isDirectory = false;
            }
        }
    }
}

