/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.config.types.Period;
import com.caucho.servlets.TcpPool;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyServlet
extends GenericServlet {
    protected static final Logger log = Logger.getLogger(HttpProxyServlet.class.getName());
    static final L10N L = new L10N(HttpProxyServlet.class);
    private TcpPool _tcpPool = new TcpPool();

    public void addAddress(String address) {
        this._tcpPool.addHost(address);
    }

    public void addHost(String host) {
        this._tcpPool.addHost(host);
    }

    public void setFailRecoverTime(Period period) {
        this._tcpPool.setFailRecoverTime(period);
    }

    public void init() throws ServletException {
        this._tcpPool.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        PrintWriter out = res.getWriter();
        String uri = req.isRequestedSessionIdFromUrl() ? req.getRequestURI() + ";jsessionid=" + req.getRequestedSessionId() : req.getRequestURI();
        if (req.getQueryString() != null) {
            uri = uri + '?' + req.getQueryString();
        }
        int count = this._tcpPool.getServerCount();
        for (int i = 0; i < count; ++i) {
            Object var13_12;
            TcpPool.Server server = this._tcpPool.nextServer();
            ReadWritePair pair = null;
            try {
                pair = server.open(uri);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            if (pair == null) continue;
            try {
                if (this.handleRequest(req, res, server, pair)) {
                    var13_12 = null;
                    server.close();
                    return;
                }
                server.fail();
            }
            catch (Throwable throwable) {
                var13_12 = null;
                server.close();
                throw throwable;
            }
            var13_12 = null;
            server.close();
            {
                continue;
            }
        }
        res.sendError(503);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, TcpPool.Server server, ReadWritePair pair) throws ServletException, IOException {
        String hostURL = server.getURL();
        ReadStream rs = pair.getReadStream();
        WriteStream ws = pair.getWriteStream();
        try {
            try {
                ws.setAttribute("method", (Object)req.getMethod());
                ws.setAttribute("X-Forwarded-For", (Object)String.valueOf(req.getRemoteAddr()));
                Enumeration e = req.getHeaderNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Enumeration e1 = req.getHeaders(name);
                    while (e1.hasMoreElements()) {
                        String value = (String)e1.nextElement();
                        ws.setAttribute(name, (Object)value);
                    }
                }
                ServletInputStream is = req.getInputStream();
                ws.writeStream((InputStream)is);
                String status = (String)rs.getAttribute("status");
                int statusCode = 200;
                if (status != null) {
                    try {
                        statusCode = Integer.parseInt(status);
                    }
                    catch (Throwable e1) {
                        // empty catch block
                    }
                }
                String location = null;
                Iterator iter = rs.getAttributeNames();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    if (name.equalsIgnoreCase("status") || name.equalsIgnoreCase("transfer-encoding") || name.equalsIgnoreCase("content-length")) continue;
                    if (name.equalsIgnoreCase("location")) {
                        location = (String)rs.getAttribute("location");
                        continue;
                    }
                    res.addHeader(name, (String)rs.getAttribute(name));
                }
                if (location != null && location.startsWith(hostURL)) {
                    location = location.substring(hostURL.length());
                    String prefix = req.isSecure() ? (req.getServerPort() != 443 ? "https://" + req.getServerName() + ":" + req.getServerPort() : "https://" + req.getServerName()) : (req.getServerPort() != 80 ? "http://" + req.getServerName() + ":" + req.getServerPort() : "http://" + req.getServerName());
                    location = !location.startsWith("/") ? prefix + "/" + location : prefix + location;
                }
                if (location != null) {
                    res.setHeader("Location", location);
                }
                if (statusCode == 302 && location != null) {
                    res.sendRedirect(location);
                } else if (statusCode != 200) {
                    res.setStatus(statusCode);
                }
                ServletOutputStream os = res.getOutputStream();
                rs.writeToStream((OutputStream)os);
            }
            catch (IOException e1) {
                log.log(Level.FINE, e1.toString(), e1);
                boolean bl = false;
                Object var16_20 = null;
                ws.close();
                rs.close();
                return bl;
            }
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            ws.close();
            rs.close();
            throw throwable;
        }
        ws.close();
        rs.close();
        return true;
    }
}

