/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.config.types.Period;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;

public class TcpPool {
    protected static final Logger log = Logger.getLogger(TcpPool.class.getName());
    static final L10N L = new L10N(TcpPool.class);
    private ArrayList<String> _hosts = new ArrayList();
    private Server[] _servers;
    private int _roundRobin;
    private long _failRecoverTime = 30000L;

    public void addAddress(String address) {
        this._hosts.add(address);
    }

    public void addHost(String host) {
        this._hosts.add(host);
    }

    public void setFailRecoverTime(Period period) {
        this._failRecoverTime = period.getPeriod();
    }

    public int getServerCount() {
        return this._hosts.size();
    }

    public void init() throws ServletException {
        if (this._hosts.size() == 0) {
            throw new ServletException(L.l("HttpProxyServlet needs at least one host."));
        }
        this._servers = new Server[this._hosts.size()];
        for (int i = 0; i < this._hosts.size(); ++i) {
            String host = this._hosts.get(i);
            this._servers[i] = new Server(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server nextServer() {
        TcpPool tcpPool = this;
        synchronized (tcpPool) {
            long now = Alarm.getCurrentTime();
            int startIndex = this._roundRobin;
            this._roundRobin = (this._roundRobin + 1) % this._servers.length;
            int bestCost = Integer.MAX_VALUE;
            Server bestServer = null;
            for (int i = 0; i < this._servers.length; ++i) {
                int index = (startIndex + i) % this._servers.length;
                Server server = this._servers[index];
                if (this._failRecoverTime >= now - server.getLastFailTime() || server.getConnectionCount() >= bestCost) continue;
                bestServer = server;
                bestCost = server.getConnectionCount();
            }
            if (bestServer != null) {
                return bestServer;
            }
            int index = this._roundRobin;
            this._roundRobin = (this._roundRobin + 1) % this._servers.length;
            return this._servers[index];
        }
    }

    class Server {
        private Path _path;
        private long _lastFailTime;
        private int _connectionCount;

        Server(String host) {
            this._path = host.startsWith("http") ? Vfs.lookup(host) : Vfs.lookup("http://" + host);
        }

        String getURL() {
            return this._path.getURL();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReadWritePair open(String uri) throws IOException {
            try {
                Path path = this._path.lookup(uri);
                ReadWritePair pair = path.openReadWrite();
                if (pair != null) {
                    Server server = this;
                    synchronized (server) {
                        ++this._connectionCount;
                    }
                }
                return pair;
            }
            catch (IOException e) {
                this.fail();
                throw e;
            }
        }

        long getLastFailTime() {
            return this._lastFailTime;
        }

        int getConnectionCount() {
            return this._connectionCount;
        }

        void fail() {
            this._lastFailTime = Alarm.getCurrentTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Server server = this;
            synchronized (server) {
                --this._connectionCount;
            }
        }
    }
}

