/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.servlets.ssi.SSIFactory;
import com.caucho.servlets.ssi.SSIParser;
import com.caucho.servlets.ssi.Statement;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSIFilter
implements Filter {
    private static final L10N L = new L10N(SSIFilter.class);
    private static final Logger log = Logger.getLogger(SSIFilter.class.getName());
    private SSIFactory _factory;

    public void setFactory(SSIFactory factory) {
        this._factory = factory;
    }

    public void init(FilterConfig config) throws ServletException {
        if (this._factory == null) {
            this._factory = new SSIFactory();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        SSIResponse ssiResponse = new SSIResponse(req, res);
        nextFilter.doFilter((ServletRequest)req, (ServletResponse)ssiResponse);
        ssiResponse.finish(req, res);
    }

    public void destroy() {
    }

    class SSIResponse
    extends CauchoResponseWrapper {
        private HttpServletRequest _request;
        private TempStream _tempStream;
        private WriteStream _out;

        SSIResponse(HttpServletRequest request, HttpServletResponse response) {
            this._request = request;
            this._tempStream = new TempStream();
            this._tempStream.openWrite();
            this._out = new WriteStream((StreamImpl)this._tempStream);
            this.init(response);
        }

        public void setContentLength(int length) {
        }

        protected OutputStream getStream() throws IOException {
            return this._out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
            this.flushBuffer();
            this._out.close();
            ReadStream is = this._tempStream.openRead();
            Statement stmt = null;
            try {
                stmt = new SSIParser(SSIFilter.this._factory).parse(is);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            try {
                WriteStream out = Vfs.openWrite((OutputStream)res.getOutputStream());
                stmt.apply(out, req, res);
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

