/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.servlets.ssi.SSIFactory;
import com.caucho.servlets.ssi.SSIParser;
import com.caucho.servlets.ssi.Statement;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSIServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(SSIServlet.class.getName());
    private SSIFactory _factory;

    public void setFactory(SSIFactory factory) {
        this._factory = factory;
    }

    public void init() throws ServletException {
        super.init();
        if (this._factory == null) {
            this._factory = new SSIFactory();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (servletPath == null && pathInfo == null) {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (pathInfo != null) {
            String fullPath = servletPath + pathInfo;
        } else {
            String fullPath = servletPath;
        }
        String realPath = request.getRealPath(servletPath);
        Path path = Vfs.lookup().lookup(realPath);
        if (!path.canRead() || path.isDirectory()) {
            response.sendError(404);
            return;
        }
        response.setContentType("text/html");
        Statement stmt = new SSIParser(this._factory).parse(path);
        WriteStream out = Vfs.openWrite((OutputStream)response.getOutputStream());
        try {
            stmt.apply(out, request, response);
            out.close();
        }
        catch (Exception e) {
            String errmsg = (String)request.getAttribute("caucho.ssi.errmsg");
            if (errmsg != null && !response.isCommitted()) {
                log.log(Level.FINE, e.toString(), e);
                response.setStatus(500, errmsg);
                response.setContentType("text/html");
                out.clearWrite();
                out.println("<html><head>");
                out.println("<title>" + errmsg + "</title>");
                out.println("</head>");
                out.println("<h1>" + errmsg + "</h1>");
                out.println("</html>");
                out.close();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            throw new ServletException((Throwable)e);
        }
    }
}

