/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.JdbcDriverMXBean;
import com.caucho.sql.DriverConfig;
import java.util.Date;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverAdmin
extends AbstractManagedObject
implements JdbcDriverMXBean {
    private DriverConfig _driver;

    public DriverAdmin(DriverConfig driver) {
        this._driver = driver;
    }

    @Override
    public String getName() {
        return this._driver.getDBPool().getName();
    }

    @Override
    public String getClassName() {
        return this._driver.getType();
    }

    @Override
    public String getUrl() {
        return this._driver.getURL();
    }

    @Override
    protected void addObjectNameProperties(Map<String, String> props) throws MalformedObjectNameException {
        String url = this.getUrl();
        if (url != null) {
            if (url.indexOf(58) >= 0) {
                url = ObjectName.quote(url);
            }
            props.put("url", url);
        }
    }

    @Override
    public String getState() {
        return this._driver.getLifecycle().getStateName();
    }

    @Override
    public long getConnectionCountTotal() {
        return this._driver.getConnectionCountTotal();
    }

    @Override
    public long getConnectionFailCountTotal() {
        return this._driver.getConnectionFailCountTotal();
    }

    @Override
    public Date getLastFailTime() {
        return new Date(this._driver.getLastFailTime());
    }

    @Override
    public boolean start() {
        return this._driver.start();
    }

    @Override
    public boolean stop() {
        return this._driver.stop();
    }

    void register() {
        this.registerSelf();
    }

    @Override
    public String toString() {
        return "JdbcDriverAdmin[" + this.getObjectName() + "]";
    }
}

