/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.config.types.InitParam;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.management.j2ee.J2EEManagedObject;
import com.caucho.management.j2ee.JDBCDriver;
import com.caucho.naming.Jndi;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DatabaseManager;
import com.caucho.sql.DriverAdmin;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.tools.profiler.ConnectionPoolDataSourceWrapper;
import com.caucho.tools.profiler.DriverWrapper;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.ProfilerPointConfig;
import com.caucho.tools.profiler.XADataSourceWrapper;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class DriverConfig {
    protected static final Logger log = Logger.getLogger(DriverConfig.class.getName());
    private static final L10N L = new L10N(DriverConfig.class);
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_DRIVER = 1;
    private static final int TYPE_POOL = 2;
    private static final int TYPE_XA = 3;
    private static final int TYPE_JCA = 4;
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private DBPoolImpl _dbPool;
    private Class _driverClass;
    private String _driverURL;
    private String _user;
    private String _password;
    private Properties _info;
    private ContainerProgram _init = new ContainerProgram();
    private int _driverType;
    private Object _driverObject;
    private ManagedConnectionFactory _jcaDataSource;
    private ConnectionPoolDataSource _poolDataSource;
    private XADataSource _xaDataSource;
    private Driver _driver;
    private Lifecycle _lifecycle = new Lifecycle();
    private DriverAdmin _admin = new DriverAdmin(this);
    private long _connectionCountTotal;
    private long _connectionFailCountTotal;
    private long _lastFailTime;
    private ProfilerPoint _profilerPoint;

    public DriverConfig(DBPoolImpl pool) {
        this._dbPool = pool;
        this._info = new Properties();
    }

    public DBPoolImpl getDBPool() {
        return this._dbPool;
    }

    public void setCauchoDriverType(String type) throws ConfigException {
        if ("ConnectionPoolDataSource".equals(type)) {
            this._driverType = 2;
        } else if ("XADataSource".equals(type)) {
            this._driverType = 3;
        } else if ("ManagedConnectionFactory".equals(type)) {
            this._driverType = 4;
        } else if ("Driver".equals(type)) {
            this._driverType = 1;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown driver type. Valid types are 'ConnectionPoolDataSource', 'XADataSource' and 'Driver'"));
        }
    }

    public void setDataSource(Object dataSource) throws ConfigException {
        if (dataSource instanceof String) {
            dataSource = Jndi.lookup((String)dataSource);
        }
        if (this._driverType == 3) {
            this._xaDataSource = (XADataSource)dataSource;
        } else if (this._driverType == 2) {
            this._poolDataSource = (ConnectionPoolDataSource)dataSource;
        } else if (dataSource instanceof XADataSource) {
            this._xaDataSource = (XADataSource)dataSource;
        } else if (dataSource instanceof ConnectionPoolDataSource) {
            this._poolDataSource = (ConnectionPoolDataSource)dataSource;
        } else if (dataSource instanceof ManagedConnectionFactory) {
            this._jcaDataSource = (ManagedConnectionFactory)dataSource;
        } else {
            throw new ConfigException(L.l("data-source '{0}' is of type '{1}' which does not implement XADataSource or ConnectionPoolDataSource.", dataSource, (Object)dataSource.getClass().getName()));
        }
    }

    public Class getDriverClass() {
        return this._driverClass;
    }

    public void setType(Class driverClass) throws ConfigException {
        this._driverClass = driverClass;
        if (!(Driver.class.isAssignableFrom(driverClass) || XADataSource.class.isAssignableFrom(driverClass) || ConnectionPoolDataSource.class.isAssignableFrom(driverClass) || ManagedConnectionFactory.class.isAssignableFrom(driverClass))) {
            throw new ConfigException(L.l("'{0}' is not a valid database type.", (Object)driverClass.getName()));
        }
        Config.checkCanInstantiate(driverClass);
    }

    public String getType() {
        return this._driverClass.getName();
    }

    public String getURL() {
        return this._driverURL;
    }

    public void setURL(String url) {
        this._driverURL = url;
        this._lifecycle.setName("JdbcDriver[" + url + "]");
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._init.addProgram(program);
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setInitParam(InitParam initParam) {
        this.validateInitParam();
        HashMap<String, String> paramMap = initParam.getParameters();
        for (String key : paramMap.keySet()) {
            this._info.setProperty(key, paramMap.get(key));
        }
    }

    public void setInitParam(String key, String value) {
        this._info.setProperty(key, value);
    }

    public Properties getInfo() {
        return this._info;
    }

    public Driver getDriver() throws SQLException {
        Object obj = this.getDriverObject();
        if (obj instanceof Driver) {
            return (Driver)obj;
        }
        return null;
    }

    public void setDriver(Driver driver) throws SQLException {
        this._driver = driver;
        this._driverObject = driver;
    }

    public ConnectionPoolDataSource getPoolDataSource() throws SQLException {
        return this._poolDataSource;
    }

    public void setPoolDataSource(ConnectionPoolDataSource pDataSource) throws SQLException {
        this._poolDataSource = pDataSource;
        this._driverObject = this._poolDataSource;
    }

    public XADataSource getXADataSource() {
        return this._xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) throws SQLException {
        this._xaDataSource = xaDataSource;
        this._driverObject = this._xaDataSource;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._jcaDataSource;
    }

    public boolean isXATransaction() {
        return this._xaDataSource != null && this._dbPool.isXA();
    }

    public boolean isLocalTransaction() {
        return this._dbPool.isXA();
    }

    public ProfilerPointConfig createProfilerPoint() {
        ProfilerPointConfig profilerPointConfig = new ProfilerPointConfig();
        profilerPointConfig.setName(this.getURL());
        profilerPointConfig.setCategorizing(true);
        return profilerPointConfig;
    }

    public void setProfilerPoint(ProfilerPoint profilerPoint) {
        this._profilerPoint = profilerPoint;
    }

    synchronized void initDataSource(boolean isTransactional, boolean isSpy) throws SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (this._xaDataSource == null && this._poolDataSource == null) {
            this.initDriver();
            Object driverObject = this.getDriverObject();
            if (driverObject == null) {
                throw new SQLExceptionWrapper(L.l("driver '{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, (Object)this.getDBPool().getName()));
            }
            if (this._driverType == 3) {
                this._xaDataSource = (XADataSource)this._driverObject;
            } else if (this._driverType == 2) {
                this._poolDataSource = (ConnectionPoolDataSource)this._driverObject;
            } else if (this._driverType == 1) {
                this._driver = (Driver)this._driverObject;
            } else if (driverObject instanceof XADataSource) {
                this._xaDataSource = (XADataSource)this._driverObject;
            } else if (this._driverObject instanceof ConnectionPoolDataSource) {
                this._poolDataSource = (ConnectionPoolDataSource)this._driverObject;
            } else if (this._driverObject instanceof ManagedConnectionFactory) {
                this._jcaDataSource = (ManagedConnectionFactory)this._driverObject;
            } else if (this._driverObject instanceof Driver) {
                this._driver = (Driver)this._driverObject;
            } else {
                throw new SQLExceptionWrapper(L.l("driver '{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, (Object)this.getDBPool().getName()));
            }
        }
        this._admin.register();
        if (this._profilerPoint != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._profilerPoint.toString());
            }
            if (this._xaDataSource != null) {
                this._xaDataSource = new XADataSourceWrapper(this._profilerPoint, this._xaDataSource);
            } else if (this._poolDataSource != null) {
                this._poolDataSource = new ConnectionPoolDataSourceWrapper(this._profilerPoint, this._poolDataSource);
            } else if (this._driver != null) {
                this._driver = new DriverWrapper(this._profilerPoint, this._driver);
            }
        }
        if (this._info.size() != 0) {
            this.validateInitParam();
        }
        J2EEManagedObject.register(new JDBCDriver(this));
    }

    Lifecycle getLifecycle() {
        return this._lifecycle;
    }

    boolean start() {
        return this._lifecycle.toActive();
    }

    boolean stop() {
        return this._lifecycle.toStop();
    }

    private void validateInitParam() {
        if (this._jcaDataSource != null) {
            throw new ConfigException(L.l("<init-param> cannot be used with a JCA data source.  Use the init-param key as a tag, like <key>value</key>"));
        }
        if (this._poolDataSource != null) {
            throw new ConfigException(L.l("<init-param> cannot be used with a ConnectionPoolDataSource.  Use the init-param key as a tag, like <key>value</key>"));
        }
        if (this._xaDataSource != null) {
            throw new ConfigException(L.l("<init-param> cannot be used with an XADataSource.  Use the init-param key as a tag, like <key>value</key>"));
        }
    }

    synchronized Object getDriverObject() throws SQLException {
        if (this._driverObject != null) {
            return this._driverObject;
        }
        if (this._driverClass == null) {
            return null;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("loading driver: " + this._driverClass.getName());
        }
        try {
            this._driverObject = this._driverClass.newInstance();
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        return this._driverObject;
    }

    PooledConnection createPooledConnection(String user, String password) throws SQLException {
        PooledConnection conn = null;
        if (this._xaDataSource != null) {
            conn = user == null && password == null ? this._xaDataSource.getXAConnection() : this._xaDataSource.getXAConnection(user, password);
        } else if (this._poolDataSource != null) {
            conn = user == null && password == null ? this._poolDataSource.getPooledConnection() : this._poolDataSource.getPooledConnection(user, password);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection createDriverConnection(String user, String password) throws SQLException {
        if (!this._lifecycle.isActive()) {
            return null;
        }
        if (this._xaDataSource != null || this._poolDataSource != null) {
            throw new IllegalStateException();
        }
        if (this._driver == null) {
            throw new IllegalStateException();
        }
        Driver driver = this._driver;
        String url = this.getURL();
        if (url == null) {
            throw new SQLException(L.l("can't create connection with null url"));
        }
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getInfo());
            if (user != null) {
                properties.put(PROPERTY_USER, user);
            } else {
                properties.put(PROPERTY_USER, "");
            }
            if (password != null) {
                properties.put(PROPERTY_PASSWORD, password);
            } else {
                properties.put(PROPERTY_PASSWORD, "");
            }
            Connection conn = driver != null ? driver.connect(url, properties) : DriverManager.getConnection(url, properties);
            DriverConfig driverConfig = this;
            synchronized (driverConfig) {
                ++this._connectionCountTotal;
            }
            return conn;
        }
        catch (SQLException e) {
            DriverConfig driverConfig = this;
            synchronized (driverConfig) {
                ++this._connectionFailCountTotal;
                this._lastFailTime = Alarm.getCurrentTime();
            }
            throw e;
        }
    }

    @PostConstruct
    public void init() {
        if (this._driverClass == null && this._poolDataSource == null && this._xaDataSource == null) {
            if (this._driverURL == null) {
                throw new ConfigException(L.l("<driver> requires a 'type' or 'url'"));
            }
            String driver = DatabaseManager.findDriverByUrl(this._driverURL);
            if (driver == null) {
                throw new ConfigException(L.l("url='{0}' does not have a known driver.  The driver class must be specified by a 'type' parameter.", (Object)this._driverURL));
            }
            Class<?> driverClass = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                driverClass = Class.forName(driver, false, loader);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            this.setType(driverClass);
        }
    }

    public void initDriver() throws SQLException {
        Object driverObject;
        block17: {
            PropertyValueProgram program;
            block16: {
                if (!this._lifecycle.toInit()) {
                    return;
                }
                driverObject = this.getDriverObject();
                if (driverObject == null) {
                    if (this._xaDataSource != null || this._poolDataSource != null) {
                        return;
                    }
                    throw new SQLExceptionWrapper(L.l("driver '{0}' has not been configured for pool {1}.  <database> needs either a <data-source> or a <type>.", (Object)this._driverClass, (Object)this.getDBPool().getName()));
                }
                try {
                    if (this._driverURL != null) {
                        program = new PropertyValueProgram("url", this._driverURL);
                        program.configure(driverObject);
                    }
                }
                catch (Exception e) {
                    if (driverObject instanceof Driver) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                    throw new SQLExceptionWrapper(e);
                }
                try {
                    if (this._user != null) {
                        program = new PropertyValueProgram(PROPERTY_USER, this._user);
                        program.configure(driverObject);
                    }
                }
                catch (Throwable e) {
                    log.log(Level.FINEST, e.toString(), e);
                    if (driverObject instanceof Driver) break block16;
                    throw new SQLExceptionWrapper(e);
                }
            }
            try {
                if (this._password != null) {
                    program = new PropertyValueProgram(PROPERTY_PASSWORD, this._password);
                    program.configure(driverObject);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
                if (driverObject instanceof Driver) break block17;
                throw new SQLExceptionWrapper(e);
            }
        }
        try {
            if (this._init != null) {
                this._init.configure(driverObject);
                this._init = null;
            }
            Config.init(driverObject);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
    }

    private boolean hasSetter(Class cl, String name) {
        return true;
    }

    public long getConnectionCountTotal() {
        return this._connectionCountTotal;
    }

    public long getConnectionFailCountTotal() {
        return this._connectionFailCountTotal;
    }

    public long getLastFailTime() {
        return this._lastFailTime;
    }

    public String toString() {
        return "JdbcDriver[" + this._driverURL + "]";
    }
}

