/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.UserCallableStatement;
import com.caucho.sql.UserPreparedStatement;
import com.caucho.sql.UserStatement;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.L10N;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConnection
implements Connection {
    protected static final Logger log = Log.open(UserConnection.class);
    protected static final L10N L = new L10N(UserConnection.class);
    private ManagedConnectionImpl _mConn;
    private Statement _statement;
    private ArrayList<Statement> _statements;

    UserConnection(ManagedConnectionImpl mConn) {
        if (mConn == null || mConn.getDriverConnection() == null) {
            throw new NullPointerException();
        }
        this._mConn = mConn;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.getDriverConnection();
        if (conn instanceof SpyConnection) {
            conn = ((SpyConnection)conn).getConnection();
        }
        return conn;
    }

    public Class getDriverClass() {
        return this.getMConn().getDriverClass();
    }

    public String getURL() {
        return this.getMConn().getDBPool().getURL();
    }

    void associate(ManagedConnectionImpl mConn) {
        this._mConn = mConn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt;
        Connection conn = this.getDriverConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql);
        }
        catch (SQLException e) {
            this.getMConn().fatalEvent(e);
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql, resultSetType);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        if (stmt == null) {
            throw new IllegalStateException(L.l("prepareStatement returned empty SQL\n{0}", (Object)sql));
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserPreparedStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        if (this.getDriverConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getDriverConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        if (this._mConn.isWrapStatements()) {
            return new UserCallableStatement(this, stmt);
        }
        return stmt;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.getDriverConnection().getCatalog();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getMConn().setCatalog(catalog);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getDriverConnection().getMetaData();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getDriverConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getMConn().setTypeMap(map);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getDriverConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getDriverConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        this.getMConn().setTransactionIsolation(isolation);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                return conn.getWarnings();
            }
            return null;
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.clearWarnings();
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getMConn().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getDriverConnection().isReadOnly();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getDriverConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getMConn().setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            Connection conn = this.getDriverConnection();
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._mConn == null || this.getDriverConnection() == null || this.getDriverConnection().isClosed();
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ManagedConnectionImpl mConn;
        UserConnection userConnection = this;
        synchronized (userConnection) {
            mConn = this._mConn;
            this._mConn = null;
            if (mConn == null) {
                return;
            }
        }
        try {
            try {
                this.resetConnection(mConn);
            }
            catch (Throwable e) {
                mConn.fatalEvent();
                log.log(Level.WARNING, e.toString(), e);
                Object var5_6 = null;
                mConn.closeEvent(this);
            }
            Object var5_5 = null;
            mConn.closeEvent(this);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            mConn.closeEvent(this);
            throw throwable;
        }
    }

    private void addStatement(Statement stmt) {
        if (this._statement == null) {
            this._statement = stmt;
        } else if (this._statements != null) {
            this._statements.add(stmt);
        } else {
            this._statements = new ArrayList();
            this._statements.add(stmt);
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        this.getDriverConnection().setHoldability(hold);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getDriverConnection().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getDriverConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getDriverConnection().setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getDriverConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getDriverConnection().rollback(savepoint);
    }

    private void resetConnection(ManagedConnectionImpl mConn) {
        this.closeStatements(mConn);
    }

    void closeStatement(Statement stmt) {
        if (this._statement == stmt) {
            this._statement = null;
        } else if (this._statements != null) {
            this._statements.remove(stmt);
        }
    }

    private void closeStatements(ManagedConnectionImpl mConn) {
        ArrayList<Statement> statements = this._statements;
        this._statements = null;
        Statement stmt = this._statement;
        this._statement = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        for (int i = 0; statements != null && i < statements.size(); ++i) {
            try {
                stmt = statements.get(i);
                if (stmt == null) continue;
                stmt.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public Connection getDriverConnection() throws SQLException {
        ManagedConnectionImpl mConn = this.getMConn();
        if (mConn == null) {
            throw new IllegalStateException(L.l("Cannot use closed connection.  Check max-active-time and review application code. "));
        }
        Connection conn = mConn.getDriverConnection();
        return conn;
    }

    public ManagedConnectionImpl getMConn() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn == null) {
            throw new IllegalStateException("connection is closed");
        }
        return mConn;
    }

    public void discardConnection() {
        this.fatalEvent();
    }

    private void fatalEvent() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.fatalEvent();
        }
    }

    private void fatalEvent(SQLException exn) {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.fatalEvent(exn);
        }
    }

    void killPool() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.killPool();
        }
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public String toString() {
        return "UserConnection[" + this._mConn + "]";
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getConnection();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getConnection().getClass());
    }
}

