/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.UserConnection;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStatement
implements Statement {
    protected static final Logger log = Log.open(UserStatement.class);
    protected static final L10N L = new L10N(UserStatement.class);
    protected UserConnection _conn;
    protected Statement _stmt;
    protected boolean _isPoolable = true;

    UserStatement(UserConnection conn, Statement stmt) {
        this._conn = conn;
        this._stmt = stmt;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (!poolable) {
            this._isPoolable = false;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._isPoolable;
    }

    public Statement getStatement() {
        Statement stmt = this._stmt;
        if (stmt instanceof SpyStatement) {
            stmt = ((SpyStatement)stmt).getStatement();
        }
        return stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this._stmt.addBatch(sql);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._stmt.cancel();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._stmt.clearBatch();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            Statement stmt = this._stmt;
            if (stmt != null) {
                stmt.clearWarnings();
            }
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            Statement stmt = this._stmt;
            this._stmt = null;
            if (stmt != null) {
                this._conn.closeStatement(stmt);
                stmt.close();
            }
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this._stmt.executeQuery(sql);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this._stmt.executeUpdate(sql);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, int resultType) throws SQLException {
        try {
            return this._stmt.executeUpdate(query, resultType);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, int[] columns) throws SQLException {
        try {
            return this._stmt.executeUpdate(query, columns);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int executeUpdate(String query, String[] columns) throws SQLException {
        try {
            return this._stmt.executeUpdate(query, columns);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this._stmt.execute(sql);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        try {
            return this._stmt.execute(query, resultType);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean execute(String query, int[] columns) throws SQLException {
        try {
            return this._stmt.execute(query, columns);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean execute(String query, String[] columns) throws SQLException {
        try {
            return this._stmt.execute(query, columns);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this._stmt.executeBatch();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this._stmt.getResultSet();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._stmt.getUpdateCount();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._stmt.getFetchDirection();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setFetchDirection(direction);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._stmt.getFetchSize();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setFetchSize(rows);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setMaxFieldSize(max);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._stmt.getMaxRows();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setMaxRows(max);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this._stmt.getMoreResults();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setQueryTimeout(seconds);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._stmt.getResultSetType();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._stmt.getWarnings();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setCursorName(name);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setEscapeProcessing(enable);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int count) throws SQLException {
        try {
            return this._stmt.getMoreResults(count);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this._stmt.getGeneratedKeys();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmt == null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this._stmt;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this._stmt.getClass());
    }

    protected void killPool() {
        if (this._conn != null) {
            this._conn.killPool();
        }
    }

    public String toString() {
        return "UserStatement[" + this._stmt + "]";
    }
}

