/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyDataSource;
import com.caucho.sql.spy.SpyPreparedStatement;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.L10N;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyConnection
implements Connection {
    protected static final Logger log = Logger.getLogger(SpyConnection.class.getName());
    protected static final Logger logXA = Logger.getLogger(SpyConnection.class.getName() + ".XA");
    protected static final L10N L = new L10N(SpyConnection.class);
    private SpyDataSource _spyDataSource;
    private String _id;
    private int _stmtIdCount;
    private Connection _conn;

    public SpyConnection(Connection conn, SpyDataSource spyDataSource) {
        this._spyDataSource = spyDataSource;
        this._conn = conn;
    }

    public SpyConnection(Connection conn, SpyDataSource spyDataSource, String id) {
        this._spyDataSource = spyDataSource;
        this._conn = conn;
        this._id = id;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getId() {
        if (this._id == null) {
            this._id = this._spyDataSource.createConnectionId();
        }
        return this._id;
    }

    public String createStatementId() {
        return this.getId() + "." + this._stmtIdCount++;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            String catalog = this._conn.getCatalog();
            log.fine(this.getId() + ":getCatalog() -> " + catalog);
            return catalog;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getCatalog(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            log.fine(this.getId() + ":setCatalog(" + catalog + ")");
            this._conn.setCatalog(catalog);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setCatalog(" + e + ")");
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData metaData = this._conn.getMetaData();
            String ident = metaData.getClass().getName();
            log.fine(this.getId() + ":getMetaData() -> " + ident);
            return metaData;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getMetaData(" + e + ")");
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            Map<String, Class<?>> map = this._conn.getTypeMap();
            log.fine(this.getId() + ":getTypeMap() -> " + map);
            return map;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getTypeMap(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            log.fine(this.getId() + ":setTypeMap(" + map + ")");
            this._conn.setTypeMap(map);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setTypeMap(" + e + ")");
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            String nativeSQL = this._conn.nativeSQL(sql);
            log.fine(this.getId() + ":nativeSQL() -> " + nativeSQL);
            return nativeSQL;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-nativeSQL(" + e + ")");
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int isolation = this._conn.getTransactionIsolation();
            log.fine(this.getId() + ":getTransactionIsolation() -> " + isolation);
            return isolation;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getTransactionIsolation(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            log.fine(this.getId() + ":setTransactionIsolation(" + isolation + ")");
            this._conn.setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setTransactionIsolation(" + e + ")");
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning warning = this._conn.getWarnings();
            log.fine(this.getId() + ":getWarnings() -> " + warning);
            return warning;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getWarnings(" + e + ")");
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            log.fine(this.getId() + ":clearWarnings()");
            this._conn.clearWarnings();
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-clearWarnings(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            log.fine(this.getId() + ":setReadOnly(" + readOnly + ")");
            this._conn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setReadOnly(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            boolean isReadOnly = this._conn.isReadOnly();
            log.fine(this.getId() + "isReadOnly() -> " + isReadOnly);
            return isReadOnly;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isReadOnly(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement()");
            }
            Statement stmt = this._conn.createStatement();
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement(type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement(type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ",holdability=" + resultSetHoldability + ")");
            }
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ",type=" + resultSetType + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":prepareCall(" + sql + ")");
            }
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareCall(" + e + ")");
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":prepareCall(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareCall(" + e + ")");
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            boolean autoCommit = this._conn.getAutoCommit();
            log.fine(this.getId() + ":getAutoCommit() -> " + autoCommit);
            return autoCommit;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getAutoCommit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            logXA.fine(this.getId() + ":setAutoCommit(" + autoCommit + ")");
            this._conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            logXA.fine(this.getId() + ":exn-setAutoCommit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            logXA.fine(this.getId() + ":commit()");
            this._conn.commit();
        }
        catch (SQLException e) {
            logXA.fine(this.getId() + ":exn-commit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            logXA.fine(this.getId() + ":rollback()");
            this._conn.rollback();
        }
        catch (SQLException e) {
            logXA.fine(this.getId() + ":exn-rollback(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            boolean isClosed = this._conn.isClosed();
            log.fine(this.getId() + ":isClosed() -> " + isClosed);
            return isClosed;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isClosed(" + e + ")");
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        log.fine(this.getId() + ":close()");
        try {
            this._conn.close();
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-close(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        this._conn.setHoldability(hold);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this._conn.setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    public String toString() {
        return "SpyConnection[id=" + this.getId() + ",conn=" + this._conn + "]";
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

