/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyPooledConnection;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class SpyConnectionPoolDataSource
implements ConnectionPoolDataSource {
    protected static final Logger log = Log.open(SpyConnectionPoolDataSource.class);
    protected static final L10N L = new L10N(SpyConnectionPoolDataSource.class);
    private static int _staticId;
    private int _id;
    private int _connCount;
    private ConnectionPoolDataSource _dataSource;

    public SpyConnectionPoolDataSource(ConnectionPoolDataSource dataSource) {
        this._dataSource = dataSource;
        this._id = _staticId++;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        try {
            PooledConnection conn = this._dataSource.getPooledConnection();
            String connId = this._id + "." + this._connCount++;
            log.fine(this._id + ":getConnectionPool() -> " + connId + ":" + conn);
            return new SpyPooledConnection(conn, connId);
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        try {
            PooledConnection conn = this._dataSource.getPooledConnection(user, password);
            String connId = this._id + "." + this._connCount++;
            log.fine(this._id + ":getPooledConnection(" + user + ") -> " + connId + ":" + conn);
            return new SpyPooledConnection(conn, connId);
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this._dataSource.setLoginTimeout(timeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    public String toString() {
        return "SpyConnectionPoolDataSource[id=" + this._id + ",data-source=" + this._dataSource + "]";
    }
}

