/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyConnection;
import com.caucho.sql.spy.SpyDataSource;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class SpyDriver
implements Driver {
    protected static final Logger log = Logger.getLogger(SpyDriver.class.getName());
    protected static final L10N L = new L10N(SpyDriver.class);
    private static int _staticId;
    private SpyDataSource _spyDataSource = new SpyDataSource();
    private int _id;
    private int _connCount;
    private Driver _driver;

    public SpyDriver(Driver driver) {
        this._driver = driver;
        this._id = _staticId++;
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            boolean result = this._driver.acceptsURL(url);
            log.fine(this._id + ":acceptsURL(" + url + ") -> " + result);
            return result;
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-acceptURL(" + e + ")");
            throw e;
        }
    }

    public Connection connect(String url, Properties fine) throws SQLException {
        try {
            Connection conn = this._driver.connect(url, fine);
            int connId = this._connCount++;
            log.fine(this._id + ":connect(" + url + ",fine=" + fine + ") -> " + connId + ":" + conn);
            return new SpyConnection(conn, this._spyDataSource);
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public int getMajorVersion() {
        int result = this._driver.getMajorVersion();
        log.fine(this._id + ":getMajorVersion() -> " + result);
        return result;
    }

    public int getMinorVersion() {
        int result = this._driver.getMinorVersion();
        log.fine(this._id + ":getMinorVersion() -> " + result);
        return result;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties fine) throws SQLException {
        try {
            DriverPropertyInfo[] result = this._driver.getPropertyInfo(url, fine);
            Hashtable<String, String> cleanFine = new Hashtable<String, String>();
            if (fine != null) {
                for (Map.Entry<Object, Object> entry : fine.entrySet()) {
                    cleanFine.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (cleanFine.get("password") != null) {
                cleanFine.put("password", "****");
            }
            log.fine(this._id + ":getPropertyInfo(" + url + ") -> " + result);
            return result;
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-getPropertyInfo(" + e + ")");
            throw e;
        }
    }

    public boolean jdbcCompliant() {
        boolean result = this._driver.jdbcCompliant();
        log.fine(this._id + ":jdbcCompliant() -> " + result);
        return result;
    }

    public String toString() {
        return "SpyDriver[id=" + this._id + ",driver=" + this._driver + "]";
    }
}

