/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyStatement
implements Statement {
    protected static final Logger log = Log.open(SpyStatement.class);
    protected static final L10N L = new L10N(SpyConnection.class);
    protected String _id;
    protected SpyConnection _conn;
    protected Statement _stmt;

    SpyStatement(String id, SpyConnection conn, Statement stmt) {
        this._id = id;
        this._conn = conn;
        this._stmt = stmt;
    }

    public String getId() {
        if (this._id == null) {
            this._id = this._conn.createStatementId();
        }
        return this._id;
    }

    public Statement getStatement() {
        return this._stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":addBatch(" + sql + ")");
            }
            this._stmt.addBatch(sql);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-addBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":cancel()");
            }
            this._stmt.cancel();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-cancel(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":clearBatch()");
            }
            this._stmt.clearBatch();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-clearBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":clearWarnings()");
            }
            this._stmt.clearWarnings();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-clearWarnings(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":close()");
            }
            this._stmt.close();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-close(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":executeQuery(" + sql + ")");
            }
            ResultSet rs = this._stmt.executeQuery(sql);
            return rs;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-executeQuery(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int count = this._stmt.executeUpdate(sql);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":executeUpdate(" + sql + ") -> " + count);
            }
            return count;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-executeUpdate(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            boolean hasResult = this._stmt.execute(sql);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":execute(" + sql + ") -> " + hasResult);
            }
            return hasResult;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-execute(" + sql + ") -> " + e);
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] result = this._stmt.executeBatch();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":executeBatch()");
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-executeBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            ResultSet result = this._stmt.getResultSet();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getResultSet() -> " + (result != null ? result.getClass().getName() : ""));
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getResultSet(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            int updateCount = this._stmt.getUpdateCount();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getUpdateCount() -> " + updateCount);
            }
            return updateCount;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getUpdateCount(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        int updateCount = this._stmt.getUpdateCount();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getId() + ":getConnection()");
        }
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            int result = this._stmt.getFetchDirection();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getFetchDirection() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getFetchDirection(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            int result = this._stmt.getFetchSize();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getFetchSize() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getFetchSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            int result = this._stmt.getMaxFieldSize();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getMaxFieldSize() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getMaxFieldSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            int result = this._stmt.getMaxRows();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getMaxRows() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getMaxRows(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setMaxRows(" + max + ")");
            }
            this._stmt.setMaxRows(max);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setMaxRows(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            boolean result = this._stmt.getMoreResults();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getMoreResults() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getMoreResults(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            int result = this._stmt.getQueryTimeout();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getQueryTimeout() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getQueryTimeout(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            int result = this._stmt.getResultSetConcurrency();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getResultSetConcurrency() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getResultSetConcurrency(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            int result = this._stmt.getResultSetType();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getResultSetType() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getResultSetType(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning result = this._stmt.getWarnings();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getWarnings() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getWarnings(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setCursorName(" + name + ")");
            }
            this._stmt.setCursorName(name);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setCursorName(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setEscapeProcessing(" + enable + ")");
            }
            this._stmt.setEscapeProcessing(enable);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setEscapeProcessing(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setFetchDirection(" + direction + ")");
            }
            this._stmt.setFetchDirection(direction);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setFetchDirection(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setFetchSize(" + rows + ")");
            }
            this._stmt.setFetchSize(rows);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setFetchSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setMaxFieldSize(" + max + ")");
            }
            this._stmt.setMaxFieldSize(max);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setMaxFieldSize(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setQueryTimeout(" + seconds + ")");
            }
            this._stmt.setQueryTimeout(seconds);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setQueryTimeout(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    @Override
    public boolean getMoreResults(int count) throws SQLException {
        return this._stmt.getMoreResults(count);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String query, int resultType) throws SQLException {
        return this._stmt.executeUpdate(query, resultType);
    }

    @Override
    public int executeUpdate(String query, int[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    @Override
    public int executeUpdate(String query, String[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        return this._stmt.execute(query, resultType);
    }

    @Override
    public boolean execute(String query, int[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    @Override
    public boolean execute(String query, String[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

