/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SpyXAResource
implements XAResource {
    protected static final Logger log = Log.open(SpyXAResource.class);
    protected static final L10N L = new L10N(SpyXAResource.class);
    private XAResource _xaResource;
    private String _id;

    public SpyXAResource(String id, XAResource resource) {
        this._xaResource = resource;
        this._id = id;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            boolean ok = this._xaResource.setTransactionTimeout(seconds);
            log.fine(this._id + ":set-transaction-timeout(" + seconds + ")->" + ok);
            return ok;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            int seconds = this._xaResource.getTransactionTimeout();
            log.fine(this._id + ":transaction-timeout()->" + seconds);
            return seconds;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        try {
            if (resource instanceof SpyXAResource) {
                resource = ((SpyXAResource)resource).getXAResource();
            }
            boolean same = this._xaResource.isSameRM(resource);
            log.fine(this._id + ":is-same-rm(resource=" + resource + ")->" + same);
            return same;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            String flagName = "";
            if ((flags & 0x200000) != 0) {
                flagName = flagName + ",join";
            }
            if ((flags & 0x8000000) != 0) {
                flagName = flagName + ",resume";
            }
            log.fine(this._id + ":start(xid=" + xid + flagName + ")");
            this._xaResource.start(xid, flags);
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            String flagName = "";
            if ((flags & 0x20000000) != 0) {
                flagName = flagName + ",fail";
            }
            if ((flags & 0x2000000) != 0) {
                flagName = flagName + ",suspend";
            }
            log.fine(this._id + ":end(xid=" + xid + flagName + ")");
            this._xaResource.end(xid, flags);
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            int value = this._xaResource.prepare(xid);
            log.fine(this._id + ":prepare(xid=" + xid + ")->" + value);
            return value;
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            log.fine(this._id + ":commit(xid=" + xid + (onePhase ? ",1P)" : ",2P)"));
            this._xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            log.fine(this._id + ":rollback(xid=" + xid + ")");
            this._xaResource.rollback(xid);
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public Xid[] recover(int flags) throws XAException {
        try {
            String flagString = "";
            if ((flags & 0x1000000) != 0) {
                flagString = flagString + "start";
            }
            if ((flags & 0x800000) != 0) {
                if (!flagString.equals("")) {
                    flagString = flagString + ",";
                }
                flagString = flagString + "end";
            }
            log.fine(this._id + ":recover(flags=" + flagString + ")");
            return this._xaResource.recover(flags);
        }
        catch (XAException e) {
            log.fine(e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            log.fine(this._id + ":forget(xid=" + xid + ")");
            this._xaResource.forget(xid);
        }
        catch (XAException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.FINE, e.toString(), e);
            throw e;
        }
    }

    public String toString() {
        return "SpyXAResource[id=" + this._id + ",resource=" + this._xaResource + "]";
    }
}

