/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerManager;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProfilerFilter
implements Filter {
    private static final L10N L = new L10N(ProfilerFilter.class);
    private static final Logger log = Logger.getLogger(ProfilerFilter.class.getName());
    private final ProfilerManager _profilerManager = ProfilerManager.getLocal();
    private boolean _isUseQuery = false;

    public void setUseQuery(boolean useQuery) {
        this._isUseQuery = useQuery;
    }

    public boolean isUseQuery() {
        return this._isUseQuery;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        String name;
        String queryString;
        String pathInfo;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
            queryString = this.isUseQuery() ? request.getQueryString() : null;
        } else {
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            queryString = this.isUseQuery() ? (String)request.getAttribute("javax.servlet.include.query_string") : null;
        }
        if (pathInfo == null && queryString == null) {
            name = servletPath;
        } else {
            CharBuffer nameBuilder = new CharBuffer();
            nameBuilder.append(servletPath);
            if (pathInfo != null) {
                nameBuilder.append(pathInfo);
            }
            if (queryString != null) {
                nameBuilder.append('?');
                nameBuilder.append(queryString);
            }
            name = nameBuilder.toString();
        }
        ProfilerPoint profilerPoint = this._profilerManager.getProfilerPoint(name);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(profilerPoint.toString());
        }
        Profiler profiler = profilerPoint.start();
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var14_13 = null;
            profiler.finish();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            profiler.finish();
            throw throwable;
        }
    }

    public void destroy() {
    }
}

