/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerManager;
import com.caucho.tools.profiler.ThreadProfiler;
import com.caucho.util.LruCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerPoint
implements Comparable<ProfilerPoint> {
    private static final Profiler NOOP_PROFILER = new Profiler(){

        public void finish() {
        }

        public String toString() {
            return "NoopProfiler[]";
        }
    };
    private final ProfilerManager _profilerManager;
    private final String _name;
    private LruCache<String, ProfilerPoint> _children;
    private long _time;
    private long _invocationCount;
    private long _minTime = Long.MAX_VALUE;
    private long _maxTime = Long.MIN_VALUE;

    ProfilerPoint(ProfilerManager profilerManager, String name) {
        assert (profilerManager != null);
        assert (name != null);
        this._profilerManager = profilerManager;
        this._name = name;
    }

    protected ProfilerManager getProfilerManager() {
        return this._profilerManager;
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilerPoint addProfilerPoint(String name) {
        ProfilerPoint profilerPoint = this;
        synchronized (profilerPoint) {
            ProfilerPoint child;
            if (this._children == null) {
                this._children = new LruCache(1024);
            }
            if ((child = (ProfilerPoint)this._children.get((Object)name)) == null) {
                child = this.create(name);
                this._children.put((Object)name, (Object)child);
            }
            return child;
        }
    }

    protected ProfilerPoint create(String name) {
        return new ProfilerPoint(this.getProfilerManager(), name);
    }

    public Profiler start() {
        if (!this._profilerManager.isEnabled()) {
            return NOOP_PROFILER;
        }
        ThreadProfiler profiler = ThreadProfiler.current();
        profiler.start(this);
        return profiler;
    }

    protected Profiler start(ProfilerPoint parent) {
        if (!this.getProfilerManager().isEnabled()) {
            return NOOP_PROFILER;
        }
        ThreadProfiler profiler = ThreadProfiler.current();
        profiler.start(parent, this);
        return profiler;
    }

    List<ProfilerPoint> getChildren() {
        if (this._children == null) {
            return Collections.emptyList();
        }
        ArrayList<ProfilerPoint> children = new ArrayList<ProfilerPoint>();
        Iterator iter = this._children.values();
        while (iter.hasNext()) {
            children.add((ProfilerPoint)iter.next());
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long totalTime) {
        ProfilerPoint profilerPoint = this;
        synchronized (profilerPoint) {
            ++this._invocationCount;
            if (this._invocationCount > 0L) {
                this._time += totalTime;
            }
            if (totalTime < this._minTime) {
                this._minTime = totalTime;
            }
            if (this._maxTime < totalTime) {
                this._maxTime = totalTime;
            }
        }
    }

    public long getTime() {
        return this._time;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementInvocationCount() {
        ProfilerPoint profilerPoint = this;
        synchronized (profilerPoint) {
            ++this._invocationCount;
        }
    }

    public long getInvocationCount() {
        return this._invocationCount;
    }

    void reset() {
        this._children = null;
        this._time = 0L;
        this._invocationCount = 0L;
        this._minTime = Long.MAX_VALUE;
        this._maxTime = Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfilerPoint)) {
            return false;
        }
        ProfilerPoint point = (ProfilerPoint)o;
        return this.getName().equals(point.getName());
    }

    @Override
    public int compareTo(ProfilerPoint point) {
        return this.getName().compareTo(point.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "ProfilerPoint[" + this.getName() + "]";
    }
}

