/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.CountComparator;
import com.caucho.tools.profiler.ProfilerManager;
import com.caucho.tools.profiler.ProfilerNodeComparator;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.TimeComparator;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Sprintf;
import com.caucho.vfs.XmlWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProfilerServlet
extends HttpServlet {
    private static final L10N L = new L10N(ProfilerServlet.class);
    private final ProfilerManager _profilerManager = ProfilerManager.getLocal();

    public ProfilerManager createProfiler() {
        return this._profilerManager;
    }

    public void init() {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
        this.handleResponse(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
        this.handleResponse(req, res);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void handleResponse(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter("format");
        boolean isXml = "xml".equals(format);
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-cache, post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        if (isXml) {
            this.writeXml(request, response);
        } else {
            this.writeHtml(request, response);
        }
    }

    protected void writeHtml(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String sort = request.getParameter("sort");
        ProfilerNodeComparator comparator = "count".equals(sort) ? new CountComparator() : new TimeComparator();
        comparator.setDescending(true);
        XmlWriter out = new XmlWriter((Writer)response.getWriter());
        out.setStrategy(XmlWriter.HTML);
        out.setIndenting(false);
        out.println("<!DOCTYPE html  PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        String title = L.l("Profiling Results for {0}", (Object)contextPath);
        out.startElement("html");
        out.startElement("head");
        out.writeElement("title", (Object)title);
        out.startElement("style");
        out.writeAttribute("type", (Object)"text/css");
        out.println("h1 { background: #ccddff; margin : 0 -0.5em 0.25em -0.25em; padding: 0.25em 0.25em; }");
        out.println("h2 { background: #ccddff; padding: 0.25em 0.5em; margin : 0.5em -0.5em; }");
        out.println("table { border-collapse : collapse; }");
        out.println("th { background : #c78ae6; border-left : 1px; border-right : 1px}");
        out.println("tr { border-bottom : 1px dotted; }");
        out.println(".number { text-align : right; }");
        out.println("table table tr { border-bottom : none; }");
        out.endElement("style");
        out.endElement("head");
        out.startElement("body");
        out.writeElement("h1", (Object)title);
        out.startElement("table");
        out.writeAttribute("border", (Object)0);
        out.startElement("tr");
        out.writeLineElement("th", (Object)L.l("Name"));
        out.writeLineElement("th", (Object)L.l("Average Time"));
        out.writeLineElement("th", (Object)L.l("Min Time"));
        out.writeLineElement("th", (Object)L.l("Max Time"));
        out.writeLineElement("th", (Object)L.l("Total Time"));
        out.writeLineElement("th", (Object)L.l("Invocation Count"));
        out.endElement("tr");
        ProfilerPoint root = this._profilerManager.getRoot();
        List<ProfilerPoint> children = root.getChildren();
        Collections.sort(children, comparator);
        for (ProfilerPoint child : children) {
            this.display(child, comparator, out, 0);
        }
        out.endElement("table");
        out.endElement("body");
        out.endElement("html");
    }

    private void display(ProfilerPoint node, ProfilerNodeComparator comparator, XmlWriter out, int depth) {
        long averageChildrenTime;
        long averageTotalTime;
        long averageThisTime;
        if (node == null) {
            return;
        }
        List<ProfilerPoint> children = node.getChildren();
        Collections.sort(children, comparator);
        long thisTime = node.getTime();
        long minTime = node.getMinTime();
        long maxTime = node.getMaxTime();
        long childrenTime = 0L;
        for (ProfilerPoint child : children) {
            childrenTime += child.getTime();
        }
        long totalTime = childrenTime + thisTime;
        long invocationCount = node.getInvocationCount();
        if (invocationCount <= 0L) {
            averageThisTime = -1L;
            averageTotalTime = -1L;
            averageChildrenTime = -1L;
        } else {
            averageThisTime = thisTime / invocationCount;
            averageTotalTime = totalTime / invocationCount;
            averageChildrenTime = childrenTime / invocationCount;
        }
        out.startElement("tr");
        out.writeAttribute("class", (Object)("level" + depth));
        out.startLineElement("td");
        out.startElement("table");
        out.startElement("tr");
        out.startLineElement("td");
        if (depth > 0) {
            for (int i = depth; i > 0; --i) {
                out.write("&nbsp;");
                out.write("&nbsp;");
            }
            out.write("&rarr;");
        }
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"text");
        out.writeText((Object)node.getName());
        out.endLineElement("td");
        out.endElement("tr");
        out.endElement("table");
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"number");
        if (averageThisTime < 0L) {
            out.write("&nbsp;");
        } else {
            String averageTimeString = this.createTimeString(averageTotalTime, averageThisTime, averageChildrenTime);
            out.writeAttribute("title", (Object)averageTimeString);
            this.printTime(out, averageTotalTime);
        }
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"number");
        if (minTime < Long.MAX_VALUE) {
            this.printTime(out, minTime);
        } else {
            out.print("&nbsp;");
        }
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"number");
        if (Long.MIN_VALUE < maxTime) {
            this.printTime(out, maxTime);
        } else {
            out.print("&nbsp;");
        }
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"number");
        String timeString = this.createTimeString(totalTime, thisTime, childrenTime);
        out.writeAttribute("title", (Object)timeString);
        this.printTime(out, totalTime);
        out.endLineElement("td");
        out.startLineElement("td");
        out.writeAttribute("class", (Object)"number");
        out.print(invocationCount);
        out.endLineElement("td");
        out.endElement("tr");
        for (ProfilerPoint child : children) {
            this.display(child, comparator, out, depth + 1);
        }
    }

    protected void writeXml(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TimeComparator comparator = new TimeComparator();
        comparator.setDescending(true);
        XmlWriter out = new XmlWriter((Writer)response.getWriter());
        out.setStrategy(XmlWriter.XML);
        out.setIndenting(false);
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        out.startElement("profile");
        out.writeLineElement("name", (Object)contextPath);
        List<ProfilerPoint> children = this._profilerManager.getRoot().getChildren();
        Collections.sort(children, comparator);
        for (ProfilerPoint child : children) {
            this.displayXml(child, comparator, out);
        }
        out.endElement("profile");
    }

    private void displayXml(ProfilerPoint node, ProfilerNodeComparator comparator, XmlWriter out) {
        List<ProfilerPoint> children = node.getChildren();
        Collections.sort(children, comparator);
        long thisTime = node.getTime();
        long minTime = node.getMinTime();
        long maxTime = node.getMaxTime();
        long childrenTime = 0L;
        for (ProfilerPoint child : children) {
            childrenTime += child.getTime();
        }
        long totalTime = childrenTime + thisTime;
        long invocationCount = node.getInvocationCount();
        out.startBlockElement("node");
        out.writeLineElement("name", (Object)node.getName());
        if (minTime < Long.MAX_VALUE) {
            out.writeLineElement("min-time", (Object)String.valueOf(minTime));
        } else {
            out.writeLineElement("min-time", (Object)"0");
        }
        if (maxTime >= 0L) {
            out.writeLineElement("max-time", (Object)String.valueOf(maxTime));
        } else {
            out.writeLineElement("max-time", (Object)"0");
        }
        out.writeLineElement("time", (Object)String.valueOf(thisTime));
        out.writeLineElement("total-time", (Object)String.valueOf(totalTime));
        out.writeLineElement("children-time", (Object)String.valueOf(childrenTime));
        out.writeLineElement("count", (Object)String.valueOf(invocationCount));
        for (ProfilerPoint child : children) {
            this.displayXml(child, comparator, out);
        }
        out.endBlockElement("node");
    }

    private String createTimeString(long totalTime, long thisTime, long childrenTime) {
        CharBuffer cb = new CharBuffer();
        cb.append("totalTime=");
        this.formatTime(cb, totalTime);
        cb.append(" thisTime=");
        this.formatTime(cb, thisTime);
        cb.append(" childrenTime=");
        this.formatTime(cb, childrenTime);
        return cb.toString();
    }

    private void printTime(XmlWriter out, long time) {
        CharBuffer cb = new CharBuffer();
        this.formatTime(cb, time);
        out.writeText((Object)cb.toString());
    }

    private void formatTime(CharBuffer cb, long nanoseconds) {
        long milliseconds = nanoseconds / 1000000L;
        long minutes = milliseconds / 1000L / 60L;
        if (minutes > 0L) {
            Sprintf.sprintf((CharBuffer)cb, (String)"%d:", (Object[])new Object[]{minutes});
            milliseconds -= minutes * 60L * 1000L;
        }
        long seconds = milliseconds / 1000L;
        if (minutes > 0L) {
            Sprintf.sprintf((CharBuffer)cb, (String)"%02d.", (Object[])new Object[]{seconds});
        } else {
            Sprintf.sprintf((CharBuffer)cb, (String)"%d.", (Object[])new Object[]{seconds});
        }
        Sprintf.sprintf((CharBuffer)cb, (String)"%03d", (Object[])new Object[]{milliseconds -= seconds * 1000L});
    }
}

