/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.jca.UserTransactionImpl;
import com.caucho.jca.UserTransactionSuspendState;
import com.caucho.log.Log;
import com.caucho.transaction.RollbackExceptionWrapper;
import com.caucho.transaction.SystemExceptionWrapper;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.XidImpl;
import com.caucho.transaction.xalog.AbstractXALogStream;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImpl
implements Transaction,
AlarmListener {
    private static final Logger log = Log.open(TransactionImpl.class);
    private static final L10N L = new L10N(TransactionImpl.class);
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static final long EXTRA_TIMEOUT = 60000L;
    private static final long MAX_TIMEOUT = 86400000L;
    private static final int RES_ACTIVE = 1;
    private static final int RES_SHARED_RM = 2;
    private static final int RES_SUSPENDED = 4;
    private static final int RES_COMMIT = 8;
    private TransactionManagerImpl _manager;
    private int _status;
    private XidImpl _xid;
    private boolean _isSuspended;
    private boolean _isDead;
    private int _resourceCount;
    private XAResource[] _resources;
    private XidImpl[] _resourceXid;
    private int[] _resourceState;
    private UserTransactionImpl _userTransaction;
    private UserTransactionSuspendState _suspendState;
    private HashMap<String, Object> _props;
    private ArrayList<Synchronization> _syncList;
    private Throwable _rollbackException;
    private AbstractXALogStream _xaLog;
    private long _timeout = 0L;
    private Alarm _alarm;

    TransactionImpl(TransactionManagerImpl manager) {
        this._manager = manager;
        this._timeout = this._manager.getTimeout();
        this._status = 6;
        this._alarm = new Alarm("xa-timeout", (AlarmListener)this, ClassLoader.getSystemClassLoader());
    }

    public void setUserTransaction(UserTransactionImpl ut) {
        this._userTransaction = ut;
    }

    boolean hasResources() {
        return this._resourceCount > 0;
    }

    boolean isSuspended() {
        return this._isSuspended;
    }

    boolean isDead() {
        return this._isDead;
    }

    public boolean isEmpty() {
        if (this._isDead) {
            return true;
        }
        if (this._resourceCount > 0) {
            return false;
        }
        return this._syncList == null || this._syncList.size() <= 1;
    }

    void begin() throws SystemException, NotSupportedException {
        if (this._status != 6) {
            int status = this._status;
            try {
                this.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            throw new NotSupportedException(L.l("Nested transactions are not supported. The previous transaction for this thread did not commit() or rollback(). Check that every UserTransaction.begin() has its commit() or rollback() in a finally block.\nStatus was {0}.", (Object)TransactionImpl.xaState(status)));
        }
        if (this._isDead) {
            throw new IllegalStateException(L.l("Error trying to use dead transaction."));
        }
        this._status = 0;
        this._rollbackException = null;
        if (this._xid == null) {
            this._xid = this._manager.createXID();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " begin");
        }
        if (this._timeout > 0L) {
            this._alarm.queue(this._timeout + 60000L);
        }
    }

    public boolean enlistResource(XAResource resource) throws RollbackException, SystemException {
        if (resource == null) {
            throw new IllegalArgumentException(L.l("Resource must not be null in enlistResource"));
        }
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("can't enlist with suspended transaction"));
        }
        if (this._status != 0) {
            if (this._status == 1) {
                if (this._rollbackException != null) {
                    throw RollbackExceptionWrapper.create(this._rollbackException);
                }
                throw new RollbackException(L.l("can't enlist with rollback-only transaction"));
            }
            if (this._status == 6) {
                throw new IllegalStateException(L.l("can't enlist with inactive transaction"));
            }
            throw new IllegalStateException(L.l("can't enlist with transaction in '{0}' state", (Object)TransactionImpl.xaState(this._status)));
        }
        if (this._resources == null) {
            this._resources = new XAResource[16];
            this._resourceState = new int[16];
            this._resourceXid = new XidImpl[16];
        } else if (this._resources.length <= this._resourceCount) {
            int oldLength = this._resources.length;
            int newLength = 2 * oldLength;
            XAResource[] resources = new XAResource[newLength];
            int[] resourceState = new int[newLength];
            XidImpl[] resourceXid = new XidImpl[newLength];
            System.arraycopy(this._resources, 0, resources, 0, oldLength);
            System.arraycopy(this._resourceState, 0, resourceState, 0, oldLength);
            System.arraycopy(this._resourceXid, 0, resourceXid, 0, oldLength);
            this._resources = resources;
            this._resourceState = resourceState;
            this._resourceXid = resourceXid;
        }
        int flags = 0;
        XidImpl xid = this._xid;
        boolean hasNewResource = true;
        for (int i = 0; i < this._resourceCount; ++i) {
            if (this._resources[i] == resource && (this._resourceState[i] & 1) != 0) {
                IllegalStateException exn = new IllegalStateException(L.l("Can't enlist same resource twice.  Delist is required before calling enlist with an old resource."));
                this.setRollbackOnly(exn);
                throw exn;
            }
            try {
                if (!this._resources[i].isSameRM(resource)) continue;
                flags = 0x200000;
                xid = this._resourceXid[i];
                if ((this._resourceState[i] & 1) != 0) break;
                this._resources[i] = resource;
                int n = i;
                this._resourceState[n] = this._resourceState[n] | 1;
                hasNewResource = false;
                break;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._resourceCount > 0 && flags != 0x200000) {
            xid = new XidImpl(this._xid, this._resourceCount + 1);
        }
        try {
            if (this._timeout > 0L) {
                resource.setTransactionTimeout((int)(this._timeout / 1000L));
            }
            if (log.isLoggable(Level.FINER)) {
                if (flags == 0x200000) {
                    log.finer(this + " join-XA " + resource);
                } else {
                    log.finer(this + " start-XA " + resource);
                }
            }
            resource.start(xid, flags);
        }
        catch (XAException e) {
            this.setRollbackOnly(e);
            throw new SystemException((Throwable)e);
        }
        if (hasNewResource) {
            this._resources[this._resourceCount] = resource;
            this._resourceState[this._resourceCount] = 1;
            if (flags == 0x200000) {
                int n = this._resourceCount;
                this._resourceState[n] = this._resourceState[n] | 2;
            }
            this._resourceXid[this._resourceCount] = xid;
            ++this._resourceCount;
        }
        return true;
    }

    public boolean allowLocalTransactionOptimization() {
        return this._resourceCount == 0;
    }

    public int getEnlistedResourceCount() {
        return this._resourceCount;
    }

    public boolean delistResource(XAResource resource, int flag) throws SystemException {
        int index;
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("transaction is suspended"));
        }
        if (this._resourceCount == 0) {
            return true;
        }
        for (index = this._resourceCount - 1; index >= 0 && !this._resources[index].equals(resource); --index) {
        }
        if (index < 0) {
            return false;
        }
        if (this._status == 6) {
            while (index + 1 < this._resourceCount) {
                this._resources[index] = this._resources[index + 1];
                this._resourceState[index] = this._resourceState[index + 1];
                this._resourceXid[index] = this._resourceXid[index + 1];
                ++index;
            }
            --this._resourceCount;
            return true;
        }
        if (this._status == 1) {
            flag = 0x20000000;
        }
        int n = index;
        this._resourceState[n] = this._resourceState[n] & 0xFFFFFFFE;
        try {
            resource.end(this._resourceXid[index], flag);
        }
        catch (XAException e) {
            this.setRollbackOnly(e);
            throw new SystemException((Throwable)e);
        }
        return true;
    }

    public void setAttribute(String var, Object value) {
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(var, value);
    }

    public Object getAttribute(String var) {
        if (this._props != null) {
            return this._props.get(var);
        }
        return null;
    }

    public Xid getXid() {
        return this._xid;
    }

    public int getStatus() {
        return this._status;
    }

    void suspend() throws SystemException {
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("can't suspend already-suspended transaction"));
        }
        this._isSuspended = true;
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            if ((this._resourceState[i] & 5) != 1) continue;
            try {
                XAResource resource = this._resources[i];
                resource.end(this._resourceXid[i], 0x2000000);
                continue;
            }
            catch (Exception e) {
                this.setRollbackOnly(e);
            }
        }
        if (this._userTransaction != null) {
            this._suspendState = this._userTransaction.userSuspend();
        }
        if (log.isLoggable(Level.FINER)) {
            log.fine(this + " suspended");
        }
    }

    void resume() throws SystemException {
        if (!this._isSuspended) {
            throw new IllegalStateException(L.l("can't resume non-suspended transaction"));
        }
        this._alarm.queue(this._timeout + 60000L);
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            if ((this._resourceState[i] & 5) != 1) continue;
            try {
                XAResource resource = this._resources[i];
                resource.start(this._resourceXid[i], 0x8000000);
                continue;
            }
            catch (Exception e) {
                this.setRollbackOnly(e);
            }
        }
        if (this._userTransaction != null) {
            this._userTransaction.userResume(this._suspendState);
        }
        this._isSuspended = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " resume");
        }
    }

    public void registerSynchronization(Synchronization sync) {
        if (this._syncList == null) {
            this._syncList = new ArrayList();
        }
        this._syncList.add(sync);
    }

    public void setRollbackOnly() throws SystemException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(L.l("can't set rollback-only"));
        }
        this._status = 1;
        this._timeout = 0L;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback-only");
        }
    }

    public void setRollbackOnly(Throwable exn) {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(L.l("can't set rollback-only"));
        }
        this._status = 1;
        if (this._rollbackException == null) {
            this._rollbackException = exn;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback-only: " + exn.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this._alarm.dequeue();
        Exception heuristicExn = null;
        try {
            if (this._status != 0) {
                switch (this._status) {
                    case 1: {
                        break;
                    }
                    case 6: {
                        throw new IllegalStateException(L.l("Can't commit outside of a transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back."));
                    }
                    default: {
                        this.rollbackInt();
                        throw new IllegalStateException(L.l("can't commit {0}", (Object)String.valueOf(this._status)));
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " committing");
            }
            try {
                this.callBeforeCompletion();
            }
            catch (RollbackException e) {
                this.rollbackInt();
                throw e;
            }
            catch (Throwable e) {
                this.setRollbackOnly(e);
                this.rollbackInt();
                throw new RollbackException(e);
            }
            if (this._status == 1) {
                this.rollbackInt();
                if (this._rollbackException != null) {
                    throw new RollbackExceptionWrapper(this._rollbackException);
                }
                throw new RollbackException(L.l("Transaction has been marked rolled back."));
            }
            if (this._resourceCount > 0) {
                XAResource resource;
                int i;
                this._status = 7;
                AbstractXALogStream xaLog = this._manager.getXALogStream();
                boolean hasPrepare = false;
                boolean allowSinglePhase = false;
                for (i = this._resourceCount - 1; i >= 0; --i) {
                    resource = this._resources[i];
                    if (!(i != 0 || xaLog != null && hasPrepare)) {
                        this._resourceState[0] = this._resourceState[0] | 8;
                        allowSinglePhase = true;
                        break;
                    }
                    if ((this._resourceState[i] & 2) != 0) continue;
                    try {
                        int prepare = resource.prepare(this._resourceXid[i]);
                        if (prepare == 3) continue;
                        if (prepare == 0) {
                            hasPrepare = true;
                            int n = i;
                            this._resourceState[n] = this._resourceState[n] | 8;
                            continue;
                        }
                        log.finer(this + " unexpected prepare result " + prepare);
                        this.rollbackInt();
                        continue;
                    }
                    catch (XAException e) {
                        heuristicExn = this.heuristicException(heuristicExn, e);
                        this.rollbackInt();
                        throw new RollbackExceptionWrapper(L.l("all commits rolled back"), heuristicExn);
                    }
                }
                if (hasPrepare && xaLog != null) {
                    this._xaLog = xaLog;
                    xaLog.writeTMCommit(this._xid);
                }
                this._status = 8;
                if (allowSinglePhase) {
                    try {
                        XAResource resource2 = this._resources[0];
                        if ((this._resourceState[0] & 8) != 0) {
                            resource2.commit(this._xid, true);
                        }
                        if (this._timeout > 0L) {
                            resource2.setTransactionTimeout(0);
                        }
                    }
                    catch (XAException e) {
                        log.log(Level.FINE, e.toString(), e);
                        heuristicExn = this.heuristicException(heuristicExn, e);
                    }
                }
                for (i = 0; i < this._resourceCount; ++i) {
                    resource = this._resources[i];
                    if (i == 0 && allowSinglePhase || (this._resourceState[i] & 2) != 0 || (this._resourceState[i] & 8) == 0) continue;
                    if (heuristicExn == null) {
                        try {
                            resource.commit(this._resourceXid[i], false);
                            if (this._timeout <= 0L) continue;
                            resource.setTransactionTimeout(0);
                        }
                        catch (XAException e) {
                            heuristicExn = e;
                            log.log(Level.FINE, e.toString(), e);
                        }
                        continue;
                    }
                    try {
                        resource.rollback(this._resourceXid[i]);
                        if (this._timeout <= 0L) continue;
                        resource.setTransactionTimeout(0);
                        continue;
                    }
                    catch (XAException e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                }
            }
            if (heuristicExn != null && log.isLoggable(Level.FINE)) {
                log.fine(this + " " + heuristicExn);
            }
            if (heuristicExn != null) {
                if (heuristicExn instanceof RollbackException) {
                    this._status = 4;
                    throw (RollbackException)((Object)heuristicExn);
                }
                if (heuristicExn instanceof HeuristicMixedException) {
                    this._status = 4;
                    throw (HeuristicMixedException)((Object)heuristicExn);
                }
                if (heuristicExn instanceof HeuristicRollbackException) {
                    this._status = 4;
                    throw (HeuristicRollbackException)((Object)heuristicExn);
                }
                if (heuristicExn instanceof SystemException) {
                    this._status = 4;
                    throw (SystemException)heuristicExn;
                }
                this._status = 4;
                throw RollbackExceptionWrapper.create(heuristicExn);
            }
            this._status = 3;
            Object var9_15 = null;
            this.callAfterCompletion();
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            this.callAfterCompletion();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this._alarm.dequeue();
        try {
            this.callBeforeCompletion();
        }
        catch (Throwable e) {
            this.setRollbackOnly(e);
        }
        try {
            switch (this._status) {
                case 0: 
                case 1: {
                    break;
                }
                case 6: {
                    throw new IllegalStateException(L.l("Can't rollback outside of a transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back."));
                }
                default: {
                    this.rollbackInt();
                    throw new IllegalStateException(L.l("Can't rollback in state: {0}", (Object)String.valueOf(this._status)));
                }
            }
            this._status = 1;
            this.rollbackInt();
            Object var3_2 = null;
            this.callAfterCompletion();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.callAfterCompletion();
            throw throwable;
        }
    }

    private Exception heuristicException(Exception oldException, XAException xaException) {
        switch (xaException.errorCode) {
            case 7: 
            case 8: {
                return oldException;
            }
            case 6: {
                if (oldException instanceof HeuristicMixedException) {
                    return oldException;
                }
                if (oldException instanceof HeuristicRollbackException) {
                    return oldException;
                }
                if (oldException instanceof RollbackException) {
                    return oldException;
                }
                return new HeuristicRollbackException(TransactionImpl.getXAMessage(xaException));
            }
        }
        if (oldException instanceof SystemException) {
            return oldException;
        }
        return new SystemExceptionWrapper(TransactionImpl.getXAMessage(xaException), xaException);
    }

    private void rollbackInt() {
        this._status = 9;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback");
        }
        for (int i = 0; i < this._resourceCount; ++i) {
            XAResource resource = this._resources[i];
            if ((this._resourceState[i] & 2) != 0) continue;
            try {
                resource.rollback(this._resourceXid[i]);
                if (this._timeout <= 0L) continue;
                resource.setTransactionTimeout(0);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this._status = 4;
    }

    private void callBeforeCompletion() throws RollbackException {
        int i;
        int length = this._syncList == null ? 0 : this._syncList.size();
        for (i = 0; i < length; ++i) {
            Synchronization sync = this._syncList.get(i);
            try {
                sync.beforeCompletion();
                continue;
            }
            catch (RuntimeException e) {
                this.setRollbackOnly(e);
                throw new RollbackException((Throwable)e);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        for (i = this._resourceCount - 1; i >= 0; --i) {
            XAResource resource = this._resources[i];
            int flag = this._status == 1 ? 0x20000000 : 0x4000000;
            try {
                if ((this._resourceState[i] & 1) == 0) continue;
                resource.end(this._resourceXid[i], flag);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                this.setRollbackOnly(e);
            }
        }
    }

    private void callAfterCompletion() {
        ArrayList<Synchronization> syncList = this._syncList;
        this._syncList = null;
        this._userTransaction = null;
        XidImpl xid = this._xid;
        this._xid = null;
        int status = this._status;
        this._status = 6;
        this._rollbackException = null;
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            this._resources[i] = null;
        }
        this._resourceCount = 0;
        AbstractXALogStream xaLog = this._xaLog;
        this._xaLog = null;
        if (xaLog != null) {
            try {
                xaLog.writeTMFinish(xid);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        int length = syncList == null ? 0 : syncList.size();
        for (int i = 0; i < length; ++i) {
            Synchronization sync = syncList.get(i);
            try {
                sync.afterCompletion(status);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._props != null) {
            this._props.clear();
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this._timeout = seconds == 0 ? this._manager.getTimeout() : (seconds < 0 ? 86400000L : 1000L * (long)seconds);
    }

    public int getTransactionTimeout() throws SystemException {
        if (this._timeout < 0L) {
            return -1;
        }
        return (int)(this._timeout / 1000L);
    }

    public void handleAlarm(Alarm alarm) {
        try {
            log.warning(L.l("{0}: timed out after {1} seconds.", (Object)this, (Object)String.valueOf(this.getTransactionTimeout())));
            this.setRollbackOnly();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this._isDead = true;
        this._alarm.dequeue();
        try {
            if (this._status != 6) {
                this.rollback();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this._syncList != null) {
            this._syncList.clear();
        }
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            this._resources[i] = null;
        }
        this._resourceCount = 0;
        this._xid = null;
    }

    public String toString() {
        if (this._xid == null) {
            return "Transaction[]";
        }
        CharBuffer cb = new CharBuffer();
        cb.append("Transaction[");
        byte[] branch = this._xid.getBranchQualifier();
        this.addByte(cb, branch[0]);
        cb.append(":");
        byte[] global = this._xid.getGlobalTransactionId();
        for (int i = 24; i < 28; ++i) {
            this.addByte(cb, global[i]);
        }
        cb.append("]");
        return cb.toString();
    }

    private void addByte(CharBuffer cb, int b) {
        int h = b / 16 & 0xF;
        int l = b & 0xF;
        if (h >= 10) {
            cb.append((char)(97 + h - 10));
        } else {
            cb.append((char)(48 + h));
        }
        if (l >= 10) {
            cb.append((char)(97 + l - 10));
        } else {
            cb.append((char)(48 + l));
        }
    }

    private static String getXAMessage(XAException xaException) {
        if (xaException.getMessage() != null && !xaException.getMessage().equals("")) {
            return xaException.getMessage();
        }
        return TransactionImpl.xaName(xaException.errorCode) + ": " + TransactionImpl.xaMessage(xaException.errorCode);
    }

    private static String xaState(int xaState) {
        switch (xaState) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "MARKED-ROLLBACK";
            }
            case 2: {
                return "PREPARED";
            }
            case 3: {
                return "COMITTED";
            }
            case 4: {
                return "ROLLEDBACK";
            }
            case 7: {
                return "PREPARING";
            }
            case 8: {
                return "COMMITTING";
            }
            case 9: {
                return "ROLLING_BACK";
            }
        }
        return "XA-STATE(" + xaState + ")";
    }

    private static String xaName(int xaCode) {
        switch (xaCode) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case -3: {
                return "XA_RMERR";
            }
            case -4: {
                return "XA_NOTA";
            }
            case -5: {
                return "XA_INVAL";
            }
            case -6: {
                return "XA_PROTO";
            }
            case -7: {
                return "XA_RMFAIL";
            }
            case -8: {
                return "XA_DUPID";
            }
            case -9: {
                return "XA_OUTSIDE";
            }
        }
        return "XA(" + xaCode + ")";
    }

    private static String xaMessage(int xaCode) {
        switch (xaCode) {
            case 100: 
            case 104: {
                return L.l("Resource rolled back for an unspecified reason.");
            }
            case 101: {
                return L.l("Resource rolled back because of a communication failure.");
            }
            case 102: {
                return L.l("Resource rolled back because of a deadlock.");
            }
            case 103: {
                return L.l("Resource rolled back because of an integrity check failure.");
            }
            case 105: {
                return L.l("Resource rolled back because of a protocol error in the resource manager.");
            }
            case 106: {
                return L.l("Resource rolled back because of a timeout.");
            }
            case 107: {
                return L.l("Resource rolled back because of transient error.");
            }
            case 9: {
                return L.l("Resumption must occur where the suspension occurred.");
            }
            case 8: {
                return L.l("Resource may have been heuristically completed.");
            }
            case 7: {
                return L.l("Resource has been heuristically committed.");
            }
            case 6: {
                return L.l("Resource has been heuristically rolled back.");
            }
            case 5: {
                return L.l("Resource has been heuristically committed and rolled back.");
            }
            case 3: {
                return L.l("Resource was read-only and has been heuristically committed.");
            }
            case -3: {
                return L.l("Resource manager error.");
            }
            case -4: {
                return L.l("The XID (transaction identifier) was invalid.");
            }
            case -5: {
                return L.l("Invalid arguments were given.");
            }
            case -6: {
                return L.l("Method called in an invalid context.");
            }
            case -7: {
                return L.l("Resource manager is unavailable.");
            }
            case -8: {
                return L.l("Duplicate XID (transaction identifier).");
            }
            case -9: {
                return L.l("Resource manager called outside of transaction.");
            }
        }
        return "";
    }
}

