/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.LruCache;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPath
extends FilesystemPath {
    private static LruCache<Path, JarPath> _jarCache = new LruCache(256);
    private Path _backing;

    protected JarPath(FilesystemPath root, String userPath, String path, Path backing) {
        super(root, userPath, path);
        if (this._root == null) {
            this._root = this;
        }
        if (backing instanceof JarPath) {
            throw new IllegalStateException(backing.toString() + " is already a jar");
        }
        this._backing = backing;
    }

    public static JarPath create(Path backing) {
        if (backing instanceof JarPath) {
            return (JarPath)backing;
        }
        JarPath path = (JarPath)((Object)_jarCache.get((Object)backing));
        if (path == null) {
            path = new JarPath(null, "/", "/", backing);
            _jarCache.put((Object)backing, (Object)path);
        }
        return path;
    }

    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        if ("/".equals(userPath) && "/".equals(path)) {
            return this._root;
        }
        return new JarPath(this._root, userPath, path, this._backing);
    }

    public String getScheme() {
        return "jar";
    }

    public boolean isPathCacheable() {
        return true;
    }

    public String getURL() {
        String path = this.getFullPath();
        return this.getScheme() + ":" + this.getContainer().getURL() + "!" + path;
    }

    public Path getContainer() {
        return this._backing;
    }

    public Certificate[] getCertificates() {
        return this.getJar().getCertificates(this.getPath());
    }

    public boolean exists() {
        return this.getJar().exists(this.getPath());
    }

    public boolean isDirectory() {
        return this.getJar().isDirectory(this.getPath());
    }

    public boolean isFile() {
        return this.getJar().isFile(this.getPath());
    }

    public long getLength() {
        return this.getJar().getLength(this.getPath());
    }

    public long getLastModified() {
        return this.getJar().getLastModified(this.getPath());
    }

    public boolean canRead() {
        return this.getJar().canRead(this.getPath());
    }

    public boolean canWrite() {
        return this.getJar().canWrite(this.getPath());
    }

    public String[] list() throws IOException {
        return this.getJar().list(this.getPath());
    }

    public Manifest getManifest() throws IOException {
        return this.getJar().getManifest();
    }

    public PersistentDependency getDepend() {
        return this.getJar().getDepend();
    }

    public StreamImpl openReadImpl() throws IOException {
        return this.getJar().openReadImpl((Path)this);
    }

    protected Jar getJar() {
        return Jar.create(this._backing);
    }

    public void closeJar() {
        Jar jar = Jar.getJar(this._backing);
        if (jar != null) {
            jar.close();
        }
    }

    public String toString() {
        return "jar:(" + this._backing + ")" + this.getPath();
    }

    public int hashCode() {
        return 65531 * this.getPath().hashCode() + this.getContainer().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        JarPath jarPath = (JarPath)((Object)o);
        return this._backing.equals((Object)jarPath._backing) && this.getPath().equals(jarPath.getPath());
    }
}

