/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SSLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class JsseSSLFactory
implements SSLFactory {
    private static final Logger log = Logger.getLogger(JsseSSLFactory.class.getName());
    private static final L10N L = new L10N(JsseSSLFactory.class);
    private Path _keyStoreFile;
    private String _alias;
    private String _password;
    private String _verifyClient;
    private String _keyStoreType = "jks";
    private String _keyManagerFactory = "SunX509";
    private String _sslContext = "TLS";
    private String[] _cipherSuites;
    private KeyStore _keyStore;

    public void setCipherSuites(String[] ciphers) {
        this._cipherSuites = ciphers;
    }

    public void setKeyStoreFile(Path keyStoreFile) {
        this._keyStoreFile = keyStoreFile;
    }

    public Path getKeyStoreFile() {
        return this._keyStoreFile;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setVerifyClient(String verifyClient) {
        this._verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this._verifyClient;
    }

    public void setKeyManagerFactory(String keyManagerFactory) {
        this._keyManagerFactory = keyManagerFactory;
    }

    public void setSSLContext(String sslContext) {
        this._sslContext = sslContext;
    }

    public void setKeyStoreType(String keyStore) {
        this._keyStoreType = keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws ConfigException, IOException, GeneralSecurityException {
        if (this._keyStoreFile != null && this._password == null) {
            throw new ConfigException(L.l("'password' is required for JSSE."));
        }
        if (this._password != null && this._keyStoreFile == null) {
            throw new ConfigException(L.l("'key-store-file' is required for JSSE."));
        }
        if (this._alias != null && this._keyStoreFile == null) {
            throw new ConfigException(L.l("'alias' requires a key store for JSSE."));
        }
        if (this._keyStoreFile == null) {
            return;
        }
        this._keyStore = KeyStore.getInstance(this._keyStoreType);
        ReadStream is = this._keyStoreFile.openRead();
        try {
            this._keyStore.load((InputStream)is, this._password.toCharArray());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            is.close();
            throw throwable;
        }
        is.close();
        if (this._alias != null) {
            Key key = this._keyStore.getKey(this._alias, this._password.toCharArray());
            if (key == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding key.", (Object)this._alias));
            }
            Certificate[] certChain = this._keyStore.getCertificateChain(this._alias);
            if (certChain == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding certificate chain.", (Object)this._alias));
            }
            this._keyStore = KeyStore.getInstance(this._keyStoreType);
            this._keyStore.load(null, this._password.toCharArray());
            this._keyStore.setKeyEntry(this._alias, key, this._password.toCharArray(), certChain);
        }
    }

    public QServerSocket create(InetAddress host, int port) throws IOException, GeneralSecurityException {
        SSLServerSocketFactory factory = null;
        SSLContext sslContext = SSLContext.getInstance(this._sslContext);
        if (this._keyStore != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactory);
            kmf.init(this._keyStore, this._password.toCharArray());
            sslContext.init(kmf.getKeyManagers(), null, null);
            if (this._cipherSuites != null) {
                sslContext.createSSLEngine().setEnabledCipherSuites(this._cipherSuites);
            }
            factory = sslContext.getServerSocketFactory();
        } else {
            factory = this.createAnonymousFactory();
            ServerSocket ss = factory.createServerSocket(8666, 100);
            Socket s = ss.accept();
            System.out.println(s);
        }
        int listen = 100;
        ServerSocket serverSocket = host == null ? factory.createServerSocket(port, listen) : factory.createServerSocket(port, listen, host);
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        if ("required".equals(this._verifyClient)) {
            sslServerSocket.setNeedClientAuth(true);
        }
        return new QServerSocketWrapper(serverSocket);
    }

    private SSLServerSocketFactory createAnonymousFactory() throws IOException, GeneralSecurityException {
        throw new ConfigException(L.l("jsse-ssl requires a 'key-store-file'"));
    }

    public QServerSocket bind(QServerSocket ss) throws ConfigException, IOException, GeneralSecurityException {
        throw new ConfigException(L.l("jsse is not allowed here"));
    }
}

