/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Path;
import com.caucho.vfs.SmtpStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailtoPath
extends Path {
    protected String url;
    private ArrayList<Recipient> _to;
    private ArrayList cc;
    private ArrayList bcc;
    private HashMap<String, Object> _attributes;

    MailtoPath(MailtoPath parent, String path, ArrayList<Recipient> to, HashMap<String, Object> attr) {
        super((Path)parent);
        this.url = path;
        this._to = to;
        this._attributes = attr;
    }

    protected Path schemeWalk(String userPath, Map<String, Object> attributes, String uri, int offset) {
        StringCharCursor cursor = new StringCharCursor((CharSequence)uri, offset);
        ArrayList<Recipient> to = MailtoPath.parseAddressList(cursor);
        HashMap<String, Object> attr = new HashMap<String, Object>();
        CharBuffer buf = new CharBuffer();
        if (cursor.current() == '?') {
            char ch = cursor.next();
            while (MailtoPath.isUserChar(ch)) {
                buf.clear();
                while (MailtoPath.isUserChar(ch)) {
                    buf.append(ch);
                    ch = cursor.next();
                }
                String key = buf.toString();
                if (ch != '=') {
                    throw new RuntimeException("broken attribute at: " + ch);
                }
                buf.clear();
                ch = cursor.next();
                while (true) {
                    if (ch == '\uffff' || ch == '&') break;
                    buf.append(ch);
                    ch = cursor.next();
                }
                attr.put(key, buf.toString());
                while (ch == '&' || ch == ' ' || ch == '\t') {
                    ch = cursor.next();
                }
            }
        }
        return new MailtoPath(this, userPath, to, attr);
    }

    static ArrayList<Recipient> parseAddressList(StringCharCursor cursor) {
        ArrayList<Recipient> to = new ArrayList<Recipient>();
        char ch = cursor.current();
        CharBuffer buf = new CharBuffer();
        while (Character.isWhitespace(ch)) {
            ch = cursor.next();
        }
        while (MailtoPath.isUserChar(ch)) {
            buf.clear();
            while (MailtoPath.isUserChar(ch)) {
                buf.append(ch);
                ch = cursor.next();
            }
            Recipient rcpt = new Recipient();
            to.add(rcpt);
            rcpt.user = buf.toString();
            if (ch == '@') {
                ch = cursor.next();
                if (!MailtoPath.isUserChar(ch)) {
                    throw new RuntimeException("bad url");
                }
                buf.clear();
                while (MailtoPath.isUserChar(ch)) {
                    buf.append(ch);
                    ch = cursor.next();
                }
                rcpt.host = buf.toString();
            }
            while (ch == ',' || ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
                ch = cursor.next();
            }
        }
        return to;
    }

    private static boolean isUserChar(int ch) {
        switch (ch) {
            case 33: 
            case 36: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 94: 
            case 95: 
            case 126: {
                return true;
            }
        }
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57;
    }

    public String getURL() {
        return this.getPath();
    }

    public String getScheme() {
        return "mailto";
    }

    public String getPath() {
        return "mailto:" + this.url;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public StreamImpl openWriteImpl() throws IOException {
        return new SmtpStream(this._to, this._attributes);
    }

    static class Recipient {
        String user;
        String host;

        Recipient() {
        }
    }
}

