/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.make.DependencyList;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergePath
extends FilesystemPath {
    private ArrayList<Path> _pathList;
    private Path _bestPath;

    public MergePath() {
        super(null, "/", "/");
        this._root = this;
        this._pathList = new ArrayList();
    }

    private MergePath(MergePath root, String userPath, Map<String, Object> attributes, String path) {
        super((FilesystemPath)root, userPath, path);
    }

    protected Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        int head;
        int length = filePath.length();
        if (length <= offset || filePath.charAt(offset) != '(') {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        MergePath mergePath = new MergePath();
        mergePath.setUserPath(userPath);
        int tail = head = ++offset;
        while (tail < length) {
            char ch = filePath.charAt(tail);
            if (ch == ')') {
                if (head + 1 != tail) {
                    String subPath = filePath.substring(head, tail);
                    if (subPath.startsWith("(") && subPath.endsWith(")")) {
                        subPath = subPath.substring(1, subPath.length() - 1);
                    }
                    mergePath.addMergePath(Vfs.lookup(subPath));
                }
                if (tail + 1 == length) {
                    return mergePath;
                }
                return mergePath.fsWalk(userPath, attributes, filePath.substring(tail + 1));
            }
            if (ch == ';') {
                String subPath = filePath.substring(head, tail);
                if (subPath.startsWith("(") && subPath.endsWith(")")) {
                    subPath = subPath.substring(1, subPath.length() - 1);
                }
                mergePath.addMergePath(Vfs.lookup(subPath));
                head = ++tail;
                continue;
            }
            if (ch == '(') {
                int depth = 1;
                ++tail;
                while (tail < length) {
                    if (filePath.charAt(tail) == '(') {
                        ++depth;
                    } else if (filePath.charAt(tail) == ')') {
                        ++tail;
                        if (--depth == 0) break;
                    }
                    ++tail;
                }
                if (depth == 0) continue;
                return new NotFoundPath(filePath);
            }
            ++tail;
        }
        return new NotFoundPath(filePath);
    }

    public void addMergePath(Path path) {
        if (!(path instanceof MergePath)) {
            ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
            if (!pathList.contains(path)) {
                pathList.add(path);
            }
        } else {
            if (((MergePath)path)._root == this._root) {
                return;
            }
            MergePath mergePath = (MergePath)path;
            ArrayList<Path> subPaths = mergePath.getMergePaths();
            String pathName = "./" + mergePath._pathname + "/";
            for (int i = 0; i < subPaths.size(); ++i) {
                Path subPath = subPaths.get(i);
                this.addMergePath(subPath.lookup(pathName));
            }
        }
    }

    public void addClassPath() {
        this.addClassPath(Thread.currentThread().getContextClassLoader());
    }

    public void addClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getClassPath() : CauchoSystem.getClassPath();
        this.addClassPath(classpath);
    }

    public void addResourceClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getResourcePathSpecificFirst() : CauchoSystem.getClassPath();
        this.addClassPath(classpath);
    }

    public void addLocalClassPath() {
        this.addLocalClassPath(Thread.currentThread().getContextClassLoader());
    }

    public void addLocalClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getLocalClassPath() : System.getProperty("java.class.path");
        this.addClassPath(classpath);
    }

    public void addClassPath(String classpath) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while (head < classpath.length()) {
            tail = classpath.indexOf(sep, head);
            String segment = null;
            if (tail < 0) {
                segment = classpath.substring(head);
                head = classpath.length();
            } else {
                segment = classpath.substring(head, tail);
                head = tail + 1;
            }
            if (segment.equals("")) continue;
            if (segment.endsWith(".jar") || segment.endsWith(".zip")) {
                this.addMergePath((Path)JarPath.create(Vfs.lookup(segment)));
                continue;
            }
            this.addMergePath(Vfs.lookup(segment));
        }
    }

    public ArrayList<Path> getMergePaths() {
        return ((MergePath)this._root)._pathList;
    }

    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        ArrayList<Path> pathList = this.getMergePaths();
        if (!userPath.startsWith("/") || pathList.size() == 0) {
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        String bestPrefix = null;
        for (int i = 0; i < pathList.size(); ++i) {
            Path subPath = pathList.get(i);
            String prefix = subPath.getPath();
            if (!path.startsWith(prefix) || bestPrefix != null && bestPrefix.length() >= prefix.length()) continue;
            bestPrefix = prefix;
        }
        if (bestPrefix != null) {
            if (!(path = path.substring(bestPrefix.length())).startsWith("/")) {
                path = "/" + path;
            }
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        return pathList.get(0).lookup(userPath, attributes);
    }

    public String getScheme() {
        return this.getBestPath().getScheme();
    }

    public String getFullPath() {
        Path path = this.getBestPath();
        return path.getFullPath();
    }

    public String getNativePath() {
        Path path = this.getBestPath();
        return path.getNativePath();
    }

    public String getURL() {
        Path path = this.getBestPath();
        if (!path.exists()) {
            path = this.getWritePath();
        }
        return path.getURL();
    }

    public String getRelativePath() {
        if (this._pathname.startsWith("/")) {
            return "." + this._pathname;
        }
        return this._pathname;
    }

    public boolean exists() {
        return this.getBestPath().exists();
    }

    public boolean isDirectory() {
        return this.getBestPath().isDirectory();
    }

    public boolean isFile() {
        return this.getBestPath().isFile();
    }

    public long getLength() {
        return this.getBestPath().getLength();
    }

    public long getLastModified() {
        return this.getBestPath().getLastModified();
    }

    public boolean canRead() {
        return this.getBestPath().canRead();
    }

    public boolean canWrite() {
        return this.getBestPath().canWrite();
    }

    public ArrayList<Path> getResources(String pathName) {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList subResources = path.getResources(pathName);
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = (Path)subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    public ArrayList<Path> getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList subResources = path.getResources();
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = (Path)subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    public String[] list() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            if (!(path = path.lookup(pathname)).isDirectory()) continue;
            String[] subList = path.list();
            for (int j = 0; j < subList.length; ++j) {
                if (list.contains(subList[j])) continue;
                list.add(subList[j]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean mkdir() throws IOException {
        return this.getWritePath().mkdir();
    }

    public boolean mkdirs() throws IOException {
        return this.getWritePath().mkdirs();
    }

    public boolean remove() throws IOException {
        return this.getBestPath().remove();
    }

    public boolean renameTo(Path path) throws IOException {
        return this.getBestPath().renameTo(path);
    }

    public StreamImpl openReadImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadImpl();
        stream.setPath((Path)this);
        return stream;
    }

    public StreamImpl openWriteImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openWriteImpl();
        stream.setPath((Path)this);
        return stream;
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openReadWriteImpl();
        stream.setPath((Path)this);
        return stream;
    }

    public StreamImpl openAppendImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openAppendImpl();
        stream.setPath((Path)this);
        return stream;
    }

    public Path getWritePath() {
        ArrayList<Path> pathList;
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        if ((pathList = ((MergePath)this._root)._pathList).size() == 0) {
            return new NotFoundPath(pathname);
        }
        return pathList.get(0).lookup(pathname);
    }

    public PersistentDependency createDepend() {
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        if (pathList.size() == 1) {
            return pathList.get(0).createDepend();
        }
        DependencyList dependList = new DependencyList();
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            Path realPath = path.lookup(this._pathname);
            dependList.add(realPath.createDepend());
        }
        return dependList;
    }

    public Path getBestPath() {
        if (this._bestPath != null) {
            return this._bestPath;
        }
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            Path realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            if (!realPath.exists()) continue;
            this._bestPath = realPath;
            return realPath;
        }
        if (pathList.size() > 0) {
            Path path = pathList.get(0);
            if (pathname.startsWith("/")) {
                pathname = "." + pathname;
            }
            Path realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            return realPath;
        }
        return new NotFoundPath(this._userPath);
    }

    public String toString() {
        return "MergePath[" + this._pathname + "]";
    }
}

