/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathExistsDependency
implements Dependency {
    private static final Logger log = Logger.getLogger(PathExistsDependency.class.getName());
    Path _source;
    boolean _exists;

    public PathExistsDependency(Path source) {
        if (source instanceof JarPath) {
            source = ((JarPath)source).getContainer();
        }
        this._source = source;
        this._exists = source.exists();
    }

    public PathExistsDependency(Path source, boolean exists) {
        this._source = source;
        this._exists = exists;
    }

    public Path getPath() {
        return this._source;
    }

    public boolean isModified() {
        boolean exists = this._source.exists();
        if (exists == this._exists) {
            return false;
        }
        if (exists) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " has been created.");
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this._source.getNativePath() + " has been deleted.");
        }
        return true;
    }

    public boolean logModified(Logger log) {
        boolean exists = this._source.exists();
        if (exists == this._exists) {
            return false;
        }
        if (exists) {
            log.info(this._source.getNativePath() + " has been created.");
            return true;
        }
        log.info(this._source.getNativePath() + " has been deleted.");
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathExistsDependency)) {
            return false;
        }
        PathExistsDependency depend = (PathExistsDependency)obj;
        return this._source.equals((Object)depend._source);
    }

    public String toString() {
        return "PathExistsDependency[" + this._source + "]";
    }
}

