/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.util.IntMap;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class QSocketWrapper
extends QSocket {
    private static final Logger log = Log.open(QSocketWrapper.class);
    private static Class sslSocketClass;
    private static IntMap sslKeySizes;
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;
    private SocketStream _streamImpl;

    public QSocketWrapper() {
    }

    public QSocketWrapper(Socket s) {
        this.init(s);
    }

    public void init(Socket s) {
        this._s = s;
        this._is = null;
        this._os = null;
    }

    public Socket getSocket() {
        return this._s;
    }

    public void setReadTimeout(int ms) throws IOException {
        this._s.setSoTimeout(ms);
    }

    public InetAddress getLocalAddress() {
        return this._s.getLocalAddress();
    }

    public int getLocalPort() {
        return this._s.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        if (this._s != null) {
            return this._s.getInetAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this._s != null) {
            return this._s.getPort();
        }
        return 0;
    }

    public boolean isSecure() {
        if (this._s == null || sslSocketClass == null) {
            return false;
        }
        return sslSocketClass.isAssignableFrom(this._s.getClass());
    }

    public String getCipherSuite() {
        if (!(this._s instanceof SSLSocket)) {
            return super.getCipherSuite();
        }
        SSLSocket sslSocket = (SSLSocket)this._s;
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public int getCipherBits() {
        if (!(this._s instanceof SSLSocket)) {
            return super.getCipherBits();
        }
        SSLSocket sslSocket = (SSLSocket)this._s;
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession != null) {
            return sslKeySizes.get((Object)sslSession.getCipherSuite());
        }
        return 0;
    }

    public X509Certificate getClientCertificate() throws CertificateException {
        X509Certificate[] certs = this.getClientCertificates();
        if (certs == null || certs.length == 0) {
            return null;
        }
        return certs[0];
    }

    public X509Certificate[] getClientCertificates() throws CertificateException {
        if (sslSocketClass == null) {
            return null;
        }
        return this.getClientCertificatesImpl();
    }

    private X509Certificate[] getClientCertificatesImpl() throws CertificateException {
        if (!(this._s instanceof SSLSocket)) {
            return null;
        }
        SSLSocket sslSocket = (SSLSocket)this._s;
        SSLSession sslSession = sslSocket.getSession();
        if (sslSession == null) {
            return null;
        }
        String cipherSuite = sslSession.getCipherSuite();
        try {
            return (X509Certificate[])sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, e.toString(), e);
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public SelectableChannel getSelectableChannel() {
        if (this._s != null) {
            return this._s.getChannel();
        }
        return null;
    }

    public StreamImpl getStream() throws IOException {
        if (this._streamImpl == null) {
            this._streamImpl = new SocketStream();
        }
        this._streamImpl.init(this.getInputStream(), this.getOutputStream());
        return this._streamImpl;
    }

    private InputStream getInputStream() throws IOException {
        if (this._is == null) {
            this._is = this._s.getInputStream();
        }
        return this._is;
    }

    private OutputStream getOutputStream() throws IOException {
        if (this._os == null) {
            this._os = this._s.getOutputStream();
        }
        return this._os;
    }

    public void resetTotalBytes() {
        if (this._streamImpl != null) {
            this._streamImpl.resetTotalBytes();
        }
    }

    public long getTotalReadBytes() {
        return this._streamImpl == null ? 0L : this._streamImpl.getTotalReadBytes();
    }

    public long getTotalWriteBytes() {
        return this._streamImpl == null ? 0L : this._streamImpl.getTotalWriteBytes();
    }

    public boolean isClosed() {
        return this._s == null;
    }

    public void close() throws IOException {
        Socket s = this._s;
        this._s = null;
        InputStream is = this._is;
        this._is = null;
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "QSocketWrapper[" + this._s + "]";
    }

    static {
        try {
            sslSocketClass = Class.forName("javax.net.ssl.SSLSocket");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sslKeySizes = new IntMap();
        sslKeySizes.put((Object)"SSL_DH_anon_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put((Object)"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put((Object)"SSL_DH_anon_WITH_RC4_128_MD5", 128);
        sslKeySizes.put((Object)"SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 40);
        sslKeySizes.put((Object)"SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put((Object)"SSL_DHE_DSS_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put((Object)"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 40);
        sslKeySizes.put((Object)"SSL_RSA_WITH_RC4_128_MD5", 128);
        sslKeySizes.put((Object)"SSL_RSA_WITH_RC4_128_SHA", 128);
        sslKeySizes.put((Object)"SSL_RSA_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put((Object)"SSL_RSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put((Object)"SSL_RSA_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put((Object)"SSL_RSA_WITH_NULL_MD5", 0);
        sslKeySizes.put((Object)"SSL_RSA_WITH_NULL_SHA", 0);
        sslKeySizes.put((Object)"SSL_DSA_WITH_RC4_128_MD5", 128);
        sslKeySizes.put((Object)"SSL_DSA_WITH_RC4_128_SHA", 128);
        sslKeySizes.put((Object)"SSL_DSA_WITH_DES_CBC_SHA", 56);
        sslKeySizes.put((Object)"SSL_DSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put((Object)"SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
        sslKeySizes.put((Object)"SSL_DSA_EXPORT_WITH_RC4_40_MD5", 40);
        sslKeySizes.put((Object)"SSL_DSA_WITH_NULL_MD5", 0);
        sslKeySizes.put((Object)"SSL_DSA_WITH_NULL_SHA", 0);
    }
}

