/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.hmux.HmuxPath;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ClasspathPath;
import com.caucho.vfs.ConfigPath;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpsPath;
import com.caucho.vfs.JarScheme;
import com.caucho.vfs.JndiPath;
import com.caucho.vfs.JniFilePath;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.MemoryScheme;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.SpyScheme;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StringReader;
import com.caucho.vfs.StringWriter;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vfs {
    private static final EnvironmentLocal<Path> ENV_PWD = new EnvironmentLocal("caucho.vfs.pwd");
    private static final SchemeMap DEFAULT_SCHEME_MAP;
    private static final EnvironmentLocal<SchemeMap> _localSchemeMap;
    static FilesystemPath PWD;
    private static boolean _isInitJNI;

    private Vfs() {
    }

    public static Path lookup(String url) {
        Path pwd = Vfs.getPwd();
        if (!url.startsWith("/")) {
            return pwd.lookup(url, null);
        }
        return PWD.lookup(url, null);
    }

    public static FilesystemPath getGlobalPwd() {
        return PWD;
    }

    public static Path getPwd() {
        Path pwd = ENV_PWD.get();
        if (pwd == null) {
            if (PWD == null) {
                PWD = new FilePath(null);
            }
            pwd = PWD;
            ENV_PWD.setGlobal(pwd);
        }
        return pwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemeMap getLocalScheme() {
        EnvironmentLocal<SchemeMap> environmentLocal = _localSchemeMap;
        synchronized (environmentLocal) {
            SchemeMap map = _localSchemeMap.getLevel();
            if (map == null) {
                map = _localSchemeMap.get().copy();
                if (map == null) {
                    map = DEFAULT_SCHEME_MAP.copy();
                }
                _localSchemeMap.set(map);
            }
            return map;
        }
    }

    public static Path getPwd(ClassLoader loader) {
        return ENV_PWD.get(loader);
    }

    public static void setPwd(Path pwd) {
        Vfs.setPwd(pwd, Thread.currentThread().getContextClassLoader());
    }

    public static void setPwd(Path pwd, ClassLoader loader) {
        ENV_PWD.set(pwd, loader);
    }

    public static Path lookup() {
        return Vfs.getPwd();
    }

    public static Path lookup(String url, Map<String, Object> attr) {
        return Vfs.getPwd().lookup(url, attr);
    }

    public static Path lookupNative(String url) {
        return Vfs.getPwd().lookupNative(url, null);
    }

    public static Path lookupNative(String url, Map<String, Object> attr) {
        return Vfs.getPwd().lookupNative(url, attr);
    }

    public static ReadWritePair openReadWrite(InputStream is, OutputStream os) {
        VfsStream s = new VfsStream(is, os);
        WriteStream writeStream = new WriteStream((StreamImpl)s);
        ReadStream readStream = new ReadStream((StreamImpl)s, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream is) {
        if (is instanceof ReadStream) {
            return (ReadStream)is;
        }
        VfsStream s = new VfsStream(is, null);
        return new ReadStream((StreamImpl)s);
    }

    public static ReadStream openRead(InputStream is, WriteStream ws) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream((StreamImpl)s, ws);
    }

    public static ReadStream openRead(Reader reader) {
        if (reader instanceof ReadStream.StreamReader) {
            return ((ReadStream.StreamReader)reader).getStream();
        }
        ReaderWriterStream s = new ReaderWriterStream(reader, null);
        ReadStream is = new ReadStream((StreamImpl)s);
        try {
            is.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public static ReadStream openRead(String path) throws IOException {
        return Vfs.lookup(path).openRead();
    }

    public static ReadStream openString(String string) {
        return StringReader.open((String)string);
    }

    public static WriteStream openWrite(OutputStream os) {
        if (os instanceof WriteStream) {
            return (WriteStream)os;
        }
        VfsStream s = new VfsStream(null, os);
        return new WriteStream((StreamImpl)s);
    }

    public static WriteStream openWrite(Writer writer) {
        ReaderWriterStream s = new ReaderWriterStream(null, writer);
        WriteStream os = new WriteStream((StreamImpl)s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(CharBuffer cb) {
        StringWriter s = new StringWriter(cb);
        WriteStream os = new WriteStream((StreamImpl)s);
        try {
            os.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os;
    }

    public static WriteStream openWrite(String path) throws IOException {
        return Vfs.lookup(path).openWrite();
    }

    public static WriteStream openAppend(String path) throws IOException {
        return Vfs.lookup(path).openAppend();
    }

    public static void initJNI() {
        if (_isInitJNI) {
            return;
        }
        _isInitJNI = true;
        FilesystemPath jniFilePath = JniFilePath.create();
        if (jniFilePath != null) {
            DEFAULT_SCHEME_MAP.put("file", (Path)jniFilePath);
            SchemeMap localMap = _localSchemeMap.get();
            if (localMap != null) {
                localMap.put("file", (Path)jniFilePath);
            }
            if ((localMap = _localSchemeMap.get(ClassLoader.getSystemClassLoader())) != null) {
                localMap.put("file", (Path)jniFilePath);
            }
            PWD = jniFilePath;
            Vfs.setPwd((Path)jniFilePath);
        }
    }

    static {
        _localSchemeMap = new EnvironmentLocal();
        DEFAULT_SCHEME_MAP = new SchemeMap();
        Path.setDefaultSchemeMap((SchemeMap)DEFAULT_SCHEME_MAP);
        FilePath pwd = new FilePath(null);
        PWD = pwd;
        Vfs.setPwd((Path)pwd);
        ENV_PWD.setGlobal((Path)pwd);
        ENV_PWD.set((Path)pwd);
        _localSchemeMap.setGlobal(DEFAULT_SCHEME_MAP);
        DEFAULT_SCHEME_MAP.put("file", (Path)pwd);
        DEFAULT_SCHEME_MAP.put("memory", (Path)new MemoryScheme());
        DEFAULT_SCHEME_MAP.put("jar", (Path)new JarScheme(null));
        DEFAULT_SCHEME_MAP.put("mailto", (Path)new MailtoPath(null, null, null, null));
        DEFAULT_SCHEME_MAP.put("classpath", (Path)new ClasspathPath(null, "", ""));
        DEFAULT_SCHEME_MAP.put("http", (Path)new HttpPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("https", (Path)new HttpsPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("hmux", (Path)new HmuxPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcp", (Path)new TcpPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcps", (Path)new TcpsPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("merge", (Path)new MergePath());
        StdoutStream stdout = StdoutStream.create();
        StderrStream stderr = StderrStream.create();
        DEFAULT_SCHEME_MAP.put("stdout", stdout.getPath());
        DEFAULT_SCHEME_MAP.put("stderr", stderr.getPath());
        VfsStream nullStream = new VfsStream(null, null);
        DEFAULT_SCHEME_MAP.put("null", (Path)new ConstPath(null, (StreamImpl)nullStream));
        DEFAULT_SCHEME_MAP.put("jndi", (Path)new JndiPath());
        DEFAULT_SCHEME_MAP.put("config", (Path)new ConfigPath());
        DEFAULT_SCHEME_MAP.put("spy", (Path)new SpyScheme());
    }
}

