/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZipScanner {
    private static Logger _log;
    private char[] _cbuf = new char[256];
    private Path _path;
    private ReadStream _is;
    private boolean _isValid;
    private int _entries;
    private int _offset;
    private int _index;
    private String _name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZipScanner(Path path) {
        try {
            ReadStream is;
            block9: {
                block8: {
                    this._path = path;
                    int length = (int)path.getLength();
                    is = path.openRead();
                    try {
                        is.skip((long)(length - 22 - 7));
                        if (is.read() != 80) {
                            is.skip(6L);
                            if (is.read() != 80) {
                                Object var5_5 = null;
                                break block8;
                            }
                        }
                        if (is.read() == 75 && is.read() == 5 && is.read() == 6) {
                            this._isValid = true;
                        }
                        if (this._isValid) {
                            is.skip(6L);
                            this._entries = is.read() + (is.read() << 8);
                            is.skip(4L);
                            this._offset = is.read() + (is.read() << 8) + (is.read() << 16) + (is.read() << 24);
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        is.close();
                        throw throwable;
                    }
                }
                is.close();
                return;
            }
            Object var5_6 = null;
            is.close();
            return;
        }
        catch (Exception e) {
            ZipScanner.log().log(Level.FINER, e.toString(), e);
        }
    }

    public boolean open() throws IOException {
        if (!this._isValid) {
            return false;
        }
        this._is = this._path.openRead();
        this._is.skip((long)this._offset);
        this._index = 0;
        return true;
    }

    public boolean next() throws IOException {
        if (this._entries <= this._index) {
            return false;
        }
        ++this._index;
        ReadStream is = this._is;
        if (is.read() != 80 || is.read() != 75 || is.read() != 1 || is.read() != 2) {
            throw new IOException("illegal zip format");
        }
        is.skip(24L);
        int nameLen = is.read() + (is.read() << 8);
        int extraLen = is.read() + (is.read() << 8);
        int commentLen = is.read() + (is.read() << 8);
        is.skip(12L);
        if (this._cbuf.length < nameLen) {
            this._cbuf = new char[nameLen];
        }
        char[] cbuf = this._cbuf;
        int k = 0;
        for (int i = 0; i < nameLen; ++i) {
            int c2;
            int ch = is.read();
            if (ch < 128) {
                cbuf[k++] = (char)ch;
                continue;
            }
            if ((ch & 0xE0) == 192) {
                c2 = is.read();
                ++i;
                cbuf[k++] = (char)(((ch & 0x1F) << 6) + (c2 & 0x3F));
                continue;
            }
            c2 = is.read();
            int c3 = is.read();
            i += 2;
            cbuf[k++] = (char)(((ch & 0x1F) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F));
        }
        this._name = new String(cbuf, 0, k);
        is.skip((long)extraLen);
        is.skip((long)commentLen);
        return true;
    }

    public String getName() {
        return this._name;
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ZipScanner.class.getName());
        }
        return _log;
    }
}

