/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.bytecode;

import com.caucho.bytecode.CodeWriterAttribute;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.config.ConfigException;
import com.caucho.loader.ProxyClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.webbeans.component.ComponentImpl;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ScopeAdapter {
    private static final L10N L = new L10N(ScopeAdapter.class);
    private final Class _cl;
    private Class _proxyClass;
    private Constructor _proxyCtor;
    private static HashMap<Class, String> _prim = new HashMap();

    private ScopeAdapter(Class cl) {
        this._cl = cl;
        this.generateProxy(cl);
    }

    public static ScopeAdapter create(Class cl) {
        ScopeAdapter adapter = new ScopeAdapter(cl);
        return adapter;
    }

    public Object wrap(ComponentImpl comp) {
        try {
            Object v = this._proxyCtor.newInstance(comp);
            return v;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void generateProxy(Class cl) {
        try {
            Constructor<?> zeroCtor = null;
            for (Constructor<?> ctorItem : cl.getConstructors()) {
                if (ctorItem.getParameterTypes().length != 0 || !Modifier.isPublic(ctorItem.getModifiers()) && !Modifier.isProtected(ctorItem.getModifiers())) continue;
                zeroCtor = ctorItem;
                break;
            }
            if (zeroCtor == null) {
                throw new ConfigException(L.l("'{0}' does not have a zero-arg public or protected constructor.  Scope adapter components need a zero-arg constructor, e.g. @RequestScoped stored in @ApplicationScoped.", (Object)cl.getName()));
            }
            JavaClassLoader jLoader = new JavaClassLoader(cl.getClassLoader());
            JavaClass jClass = new JavaClass(jLoader);
            jClass.setAccessFlags(1);
            ConstantPool cp = jClass.getConstantPool();
            jClass.setWrite(true);
            jClass.setMajor(49);
            jClass.setMinor(0);
            String superClassName = cl.getName().replace('.', '/');
            String thisClassName = superClassName + "$ScopeProxy";
            jClass.setSuperClass(superClassName);
            jClass.setThisClass(thisClassName);
            JavaField jField = jClass.createField("_cxt", "Lcom/caucho/webbeans/component/ComponentImpl;");
            jField.setAccessFlags(2);
            JavaMethod ctor = jClass.createMethod("<init>", "(Lcom/caucho/webbeans/component/ComponentImpl;)V");
            ctor.setAccessFlags(1);
            CodeWriterAttribute code = ctor.createCodeWriter();
            code.setMaxLocals(2);
            code.setMaxStack(4);
            code.pushObjectVar(0);
            code.invokespecial(superClassName, "<init>", "()V", 1, 0);
            code.pushObjectVar(0);
            code.pushObjectVar(1);
            code.putField(thisClassName, jField.getName(), jField.getDescriptor());
            code.addReturn();
            code.close();
            for (Method method : this._cl.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                this.createProxyMethod(jClass, method);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            WriteStream out = Vfs.openWrite(bos);
            jClass.write(out);
            out.close();
            byte[] buffer = bos.toByteArray();
            String cleanName = thisClassName.replace('/', '.');
            this._proxyClass = new ProxyClassLoader().loadClass(cleanName, buffer);
            this._proxyCtor = this._proxyClass.getConstructors()[0];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProxyMethod(JavaClass jClass, Method method) {
        String descriptor = this.createDescriptor(method);
        JavaMethod jMethod = jClass.createMethod(method.getName(), descriptor);
        jMethod.setAccessFlags(1);
        Class<?>[] parameterTypes = method.getParameterTypes();
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1 + 2 * parameterTypes.length);
        code.setMaxStack(2 + 2 * parameterTypes.length);
        code.pushObjectVar(0);
        code.getField(jClass.getThisClass(), "_cxt", "Lcom/caucho/webbeans/component/ComponentImpl;");
        code.invoke("com/caucho/webbeans/component/ComponentImpl", "get", "()Ljava/lang/Object;", 1, 1);
        code.cast(method.getDeclaringClass().getName().replace('.', '/'));
        int stack = 1;
        int index = 1;
        for (Class<?> type : parameterTypes) {
            if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
                code.pushIntVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Long.TYPE.equals(type)) {
                code.pushLongVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            if (Float.TYPE.equals(type)) {
                code.pushFloatVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Double.TYPE.equals(type)) {
                code.pushDoubleVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            code.pushObjectVar(index);
            ++index;
            ++stack;
        }
        code.invoke(method.getDeclaringClass().getName().replace('.', '/'), method.getName(), this.createDescriptor(method), stack, 1);
        Class<?> retType = method.getReturnType();
        if (Boolean.TYPE.equals(retType) || Byte.TYPE.equals(retType) || Short.TYPE.equals(retType) || Integer.TYPE.equals(retType)) {
            code.addIntReturn();
        } else if (Long.TYPE.equals(retType)) {
            code.addLongReturn();
        } else if (Float.TYPE.equals(retType)) {
            code.addFloatReturn();
        } else if (Double.TYPE.equals(retType)) {
            code.addDoubleReturn();
        } else if (Void.TYPE.equals(retType)) {
            code.addReturn();
        } else {
            code.addObjectReturn();
        }
        code.close();
    }

    private String createDescriptor(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : method.getParameterTypes()) {
            sb.append(this.createDescriptor(param));
        }
        sb.append(")");
        sb.append(this.createDescriptor(method.getReturnType()));
        return sb.toString();
    }

    private String createDescriptor(Class cl) {
        if (cl.isArray()) {
            return "[" + this.createDescriptor(cl.getComponentType());
        }
        String primValue = _prim.get(cl);
        if (primValue != null) {
            return primValue;
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    static {
        _prim.put(Boolean.TYPE, "Z");
        _prim.put(Byte.TYPE, "B");
        _prim.put(Character.TYPE, "C");
        _prim.put(Short.TYPE, "S");
        _prim.put(Integer.TYPE, "I");
        _prim.put(Long.TYPE, "J");
        _prim.put(Float.TYPE, "F");
        _prim.put(Double.TYPE, "D");
        _prim.put(Void.TYPE, "V");
    }
}

