/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.bytecode;

import com.caucho.bytecode.CodeWriterAttribute;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.config.ConfigException;
import com.caucho.loader.ProxyClassLoader;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.webbeans.component.HandleAware;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class SerializationAdapter {
    private final Class _cl;
    private Class _proxyClass;
    private static HashMap<Class, String> _prim = new HashMap();
    private static HashMap<Class, String> _boxClass = new HashMap();

    private SerializationAdapter(Class cl) {
        this._cl = cl;
    }

    public static Class gen(Class cl) {
        if (Modifier.isFinal(cl.getModifiers())) {
            return cl;
        }
        if (HandleAware.class.isAssignableFrom(cl)) {
            return cl;
        }
        SerializationAdapter gen = new SerializationAdapter(cl);
        Class proxyClass = gen.generateProxy();
        return proxyClass;
    }

    public static void setHandle(Object obj, Object handle) {
        try {
            Class<?> cl = obj.getClass();
            for (Field field : cl.getDeclaredFields()) {
                if (!field.getName().equals("__caucho_handle")) continue;
                field.setAccessible(true);
                field.set(obj, handle);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private Class generateProxy() {
        try {
            JavaClassLoader jLoader = new JavaClassLoader(this._cl.getClassLoader());
            JavaClass jClass = new JavaClass(jLoader);
            jClass.setAccessFlags(1);
            ConstantPool cp = jClass.getConstantPool();
            jClass.setWrite(true);
            jClass.setMajor(49);
            jClass.setMinor(0);
            String superClassName = this._cl.getName().replace('.', '/');
            String thisClassName = superClassName + "$BeanProxy";
            jClass.setSuperClass(superClassName);
            jClass.setThisClass(thisClassName);
            jClass.addInterface("java/io/Serializable");
            this.generateConstructors(jClass, superClassName);
            this.generateWriteReplace(jClass);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            WriteStream out = Vfs.openWrite(bos);
            jClass.write(out);
            out.close();
            byte[] buffer = bos.toByteArray();
            String cleanName = thisClassName.replace('/', '.');
            this._proxyClass = new ProxyClassLoader().loadClass(cleanName, buffer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._proxyClass;
    }

    private void generateConstructors(JavaClass jClass, String superClassName) {
        for (Constructor<?> baseCtor : this._cl.getDeclaredConstructors()) {
            if (Modifier.isPrivate(baseCtor.getModifiers())) continue;
            SerializationAdapter.generateConstructor(jClass, superClassName, baseCtor);
        }
    }

    public static void generateConstructor(JavaClass jClass, String superClassName, Constructor baseCtor) {
        Class[] types = baseCtor.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        SerializationAdapter.createDescriptor(sb, types);
        sb.append("V");
        String descriptor = sb.toString();
        JavaMethod ctor = jClass.createMethod("<init>", descriptor);
        ctor.setAccessFlags(1);
        CodeWriterAttribute code = ctor.createCodeWriter();
        code.setMaxLocals(5 + 2 * types.length);
        code.setMaxStack(5 + 2 * types.length);
        code.pushObjectVar(0);
        SerializationAdapter.marshal(code, types);
        code.invokespecial(superClassName, "<init>", descriptor, 1, 0);
        code.addReturn();
        code.close();
    }

    private void generateWriteReplace(JavaClass jClass) {
        JavaField jField = jClass.createField("__caucho_handle", "Ljava/lang/Object;");
        jField.setAccessFlags(2);
        JavaMethod jMethod = jClass.createMethod("writeReplace", "()Ljava/lang/Object;");
        jMethod.setAccessFlags(2);
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(5);
        code.setMaxStack(5);
        code.pushObjectVar(0);
        code.getField(jClass.getThisClass(), "__caucho_handle", "Ljava/lang/Object;");
        code.addObjectReturn();
        code.close();
    }

    public static void marshal(CodeWriterAttribute code, Class[] param) {
        int stack = 1;
        int index = 1;
        for (int i = 0; i < param.length; ++i) {
            Class type = param[i];
            if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
                code.pushIntVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Long.TYPE.equals(type)) {
                code.pushLongVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            if (Float.TYPE.equals(type)) {
                code.pushFloatVar(index);
                ++index;
                ++stack;
                continue;
            }
            if (Double.TYPE.equals(type)) {
                code.pushDoubleVar(index);
                index += 2;
                stack += 2;
                continue;
            }
            code.pushObjectVar(index);
            ++index;
            ++stack;
        }
    }

    private int parameterCount(Class[] parameters) {
        int count = 0;
        for (Class param : parameters) {
            if (Long.TYPE.equals(param) || Double.TYPE.equals(param)) {
                count += 2;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static void createDescriptor(StringBuilder sb, Class[] params) {
        sb.append("(");
        for (Class param : params) {
            sb.append(SerializationAdapter.createDescriptor(param));
        }
        sb.append(")");
    }

    public static String createDescriptor(Class cl) {
        if (cl.isArray()) {
            return "[" + SerializationAdapter.createDescriptor(cl.getComponentType());
        }
        String primValue = _prim.get(cl);
        if (primValue != null) {
            return primValue;
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    static {
        _prim.put(Boolean.TYPE, "Z");
        _prim.put(Byte.TYPE, "B");
        _prim.put(Character.TYPE, "C");
        _prim.put(Short.TYPE, "S");
        _prim.put(Integer.TYPE, "I");
        _prim.put(Long.TYPE, "J");
        _prim.put(Float.TYPE, "F");
        _prim.put(Double.TYPE, "D");
        _prim.put(Void.TYPE, "V");
        _boxClass.put(Boolean.TYPE, "java/lang/Boolean");
        _boxClass.put(Byte.TYPE, "java/lang/Byte");
        _boxClass.put(Character.TYPE, "java/lang/Character");
        _boxClass.put(Short.TYPE, "java/lang/Short");
        _boxClass.put(Integer.TYPE, "java/lang/Integer");
        _boxClass.put(Long.TYPE, "java/lang/Long");
        _boxClass.put(Float.TYPE, "java/lang/Float");
        _boxClass.put(Double.TYPE, "java/lang/Double");
    }
}

