/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.Singleton;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbComponentType;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ClassComponent;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.SingletonClassComponent;
import com.caucho.webbeans.component.SingletonComponent;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.webbeans.ApplicationScoped;
import javax.webbeans.ComponentType;
import javax.webbeans.ConversationScoped;
import javax.webbeans.Dependent;
import javax.webbeans.Named;
import javax.webbeans.RequestScoped;
import javax.webbeans.ScopeType;
import javax.webbeans.SessionScoped;

public abstract class AbstractBeanConfig {
    private static final L10N L = new L10N(AbstractBeanConfig.class);
    private String _filename;
    private int _line;
    private String _name;
    private String _jndiName;
    private Class _cl;
    private WbComponentType _type;
    private ArrayList<WbBinding> _bindingList = new ArrayList();
    private Class _scope;
    private ContainerProgram _init;

    protected AbstractBeanConfig() {
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setName(String name) {
        this._name = name;
        WbBinding binding = new WbBinding();
        binding.setClass(Named.class);
        binding.addValue("value", (Object)name);
        this._bindingList.add(binding);
    }

    public String getName() {
        return this._name;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setClass(Class cl) {
        this._cl = cl;
    }

    public Class getInstanceClass() {
        return this._cl;
    }

    public void setComponentType(Class type) {
        if (!type.isAnnotationPresent(ComponentType.class)) {
            throw new ConfigException(L.l("'{0}' is an invalid component annotation.  Component types must be annotated by @ComponentType.", (Object)type.getName()));
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        this._type = webBeans.createComponentType(type);
    }

    public WbComponentType getComponentType() {
        return this._type;
    }

    public void addBinding(WbBinding binding) {
        this._bindingList.add(binding);
    }

    public void setScope(String scope) {
        if ("singleton".equals(scope)) {
            this._scope = Singleton.class;
        } else if ("dependent".equals(scope)) {
            this._scope = Dependent.class;
        } else if ("request".equals(scope)) {
            this._scope = RequestScoped.class;
        } else if ("session".equals(scope)) {
            this._scope = SessionScoped.class;
        } else if ("application".equals(scope)) {
            this._scope = ApplicationScoped.class;
        } else if ("conversation".equals(scope)) {
            this._scope = ConversationScoped.class;
        } else {
            Class<?> cl = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                cl = Class.forName(scope, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cl == null) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            if (!Annotation.class.isAssignableFrom(cl)) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            if (!cl.isAnnotationPresent(ScopeType.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            this._scope = cl;
        }
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    protected void register() {
        this.register(null, null);
    }

    protected void register(Object value) {
        this.register(value, value != null ? value.getClass() : null);
    }

    protected void register(Object value, Class api) {
        ClassComponent comp;
        WebBeansContainer webBeans = WebBeansContainer.create();
        WbWebBeans wbWebBeans = webBeans.getWbWebBeans();
        if (value != null) {
            comp = new SingletonComponent(wbWebBeans, value);
        } else {
            SingletonClassComponent classComp = new SingletonClassComponent(wbWebBeans);
            classComp.setInstanceClass(this._cl);
            comp = classComp;
        }
        if (api != null) {
            comp.setTargetType(api);
        }
        if (this._name != null) {
            comp.setName(this._name);
        }
        comp.setBindingList(this._bindingList);
        if (this._type != null) {
            comp.setType(this._type);
        } else {
            comp.setType(wbWebBeans.createComponentType(ComponentType.class));
        }
        if (this._scope != null) {
            comp.setScope(webBeans.getScopeContext(this._scope));
        }
        ((ComponentImpl)comp).init();
        webBeans.addComponent(comp);
        if (this._jndiName != null) {
            try {
                Jndi.bindDeepShort(this._jndiName, comp);
            }
            catch (NamingException e) {
                throw ConfigException.create((Throwable)e);
            }
        }
    }
}

