/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.cfg;

import com.caucho.config.ConfigException;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.Binding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.webbeans.NonBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WbBinding {
    private static final L10N L = new L10N(WbBinding.class);
    private String _signature;
    private Class _cl;
    private ArrayList<WbBindingValue> _valueList = new ArrayList();

    public WbBinding() {
    }

    public WbBinding(Annotation ann) {
        this.setClass(ann.annotationType());
        try {
            for (Method method : this._cl.getDeclaredMethods()) {
                if (method.isAnnotationPresent(NonBinding.class)) continue;
                Object value = method.invoke((Object)ann, new Object[0]);
                this._valueList.add(new WbBindingValue(method, value));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void addValue(WbBindingValue value) {
        this._valueList.add(value);
    }

    public void addValue(String name, Object value) {
        try {
            Method method = this._cl.getMethod(name, new Class[0]);
            this._valueList.add(new WbBindingValue(method, value));
        }
        catch (Exception e) {
            throw new ConfigException(L.l("{0}: '{1}' is an unknown method.", (Object)this._cl.getSimpleName(), (Object)name));
        }
    }

    public void setClass(Class cl) {
        this._cl = cl;
    }

    public void setText(String signature) {
        this._signature = signature;
    }

    public Class getBindingClass() {
        return this._cl;
    }

    public String getClassName() {
        if (this._cl != null) {
            return this._cl.getName();
        }
        return null;
    }

    public ArrayList<WbBindingValue> getValueList() {
        return this._valueList;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._signature == null) {
            throw new ConfigException(L.l("binding requires an annotation"));
        }
        int p = this._signature.indexOf(40);
        String className = p > 0 ? this._signature.substring(0, p) : this._signature;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this._cl = Class.forName(className, false, loader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public boolean isMatch(Annotation bindAnn) {
        if (!bindAnn.annotationType().equals(this._cl)) {
            return false;
        }
        for (int i = 0; i < this._valueList.size(); ++i) {
            if (this._valueList.get(i).isMatch(bindAnn)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(Binding bind) {
        if (!this._cl.equals(bind.getBindingClass())) {
            return false;
        }
        for (int i = 0; i < this._valueList.size(); ++i) {
            if (this._valueList.get(i).isMatch(bind)) continue;
            return false;
        }
        return true;
    }

    public boolean isBindingPresent(ArrayList<Annotation> bindingList) {
        for (int i = 0; i < bindingList.size(); ++i) {
            Annotation ann = bindingList.get(i);
            if (!ann.annotationType().equals(this._cl)) continue;
            return true;
        }
        return false;
    }

    public long generateCrc64(long crc64) {
        crc64 = Crc64.generate((long)crc64, (String)this._cl.getName());
        for (WbBindingValue value : this._valueList) {
            crc64 = Crc64.generate((long)crc64, (String)value.getName());
            crc64 = Crc64.generate((long)crc64, (String)String.valueOf(value.getValue()));
        }
        return crc64;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WbBinding)) {
            return false;
        }
        WbBinding binding = (WbBinding)o;
        if (!this._cl.equals(binding._cl)) {
            return false;
        }
        int size = this._valueList.size();
        if (size != binding._valueList.size()) {
            return false;
        }
        for (int i = size - 1; i >= 0; --i) {
            WbBindingValue value = this._valueList.get(i);
            if (binding._valueList.contains(value)) continue;
            return false;
        }
        return true;
    }

    public Binding toBinding() {
        Binding binding = new Binding(this._cl);
        for (WbBindingValue value : this._valueList) {
            binding.put(value.getName(), value.getValue());
        }
        return binding;
    }

    public String toSignature() {
        if (this._signature == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this._cl.getName());
            sb.append("(");
            for (int i = 0; i < this._valueList.size(); ++i) {
                WbBindingValue value = this._valueList.get(i);
                if (value.getValue() == null) continue;
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(value.getName());
                sb.append("=");
                this.addValue(sb, value.getValue());
            }
            sb.append(")");
            this._signature = sb.toString();
        }
        return this._signature;
    }

    private void addValue(StringBuilder sb, Object value) {
        if (value.getClass().isArray()) {
            sb.append("{");
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                this.addValue(sb, array[i]);
            }
            sb.append("}");
        } else if (value instanceof String) {
            String string = (String)value;
            sb.append("\"");
            block5: for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block5;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block5;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            sb.append("\"");
        } else {
            sb.append(value);
        }
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this._cl.getSimpleName());
        if (this._valueList.size() == 0) {
            return sb.toString();
        }
        sb.append("(");
        for (int i = 0; i < this._valueList.size(); ++i) {
            Object objValue;
            WbBindingValue value = this._valueList.get(i);
            if (i != 0) {
                sb.append(",");
            }
            if (!value.getName().equals("value")) {
                sb.append(value.getName());
                sb.append("=");
            }
            if ((objValue = value.getValue()) instanceof String) {
                sb.append("\"");
                sb.append(objValue);
                sb.append("\"");
                continue;
            }
            sb.append(objValue);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toDebugString();
    }

    public static class WbBindingValue {
        private Method _method;
        private Object _value;

        WbBindingValue(Method method, Object value) {
            this._method = method;
            this._value = value;
        }

        public String getName() {
            return this._method.getName();
        }

        public Object getValue() {
            return this._value;
        }

        boolean isMatch(Annotation ann) {
            try {
                Object value = this._method.invoke((Object)ann, new Object[0]);
                if (value == this._value) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                return value.equals(this._value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }

        boolean isMatch(Binding binding) {
            String key = this._method.getName();
            Object value = binding.get(key);
            if (value == this._value) {
                return true;
            }
            if (value == null) {
                return false;
            }
            return value.equals(this._value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WbBindingValue)) {
                return false;
            }
            WbBindingValue value = (WbBindingValue)o;
            if (!this._method.equals(value._method)) {
                return false;
            }
            if (this._value == value._value) {
                return true;
            }
            return this._value != null && this._value.equals(value._value);
        }

        public String toString() {
            return "WbBinding[" + this._method.getName() + ", " + this._value + "]";
        }
    }
}

