/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyStringProgram;
import com.caucho.ejb.cfg.StatefulBeanConfig;
import com.caucho.ejb.cfg.StatelessBeanConfig;
import com.caucho.util.L10N;
import com.caucho.webbeans.Singleton;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbComponentType;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ClassComponent;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.SingletonClassComponent;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.webbeans.ApplicationScoped;
import javax.webbeans.Component;
import javax.webbeans.ComponentType;
import javax.webbeans.ConversationScoped;
import javax.webbeans.Dependent;
import javax.webbeans.Named;
import javax.webbeans.RequestScoped;
import javax.webbeans.ScopeType;
import javax.webbeans.SessionScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WbComponentConfig {
    private static final L10N L = new L10N(WbComponentConfig.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private WbWebBeans _webbeans;
    private Class _cl;
    private WbComponentType _type;
    private String _name;
    private ArrayList<WbBinding> _bindingList = new ArrayList();
    private Class _scope;
    private ArrayList<ConfigProgram> _newArgs;
    private ContainerProgram _init;
    protected ComponentImpl _comp;

    public WbComponentConfig() {
        this._webbeans = WebBeansContainer.create().getWbWebBeans();
    }

    public WbComponentConfig(WbWebBeans webbeans) {
        this._webbeans = webbeans;
    }

    public void setName(String name) {
        this._name = name;
        WbBinding binding = new WbBinding();
        binding.setClass(Named.class);
        binding.addValue("value", (Object)name);
        this._bindingList.add(binding);
    }

    public String getName() {
        return this._name;
    }

    public String getMBeanName() {
        return null;
    }

    public void setType(Class type) {
        if (!type.isAnnotationPresent(ComponentType.class)) {
            throw new ConfigException(L.l("'{0}' is an invalid component annotation.  Component types must be annotated by @ComponentType.", (Object)type.getName()));
        }
        this._type = this._webbeans.createComponentType(type);
    }

    public WbComponentType getType() {
        return this._type;
    }

    public void setComponentType(WbComponentType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this._type = type;
    }

    public WbComponentType getComponentType() {
        return this._type;
    }

    public void setClass(Class cl) {
        this._cl = cl;
        if (this._name == null) {
            this._name = Introspector.decapitalize(cl.getSimpleName());
        }
    }

    public Class getClassType() {
        return this._cl;
    }

    public ComponentImpl getComponent() {
        return this._comp;
    }

    public void addBinding(WbBinding binding) {
        this._bindingList.add(binding);
    }

    public ArrayList<WbBinding> getBindingList() {
        return this._bindingList;
    }

    public void setScope(String scope) {
        if ("singleton".equals(scope)) {
            this._scope = Singleton.class;
        } else if ("dependent".equals(scope)) {
            this._scope = Dependent.class;
        } else if ("request".equals(scope)) {
            this._scope = RequestScoped.class;
        } else if ("session".equals(scope)) {
            this._scope = SessionScoped.class;
        } else if ("application".equals(scope)) {
            this._scope = ApplicationScoped.class;
        } else if ("conversation".equals(scope)) {
            this._scope = ConversationScoped.class;
        } else {
            Class<?> cl = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                cl = Class.forName(scope, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cl == null) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            if (!Annotation.class.isAssignableFrom(cl)) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            if (!cl.isAnnotationPresent(ScopeType.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @ScopeType annotation."));
            }
            this._scope = cl;
        }
    }

    public void addParam(ConfigProgram param) {
        if (this._newArgs == null) {
            this._newArgs = new ArrayList();
        }
        this._newArgs.add(param);
    }

    public void setInit(ContainerProgram init) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(init);
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public void addStringProperty(String name, String value) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(new PropertyStringProgram(name, value));
    }

    public void addOptionalStringProperty(String name, String value) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(0, new PropertyStringProgram(name, value, true));
    }

    public ComponentImpl getComponentFactory() {
        return this._comp;
    }

    @PostConstruct
    public void init() {
        if (this._cl == null) {
            throw new ConfigException(L.l("<{0}> requires a class attribute", (Object)this.getTagName()));
        }
        if (this._cl.isAnnotationPresent(Stateless.class)) {
            StatelessBeanConfig cfg = new StatelessBeanConfig(this);
            cfg.init();
            return;
        }
        if (this._cl.isAnnotationPresent(Stateful.class)) {
            StatefulBeanConfig cfg = new StatefulBeanConfig(this);
            cfg.init();
            return;
        }
        this.introspect();
        ClassComponent comp = Singleton.class.equals((Object)this._scope) ? new SingletonClassComponent(this._webbeans) : new ClassComponent(this._webbeans);
        comp.setInstanceClass(this._cl);
        comp.setTargetType(this._cl);
        if (this._name != null) {
            comp.setName(this._name);
            this.addOptionalStringProperty("name", this._name);
        }
        if (this.getMBeanName() != null) {
            comp.setMBeanName(this.getMBeanName());
        }
        comp.setBindingList(this._bindingList);
        if (this._type != null) {
            comp.setType(this._type);
        } else {
            comp.setType(this._webbeans.createComponentType(Component.class));
        }
        if (this._scope != null) {
            comp.setScope(this._webbeans.getScopeContext(this._scope));
        }
        if (this._newArgs != null) {
            comp.setNewArgs(this._newArgs);
        }
        if (this._init != null) {
            comp.setInit(this._init);
        }
        this._comp = comp;
        this.introspectPostInit();
        comp.init();
        this.deploy();
    }

    protected String getTagName() {
        return "component";
    }

    protected void introspectPostInit() {
    }

    protected void deploy() {
        if (this._comp != null) {
            this._webbeans.addWbComponent(this._comp);
            this._webbeans.init();
        }
    }

    public Object getObject() {
        return this._comp.get();
    }

    public Object createObjectNoInit() {
        return this._comp.createNoInit();
    }

    private void introspect() {
        if (this._scope == null) {
            for (Annotation ann : this._cl.getDeclaredAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(ScopeType.class)) continue;
                if (this._scope != null) {
                    throw new ConfigException(L.l("{0}: multiple scope annotations are forbidden ({1} and {2}).", (Object)this._cl.getName(), (Object)this._scope.getSimpleName(), (Object)ann.annotationType().getSimpleName()));
                }
                this._scope = ann.annotationType();
            }
        }
    }
}

